/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.locals;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.locals.LocalVariableType;
import org.truffleruby.language.locals.ReadFrameSlotNode;
import org.truffleruby.language.locals.ReadFrameSlotNodeGen;
import org.truffleruby.language.locals.ReadLocalNode;
import org.truffleruby.language.locals.WriteLocalNode;
import org.truffleruby.language.locals.WriteLocalVariableNode;

public final class ReadLocalVariableNode
extends ReadLocalNode {
    public ReadLocalVariableNode(LocalVariableType type, int frameSlot) {
        super(frameSlot, type);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.readFrameSlot(frame);
    }

    @Override
    protected Object readFrameSlot(VirtualFrame frame) {
        if (this.readFrameSlotNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.readFrameSlotNode = (ReadFrameSlotNode)this.insert(ReadFrameSlotNodeGen.create(this.frameSlot));
        }
        return this.readFrameSlotNode.executeRead((Frame)frame);
    }

    @Override
    public WriteLocalNode makeWriteNode(RubyNode rhs) {
        return new WriteLocalVariableNode(this.frameSlot, rhs);
    }

    @Override
    protected String getVariableName() {
        return this.getRootNode().getFrameDescriptor().getSlotName(this.frameSlot).toString();
    }

    @Override
    public RubyNode cloneUninitialized() {
        ReadLocalVariableNode copy = new ReadLocalVariableNode(this.type, this.frameSlot);
        return copy.copyFlags(this);
    }
}

