/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.locals;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.locals.ReadFrameSlotNode;
import org.truffleruby.language.locals.ReadFrameSlotNodeGen;

public abstract class FindDeclarationVariableNodes {
    public static MaterializedFrame getOuterDeclarationFrame(MaterializedFrame topFrame) {
        MaterializedFrame nextFrame;
        MaterializedFrame frame = topFrame;
        while ((nextFrame = RubyArguments.getDeclarationFrame((Frame)frame)) != null) {
            frame = nextFrame;
        }
        return frame;
    }

    private static int findSlot(FrameDescriptor descriptor, String name) {
        assert (descriptor.getNumberOfAuxiliarySlots() == 0);
        int slots = descriptor.getNumberOfSlots();
        for (int slot = 0; slot < slots; ++slot) {
            if (!name.equals(descriptor.getSlotName(slot))) continue;
            return slot;
        }
        return -1;
    }

    public static FrameSlotAndDepth findFrameSlotOrNull(String identifier, Frame frame) {
        CompilerAsserts.neverPartOfCompilation((String)"Must not be called in PE code as the frame would escape");
        int depth = 0;
        do {
            int slot;
            if ((slot = FindDeclarationVariableNodes.findSlot(frame.getFrameDescriptor(), identifier)) != -1) {
                return new FrameSlotAndDepth(slot, depth);
            }
            frame = RubyArguments.getDeclarationFrame(frame);
            ++depth;
        } while (frame != null);
        return null;
    }

    public static final class FrameSlotAndDepth {
        public final int slot;
        public final int depth;

        public FrameSlotAndDepth(int slot, int depth) {
            assert (slot >= 0);
            this.slot = slot;
            this.depth = depth;
        }
    }

    @ReportPolymorphism
    @GenerateUncached
    @ImportStatic(value={FindDeclarationVariableNodes.class})
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class FindAndReadDeclarationVariableNode
    extends RubyBaseNode {
        public abstract Object execute(Frame var1, Node var2, String var3, Object var4);

        @Specialization(guards={"name == cachedName", "frame.getFrameDescriptor() == cachedDescriptor"}, limit="getDefaultCacheLimit()")
        static Object getVariable(Frame frame, String name, Object defaultValue, @Cached(value="name") String cachedName, @Cached(value="frame.getFrameDescriptor()") FrameDescriptor cachedDescriptor, @Cached(value="findFrameSlotOrNull(name, frame)") FrameSlotAndDepth slotAndDepth, @Cached(value="createReadNode(slotAndDepth)") ReadFrameSlotNode readNode) {
            if (readNode != null) {
                Frame storageFrame = RubyArguments.getDeclarationFrame(frame, slotAndDepth.depth);
                return readNode.executeRead(storageFrame);
            }
            return defaultValue;
        }

        @Specialization(replaces={"getVariable"})
        static Object getVariableSlow(Frame frame, String name, Object defaultValue) {
            return FindAndReadDeclarationVariableNode.getVariableSlowBoundary(frame.materialize(), name, defaultValue);
        }

        @CompilerDirectives.TruffleBoundary
        private static Object getVariableSlowBoundary(MaterializedFrame frame, String name, Object defaultValue) {
            FrameSlotAndDepth slotAndDepth = FindDeclarationVariableNodes.findFrameSlotOrNull(name, (Frame)frame);
            if (slotAndDepth == null) {
                return defaultValue;
            }
            MaterializedFrame storageFrame = RubyArguments.getDeclarationFrame(frame, slotAndDepth.depth);
            return storageFrame.getValue(slotAndDepth.slot);
        }

        protected static ReadFrameSlotNode createReadNode(FrameSlotAndDepth frameSlot) {
            if (frameSlot == null) {
                return null;
            }
            return ReadFrameSlotNodeGen.create(frameSlot.slot);
        }
    }
}

