/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.loader;

import com.oracle.truffle.api.source.Source;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Locale;
import org.truffleruby.RubyContext;
import org.truffleruby.core.string.StringUtils;

public abstract class ResourceLoader {
    public static Source loadResource(String path, boolean internal) throws IOException {
        Source source;
        assert (path.startsWith("resource:"));
        if (!path.toLowerCase(Locale.ENGLISH).endsWith(".rb")) {
            throw new FileNotFoundException(path);
        }
        Class<RubyContext> relativeClass = RubyContext.class;
        Path relativePath = Paths.get(path.substring("resource:".length()), new String[0]);
        String normalizedPath = StringUtils.replace(relativePath.normalize().toString(), '\\', '/');
        InputStream stream = relativeClass.getResourceAsStream(normalizedPath);
        if (stream == null) {
            throw new FileNotFoundException(path);
        }
        try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
            source = Source.newBuilder((String)"ruby", (Reader)reader, (String)path).internal(internal).build();
        }
        return source;
    }
}

