/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.loader;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.MaterializedFrame;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.collections.Pair;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.string.TStringWithEncoding;
import org.truffleruby.language.LexicalScope;
import org.truffleruby.language.Nil;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.RubyRootNode;
import org.truffleruby.language.arguments.EmptyArgumentsDescriptor;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.methods.DeclarationContext;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.language.methods.SharedMethodInfo;
import org.truffleruby.parser.ParserContext;
import org.truffleruby.parser.ParsingParameters;
import org.truffleruby.parser.RubySource;
import org.truffleruby.parser.TranslatorDriver;
import org.truffleruby.parser.YARPTranslatorDriver;

public final class CodeLoader {
    private final RubyLanguage language;
    private final RubyContext context;
    private final Set<String> alreadyLoadedInContext = ConcurrentHashMap.newKeySet();

    public CodeLoader(RubyLanguage language, RubyContext context) {
        this.language = language;
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    public RootCallTarget parseTopLevelWithCache(Pair<Source, TStringWithEncoding> sourceTStringPair, Node currentNode) {
        Source source = (Source)sourceTStringPair.getLeft();
        TStringWithEncoding tstringWithEncoding = (TStringWithEncoding)sourceTStringPair.getRight();
        String path = RubyLanguage.getPath(source);
        if (this.language.singleContext && !this.alreadyLoadedInContext.add(this.language.getPathRelativeToHome(path))) {
            RubySource rubySource = new RubySource(source, path, tstringWithEncoding);
            return this.parse(rubySource, ParserContext.TOP_LEVEL, null, this.context.getRootLexicalScope(), currentNode);
        }
        this.language.parsingRequestParams.set(new ParsingParameters(currentNode, tstringWithEncoding, source));
        try {
            RootCallTarget rootCallTarget = (RootCallTarget)this.context.getEnv().parseInternal(source, new String[0]);
            return rootCallTarget;
        }
        finally {
            this.language.parsingRequestParams.set(null);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public RootCallTarget parse(RubySource source, ParserContext parserContext, MaterializedFrame parentFrame, LexicalScope lexicalScope, Node currentNode) {
        TranslatorDriver translator = new TranslatorDriver(this.context, source);
        return translator.parse(source, parserContext, null, parentFrame, lexicalScope, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public RootCallTarget parseWithYARP(Object code, ParserContext parserContext, MaterializedFrame parentFrame, LexicalScope lexicalScope, Node currentNode) {
        RubySource rubySource = YARPTranslatorDriver.createRubySource(code);
        YARPTranslatorDriver translator = new YARPTranslatorDriver(this.context, rubySource);
        return translator.parse(rubySource, parserContext, null, parentFrame, lexicalScope, currentNode);
    }

    @CompilerDirectives.TruffleBoundary
    public DeferredCall prepareExecute(RootCallTarget callTarget, ParserContext parserContext, DeclarationContext declarationContext, MaterializedFrame parentFrame, Object self, LexicalScope lexicalScope) {
        return this.prepareExecute(callTarget, parserContext, declarationContext, parentFrame, self, lexicalScope, RubyNode.EMPTY_ARGUMENTS);
    }

    @CompilerDirectives.TruffleBoundary
    public DeferredCall prepareExecute(RootCallTarget callTarget, ParserContext parserContext, DeclarationContext declarationContext, MaterializedFrame parentFrame, Object self, LexicalScope lexicalScope, Object[] arguments) {
        Object[] frameArguments = this.prepareArgs(callTarget, parserContext, declarationContext, parentFrame, self, lexicalScope, arguments);
        return new DeferredCall(callTarget, frameArguments);
    }

    public Object[] prepareArgs(RootCallTarget callTarget, ParserContext parserContext, DeclarationContext declarationContext, MaterializedFrame parentFrame, Object self, LexicalScope lexicalScope, Object[] arguments) {
        InternalMethod parentMethod;
        RubyRootNode rootNode = RubyRootNode.of(callTarget);
        InternalMethod internalMethod = parentMethod = parentFrame == null ? null : RubyArguments.getMethod((Frame)parentFrame);
        RubyModule declaringModule = (parserContext == ParserContext.EVAL || parserContext == ParserContext.INSTANCE_EVAL) && parentFrame != null ? parentMethod.getDeclaringModule() : (parserContext == ParserContext.MODULE ? (RubyModule)self : this.context.getCoreLibrary().objectClass);
        SharedMethodInfo sharedMethodInfo = rootNode.getSharedMethodInfo();
        InternalMethod method = new InternalMethod(this.context, sharedMethodInfo, lexicalScope, declarationContext, sharedMethodInfo.getMethodNameForNotBlock(), declaringModule, Visibility.PUBLIC, callTarget);
        return RubyArguments.pack(parentFrame, null, method, null, self, Nil.INSTANCE, EmptyArgumentsDescriptor.INSTANCE, arguments);
    }

    public static final class DeferredCall {
        private final RootCallTarget callTarget;
        private final Object[] arguments;

        public DeferredCall(RootCallTarget callTarget, Object[] arguments) {
            this.callTarget = callTarget;
            this.arguments = arguments;
        }

        public Object call(IndirectCallNode callNode) {
            return callNode.call((CallTarget)this.callTarget, this.arguments);
        }

        public Object callWithoutCallNode() {
            return this.callTarget.call(this.arguments);
        }
    }
}

