/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.loader;

import com.oracle.truffle.api.strings.TruffleString;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.string.TStringWithEncoding;

public final class ByteBasedCharSequence
implements CharSequence {
    private final byte[] bytes;
    private final int offset;
    private final int length;
    private final RubyEncoding encoding;

    public ByteBasedCharSequence(TStringWithEncoding tstringWithEnc) {
        this(tstringWithEnc.getBytesOrCopy(), 0, tstringWithEnc.byteLength(), tstringWithEnc.encoding);
        if (tstringWithEnc.encoding == Encodings.BINARY) {
            tstringWithEnc.toJavaStringOrThrow();
        }
    }

    private ByteBasedCharSequence(byte[] bytes, int offset, int length, RubyEncoding encoding) {
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
        this.encoding = encoding;
    }

    @Override
    public int length() {
        return this.bytes.length;
    }

    @Override
    public char charAt(int index) {
        assert (index >= this.offset && index < this.offset + this.length);
        return (char)this.bytes[this.offset + index];
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return new ByteBasedCharSequence(this.bytes, start, end - start, this.encoding);
    }

    @Override
    public String toString() {
        return TruffleString.fromByteArrayUncached((byte[])this.bytes, (int)this.offset, (int)this.length, (TruffleString.Encoding)this.encoding.tencoding, (boolean)false).toJavaStringUncached();
    }
}

