/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.globals;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.kernel.TruffleKernelNodes;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.globals.GlobalVariableStorage;
import org.truffleruby.language.globals.IsDefinedGlobalVariableNode;
import org.truffleruby.language.globals.LookupGlobalVariableStorageNode;
import org.truffleruby.language.globals.ReadGlobalVariableNodeGen;
import org.truffleruby.language.globals.ReadSimpleGlobalVariableNode;
import org.truffleruby.language.yield.CallBlockNode;

public abstract class ReadGlobalVariableNode
extends RubyContextSourceNode {
    public final String name;
    @Node.Child
    LookupGlobalVariableStorageNode lookupGlobalVariableStorageNode;
    @Node.Child
    private IsDefinedGlobalVariableNode definedNode;

    public ReadGlobalVariableNode(String name) {
        this.name = name;
        this.lookupGlobalVariableStorageNode = LookupGlobalVariableStorageNode.create(name);
    }

    @Specialization(guards={"storage.isSimple()"})
    Object read(VirtualFrame frame, @Bind(value="getStorage(frame)") GlobalVariableStorage storage, @Cached(value="create(name)") ReadSimpleGlobalVariableNode simpleNode) {
        return simpleNode.execute();
    }

    @Specialization(guards={"storage.hasHooks()", "arity == 0"})
    Object readHooks(VirtualFrame frame, @Bind(value="getStorage(frame)") GlobalVariableStorage storage, @Bind(value="getterArity(storage)") int arity, @Cached @Cached.Exclusive CallBlockNode yieldNode) {
        return yieldNode.yield(storage.getGetter(), new Object[0]);
    }

    @Specialization(guards={"storage.hasHooks()", "arity == 1"})
    Object readHooksWithStorage(VirtualFrame frame, @Bind(value="getStorage(frame)") GlobalVariableStorage storage, @Bind(value="getterArity(storage)") int arity, @Cached @Cached.Exclusive CallBlockNode yieldNode, @Cached TruffleKernelNodes.GetSpecialVariableStorage storageNode) {
        return yieldNode.yield(storage.getGetter(), storageNode.execute((Frame)frame, this));
    }

    protected int getterArity(GlobalVariableStorage storage) {
        return storage.getGetter().getArityNumber();
    }

    protected GlobalVariableStorage getStorage(VirtualFrame dynamicArgument) {
        return this.lookupGlobalVariableStorageNode.execute(dynamicArgument);
    }

    @Override
    public Object isDefined(VirtualFrame frame, RubyLanguage language, RubyContext context) {
        if (this.definedNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.definedNode = (IsDefinedGlobalVariableNode)this.insert(IsDefinedGlobalVariableNode.create(this.name));
        }
        return this.definedNode.executeIsDefined(frame);
    }

    @Override
    public RubyNode cloneUninitialized() {
        ReadGlobalVariableNode copy = ReadGlobalVariableNodeGen.create(this.name);
        return copy.copyFlags(this);
    }
}

