/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.globals;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.globals.GlobalVariableStorage;
import org.truffleruby.language.globals.LookupGlobalVariableStorageNodeGen;

public abstract class LookupGlobalVariableStorageNode
extends RubyBaseNode {
    protected final String name;
    @CompilerDirectives.CompilationFinal
    protected int index = -1;

    @NeverDefault
    public static LookupGlobalVariableStorageNode create(String name) {
        return LookupGlobalVariableStorageNodeGen.create(name);
    }

    public LookupGlobalVariableStorageNode(String name) {
        this.name = name;
    }

    public final GlobalVariableStorage execute(Object dynamicArgument) {
        if (this.index == -1) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.index = this.getLanguage().getGlobalVariableIndex(this.name);
        }
        return this.executeInternal();
    }

    protected abstract GlobalVariableStorage executeInternal();

    @Specialization(guards={"isSingleContext()"}, assumptions={"getLanguage().getGlobalVariableNeverAliasedAssumption(index)"})
    GlobalVariableStorage singleContext(@Cached(value="getContext().getGlobalVariableStorage(index)") GlobalVariableStorage storage) {
        return storage;
    }

    @Specialization(assumptions={"getLanguage().getGlobalVariableNeverAliasedAssumption(index)"})
    GlobalVariableStorage multiContext() {
        return this.getContext().getGlobalVariableStorage(this.index);
    }

    @Specialization(guards={"!getLanguage().getGlobalVariableNeverAliasedAssumption(index).isValid()"})
    GlobalVariableStorage aliased() {
        return (GlobalVariableStorage)this.getContext().globalVariablesArray.get(this.index);
    }
}

