/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.globals;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import java.util.ArrayList;
import java.util.Collection;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.globals.GlobalVariableReader;
import org.truffleruby.language.globals.GlobalVariableStorage;
import org.truffleruby.language.objects.ObjectGraph;

public final class GlobalVariables {
    private final RubyContext context;
    private final RubyLanguage language;

    public GlobalVariables(RubyContext context) {
        this.context = context;
        this.language = context.getLanguageSlow();
    }

    @CompilerDirectives.TruffleBoundary
    public boolean contains(String name) {
        int index = this.language.getGlobalVariableIndex(name);
        return this.context.globalVariablesArray.contains(index);
    }

    public GlobalVariableReader getReader(String name) {
        return new GlobalVariableReader(this.language, name, this.context.globalVariablesArray);
    }

    public GlobalVariableStorage define(String name, Object value, Node node) {
        return this.define(name, new GlobalVariableStorage(value, null, null, null), node);
    }

    public GlobalVariableStorage define(String name, RubyProc getter, RubyProc setter, RubyProc isDefined, Node node) {
        return this.define(name, new GlobalVariableStorage(getter, setter, isDefined), node);
    }

    private GlobalVariableStorage define(String name, GlobalVariableStorage storage, Node node) {
        int index = this.language.getGlobalVariableIndex(name);
        GlobalVariableStorage previous = this.context.globalVariablesArray.addIfAbsent(index, storage);
        if (previous != storage) {
            throw new RaiseException(this.context, this.context.getCoreExceptions().argumentError("Global variable $" + name + " is already defined", node));
        }
        return storage;
    }

    @CompilerDirectives.TruffleBoundary
    public void alias(String oldName, String newName) {
        int oldIndex = this.language.getGlobalVariableIndex(oldName);
        GlobalVariableStorage storage = this.context.getGlobalVariableStorage(oldIndex);
        int newIndex = this.language.getGlobalVariableIndex(newName);
        GlobalVariableStorage previousStorage = this.context.globalVariablesArray.set(newIndex, storage);
        if (previousStorage != null && previousStorage != storage) {
            previousStorage.noLongerAssumeConstant();
            this.language.getGlobalVariableNeverAliasedAssumption(newIndex).invalidate(newName + " storage was overridden with " + oldName);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public String[] keys() {
        return this.context.globalVariablesArray.keys().toArray(StringUtils.EMPTY_STRING_ARRAY);
    }

    @CompilerDirectives.TruffleBoundary
    public Collection<Object> objectGraphValues() {
        Collection storages = this.context.globalVariablesArray.values();
        ArrayList<Object> values = new ArrayList<Object>();
        for (GlobalVariableStorage storage : storages) {
            Object value;
            if (storage.hasHooks() || !ObjectGraph.isRubyObject(value = storage.getValue())) continue;
            values.add(value);
        }
        return values;
    }
}

