/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.exceptions;

import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.cast.BooleanCastNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.exceptions.RescueNode;

@GeneratedBy(value=RescueNode.class)
final class RescueNodeWrapper
extends RescueNode
implements InstrumentableNode.WrapperNode {
    @Node.Child
    private RescueNode delegateNode;
    @Node.Child
    private ProbeNode probeNode;

    RescueNodeWrapper(RescueNode delegateNode, ProbeNode probeNode) {
        this.delegateNode = delegateNode;
        this.probeNode = probeNode;
    }

    public RescueNode getDelegateNode() {
        return this.delegateNode;
    }

    public ProbeNode getProbeNode() {
        return this.probeNode;
    }

    public NodeCost getCost() {
        return NodeCost.NONE;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        Object returnValue;
        while (true) {
            boolean wasOnReturnExecuted = false;
            try {
                this.probeNode.onEnter(frame);
                returnValue = this.delegateNode.execute(frame);
                wasOnReturnExecuted = true;
                this.probeNode.onReturnValue(frame, returnValue);
            }
            catch (Throwable t) {
                Object result;
                if ((result = this.probeNode.onReturnExceptionalOrUnwind(frame, t, wasOnReturnExecuted)) == ProbeNode.UNWIND_ACTION_REENTER) continue;
                if (result != null) {
                    returnValue = result;
                    break;
                }
                throw t;
            }
            break;
        }
        return returnValue;
    }

    @Override
    public RubyNode cloneUninitialized() {
        return this.delegateNode.cloneUninitialized();
    }

    @Override
    public boolean canHandle(VirtualFrame frame, Object exceptionObject, BooleanCastNode booleanCastNode) {
        return this.delegateNode.canHandle(frame, exceptionObject, booleanCastNode);
    }

    @Override
    public Object isDefined(VirtualFrame frame, RubyLanguage language, RubyContext context) {
        return this.delegateNode.isDefined(frame, language, context);
    }
}

