/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.exceptions;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrumentation.GenerateWrapper;
import com.oracle.truffle.api.instrumentation.InstrumentableNode;
import com.oracle.truffle.api.instrumentation.ProbeNode;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.cast.BooleanCastNode;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.exceptions.RescueNodeWrapper;

@GenerateWrapper
public abstract class RescueNode
extends RubyContextSourceNode {
    @Node.Child
    private RubyNode rescueBody;
    @Node.Child
    private DispatchNode callTripleEqualsNode;
    @Node.Child
    private InteropLibrary interopLibrary;
    private final BranchProfile errorProfile = BranchProfile.create();

    public RescueNode(RubyNode rescueBody) {
        this.rescueBody = rescueBody;
    }

    protected RescueNode() {
        this.rescueBody = null;
    }

    public abstract boolean canHandle(VirtualFrame var1, Object var2, BooleanCastNode var3);

    @Override
    public Object execute(VirtualFrame frame) {
        return this.rescueBody.execute(frame);
    }

    protected boolean matches(Object exceptionObject, Object handlingClass, BooleanCastNode booleanCastNode) {
        if (!(handlingClass instanceof RubyModule)) {
            if (this.interopLibrary == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.interopLibrary = (InteropLibrary)this.insert((Node)((InteropLibrary)InteropLibrary.getFactory().createDispatched(this.getInteropCacheLimit())));
            }
            if (!this.interopLibrary.isMetaObject(handlingClass)) {
                this.errorProfile.enter();
                throw new RaiseException(this.getContext(), this.coreExceptions().typeErrorRescueInvalidClause(this));
            }
        }
        if (this.callTripleEqualsNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.callTripleEqualsNode = (DispatchNode)this.insert(DispatchNode.create());
        }
        Object matches = this.callTripleEqualsNode.call(handlingClass, "===", exceptionObject);
        return booleanCastNode.execute(this, matches);
    }

    @Override
    public InstrumentableNode.WrapperNode createWrapper(ProbeNode probe) {
        return new RescueNodeWrapper(this, probe);
    }

    @Override
    public abstract Object isDefined(VirtualFrame var1, RubyLanguage var2, RubyContext var3);

    protected RubyNode getRescueBody() {
        return this.rescueBody;
    }
}

