/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.exceptions;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.truffleruby.core.exception.ExceptionOperations;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.control.KillException;
import org.truffleruby.language.exceptions.EnsureNodeGen;
import org.truffleruby.language.threadlocal.ThreadLocalGlobals;

public abstract class EnsureNode
extends RubyContextSourceNode {
    @Node.Child
    private RubyNode tryPart;
    @Node.Child
    private RubyNode ensurePart;

    public EnsureNode(RubyNode tryPart, RubyNode ensurePart) {
        this.tryPart = tryPart;
        this.ensurePart = ensurePart;
    }

    @Override
    public final Object execute(VirtualFrame frame) {
        return this.executeCommon(frame, false);
    }

    @Override
    public final void doExecuteVoid(VirtualFrame frame) {
        this.executeCommon(frame, true);
    }

    protected abstract Object executeCommon(VirtualFrame var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Specialization
    Object ensure(VirtualFrame frame, boolean executeVoid, @Cached InlinedBranchProfile killExceptionProfile, @Cached InlinedBranchProfile guestExceptionProfile, @Cached InlinedBranchProfile controlFlowExceptionProfile, @Cached InlinedConditionProfile raiseExceptionProfile) {
        Object value = nil;
        Object rethrowException = null;
        AbstractTruffleException guestException = null;
        try {
            if (executeVoid) {
                this.tryPart.doExecuteVoid(frame);
            } else {
                value = this.tryPart.execute(frame);
            }
        }
        catch (KillException e) {
            killExceptionProfile.enter((Node)this);
            rethrowException = e;
        }
        catch (AbstractTruffleException e) {
            guestExceptionProfile.enter((Node)this);
            guestException = e;
            rethrowException = e;
        }
        catch (ControlFlowException e) {
            controlFlowExceptionProfile.enter((Node)this);
            rethrowException = e;
        }
        ThreadLocalGlobals threadLocalGlobals = null;
        Object previousException = null;
        if (guestException != null) {
            Object exceptionObject = ExceptionOperations.getExceptionObject(this, guestException, raiseExceptionProfile);
            threadLocalGlobals = this.getLanguage().getCurrentThread().threadLocalGlobals;
            previousException = threadLocalGlobals.getLastException();
            threadLocalGlobals.setLastException(exceptionObject);
        }
        try {
            this.ensurePart.doExecuteVoid(frame);
        }
        finally {
            if (guestException != null) {
                threadLocalGlobals.setLastException(previousException);
            }
        }
        if (rethrowException != null) {
            throw rethrowException;
        }
        return value;
    }

    @Override
    public RubyNode cloneUninitialized() {
        EnsureNode copy = EnsureNodeGen.create(this.tryPart.cloneUninitialized(), this.ensurePart.cloneUninitialized());
        return copy.copyFlags(this);
    }
}

