/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.dispatch;

import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import org.truffleruby.core.cast.ToSymbolNode;
import org.truffleruby.core.exception.ExceptionOperations;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchConfiguration;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.dispatch.LiteralCallNode;
import org.truffleruby.language.dispatch.MissingBehavior;
import org.truffleruby.language.methods.CallForeignMethodNode;

@GenerateInline(value=false)
@GenerateUncached
@ImportStatic(value={MissingBehavior.class})
public abstract class DispatchMethodMissingNode
extends RubyBaseNode {
    public abstract Object execute(Frame var1, Object var2, String var3, Object[] var4, DispatchConfiguration var5, LiteralCallNode var6);

    @Specialization(guards={"config.missingBehavior == RETURN_MISSING"})
    static Object dispatchReturnMissing(Frame frame, Object receiver, String methodName, Object[] rubyArgs, DispatchConfiguration config, LiteralCallNode literalCallNode) {
        return DispatchNode.MISSING;
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"config.missingBehavior == CALL_METHOD_MISSING", "isForeignObject(receiver)"})
    static Object dispatchForeign(Frame frame, Object receiver, String methodName, Object[] rubyArgs, DispatchConfiguration config, LiteralCallNode literalCallNode, @Cached CallForeignMethodNode callForeign) {
        Object block = RubyArguments.getBlock(rubyArgs);
        Object[] arguments = RubyArguments.getPositionalArguments(rubyArgs);
        return callForeign.execute(receiver, methodName, block, arguments);
    }

    @HostCompilerDirectives.InliningCutoff
    @Specialization(guards={"config.missingBehavior == CALL_METHOD_MISSING", "!isForeignObject(receiver)"})
    static Object dispatchMissingMethod(Frame frame, Object receiver, String methodName, Object[] rubyArgs, DispatchConfiguration config, LiteralCallNode literalCallNode, @Cached ToSymbolNode toSymbol, @Cached DispatchNode callMethodMissing, @Cached InlinedBranchProfile methodMissingMissingProfile, @Bind(value="this") Node node) {
        RubySymbol symbolName = toSymbol.execute(node, methodName);
        Object[] newArgs = RubyArguments.repack(rubyArgs, receiver, 0, 1);
        RubyArguments.setArgument(newArgs, 0, symbolName);
        Object result = callMethodMissing.execute(frame, receiver, "method_missing", newArgs, DispatchConfiguration.PRIVATE_RETURN_MISSING_IGNORE_REFINEMENTS, literalCallNode);
        if (result == DispatchNode.MISSING) {
            methodMissingMissingProfile.enter(node);
            throw new RaiseException(DispatchMethodMissingNode.getContext(node), (RubyException)DispatchMethodMissingNode.coreExceptions(node).noMethodErrorFromMethodMissing(ExceptionOperations.ExceptionFormatter.NO_METHOD_ERROR, receiver, methodName, RubyArguments.getPositionalArguments(rubyArgs), node));
        }
        return result;
    }
}

