/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.control;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.control.BreakException;
import org.truffleruby.language.control.BreakID;
import org.truffleruby.language.control.FrameOnStackMarker;
import org.truffleruby.language.control.RaiseException;

public final class BreakNode
extends RubyContextSourceNode {
    private final BreakID breakID;
    private final boolean ignoreMarker;
    @Node.Child
    private RubyNode child;
    private final BranchProfile breakFromProcClosureProfile = BranchProfile.create();

    public BreakNode(BreakID breakID, boolean ignoreMarker, RubyNode child) {
        this.breakID = breakID;
        this.ignoreMarker = ignoreMarker;
        this.child = child;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        FrameOnStackMarker marker;
        if (!this.ignoreMarker && (marker = RubyArguments.getFrameOnStackMarker((Frame)frame)) != null && !marker.isOnStack()) {
            this.breakFromProcClosureProfile.enter();
            throw new RaiseException(this.getContext(), this.coreExceptions().breakFromProcClosure(this));
        }
        throw new BreakException(this.breakID, this.child.execute(frame));
    }

    @Override
    public RubyNode cloneUninitialized() {
        BreakNode copy = new BreakNode(this.breakID, this.ignoreMarker, this.child.cloneUninitialized());
        return copy.copyFlags(this);
    }
}

