/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.constants;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.truffleruby.core.module.ModuleOperations;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.WarnNode;

public abstract class LookupConstantBaseNode
extends RubyBaseNode {
    @Node.Child
    private WarnNode warnNode;

    protected void warnDeprecatedConstant(RubyModule module, String name) {
        if (this.warnNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.warnNode = (WarnNode)this.insert(new WarnNode());
        }
        if (this.warnNode.shouldWarnForDeprecation()) {
            this.warnNode.warningMessage(LookupConstantBaseNode.getSection(this), LookupConstantBaseNode.formatMessage(this, module, name));
        }
    }

    protected static void warnDeprecatedConstant(Node node, WarnNode warnNode, RubyModule module, String name) {
        if (warnNode.shouldWarnForDeprecation()) {
            warnNode.warningMessage(LookupConstantBaseNode.getSection(node), LookupConstantBaseNode.formatMessage(node, module, name));
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static SourceSection getSection(Node node) {
        return LookupConstantBaseNode.getContext(node).getCallStack().getTopMostUserSourceSection(LookupConstantBaseNode.getAdoptedNode(node).getEncapsulatingSourceSection());
    }

    @CompilerDirectives.TruffleBoundary
    private static String formatMessage(Node node, RubyModule module, String name) {
        return "constant " + ModuleOperations.constantName(LookupConstantBaseNode.getContext(node), module, name) + " is deprecated";
    }

    protected int getCacheLimit() {
        return this.getLanguage().options.CONSTANT_CACHE;
    }
}

