/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.constants;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.SuppressFBWarnings;
import org.truffleruby.core.module.ModuleFields;
import org.truffleruby.core.module.ModuleOperations;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.language.LexicalScope;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyConstant;
import org.truffleruby.language.constants.GetConstantNodeGen;
import org.truffleruby.language.constants.LookupConstantInterface;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.dispatch.LazyDispatchNode;
import org.truffleruby.language.loader.FeatureLoader;

public abstract class GetConstantNode
extends RubyBaseNode {
    @NeverDefault
    public static GetConstantNode create() {
        return GetConstantNodeGen.create();
    }

    public Object lookupAndResolveConstant(LexicalScope lexicalScope, RubyModule module, String name, LookupConstantInterface lookupConstantNode, boolean callConstMissing) {
        RubyConstant constant = lookupConstantNode.lookupConstant(this, lexicalScope, module, name, true);
        return this.executeGetConstant(lexicalScope, module, name, constant, lookupConstantNode, callConstMissing);
    }

    public Object lookupAndResolveConstant(LexicalScope lexicalScope, RubyModule module, String name, boolean checkName, LookupConstantInterface lookupConstantNode, boolean callConstMissing) {
        RubyConstant constant = lookupConstantNode.lookupConstant(this, lexicalScope, module, name, checkName);
        return this.executeGetConstant(lexicalScope, module, name, constant, lookupConstantNode, callConstMissing);
    }

    protected abstract Object executeGetConstant(LexicalScope var1, RubyModule var2, String var3, Object var4, LookupConstantInterface var5, boolean var6);

    @Specialization(guards={"constant != null", "constant.hasValue()"})
    Object getConstant(LexicalScope lexicalScope, RubyModule module, String name, RubyConstant constant, LookupConstantInterface lookupConstantNode, boolean callConstMissing) {
        return constant.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"autoloadConstant != null", "autoloadConstant.isAutoload()"})
    Object autoloadConstant(LexicalScope lexicalScope, RubyModule module, String name, RubyConstant autoloadConstant, LookupConstantInterface lookupConstantNode, boolean callConstMissing, @Cached @Cached.Shared LazyDispatchNode constMissingNode, @Cached DispatchNode callRequireNode) {
        Object feature = autoloadConstant.getAutoloadConstant().getFeature();
        if (autoloadConstant.getAutoloadConstant().isAutoloadingThread()) {
            return GetConstantNode.doMissingConstant(module, name, this.getSymbol(name), callConstMissing, constMissingNode.get(this));
        }
        FeatureLoader featureLoader = this.getContext().getFeatureLoader();
        String expandedPath = featureLoader.findFeature(autoloadConstant.getAutoloadConstant().getAutoloadPath());
        if (expandedPath != null && featureLoader.getFileLocks().isCurrentThreadHoldingLock(expandedPath)) {
            if (this.getContext().getOptions().LOG_AUTOLOAD) {
                RubyLanguage.LOGGER.info(() -> String.format("%s: %s::%s is being treated as missing while loading %s", this.getContext().fileLine(this.getContext().getCallStack().getTopMostUserSourceSection()), module.fields.getName(), name, expandedPath));
            }
            return GetConstantNode.doMissingConstant(module, name, this.getSymbol(name), callConstMissing, constMissingNode.get(this));
        }
        if (this.getContext().getOptions().LOG_AUTOLOAD) {
            RubyLanguage.LOGGER.info(() -> String.format("%s: autoloading %s with %s", this.getContext().fileLine(this.getContext().getCallStack().getTopMostUserSourceSection()), autoloadConstant, autoloadConstant.getAutoloadConstant().getAutoloadPath()));
        }
        GetConstantNode.autoloadConstantStart(this.getContext(), autoloadConstant, this);
        try {
            callRequireNode.call((Object)this.coreLibrary().mainObject, "require", feature);
            Object object = this.autoloadResolveConstant(lexicalScope, module, name, autoloadConstant, lookupConstantNode, callConstMissing);
            return object;
        }
        finally {
            GetConstantNode.autoloadConstantStop(autoloadConstant);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static void autoloadConstantStart(RubyContext context, RubyConstant autoloadConstant, Node currentNode) {
        autoloadConstant.getAutoloadConstant().startAutoLoad(context, currentNode);
        autoloadConstant.getDeclaringModule().fields.newConstantVersion(autoloadConstant.getName());
    }

    @CompilerDirectives.TruffleBoundary
    public static void autoloadConstantStop(RubyConstant autoloadConstant) {
        autoloadConstant.getAutoloadConstant().stopAutoLoad();
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean autoloadUndefineConstantIfStillAutoload(RubyConstant autoloadConstant) {
        RubyModule autoloadConstantModule = autoloadConstant.getDeclaringModule();
        ModuleFields fields = autoloadConstantModule.fields;
        return fields.undefineConstantIfStillAutoload(autoloadConstant);
    }

    @CompilerDirectives.TruffleBoundary
    public static void logAutoloadResult(RubyContext context, RubyConstant constant, boolean undefined) {
        if (context.getOptions().LOG_AUTOLOAD) {
            SourceSection section = context.getCallStack().getTopMostUserSourceSection();
            String message = context.fileLine(section) + ": " + constant + " " + (undefined ? "was marked as undefined as it was not assigned in " : "was successfully autoloaded from ") + constant.getAutoloadConstant().getAutoloadPath();
            RubyLanguage.LOGGER.info(message);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public Object autoloadResolveConstant(LexicalScope lexicalScope, RubyModule module, String name, RubyConstant autoloadConstant, LookupConstantInterface lookupConstantNode, boolean callConstMissing) {
        RubyModule autoloadConstantModule = autoloadConstant.getDeclaringModule();
        ModuleFields fields = autoloadConstantModule.fields;
        RubyConstant resolvedConstant = lookupConstantNode.lookupConstant(this, lexicalScope, module, name, true);
        if (resolvedConstant != null && (ModuleOperations.inAncestorsOf(resolvedConstant.getDeclaringModule(), autoloadConstantModule) || resolvedConstant.getDeclaringModule() == this.coreLibrary().objectClass)) {
            GetConstantNode.logAutoloadResult(this.getContext(), autoloadConstant, false);
        } else {
            boolean undefined = fields.undefineConstantIfStillAutoload(autoloadConstant);
            GetConstantNode.logAutoloadResult(this.getContext(), autoloadConstant, undefined);
            resolvedConstant = lookupConstantNode.lookupConstant(this, lexicalScope, module, name, true);
        }
        return this.executeGetConstant(lexicalScope, module, name, resolvedConstant, lookupConstantNode, callConstMissing);
    }

    @Specialization(guards={"isNullOrUndefined(constant)", "guardName(node, name, cachedName, sameNameProfile)"}, limit="getCacheLimit()")
    static Object missingConstantCached(LexicalScope lexicalScope, RubyModule module, String name, Object constant, LookupConstantInterface lookupConstantNode, boolean callConstMissing, @Cached(value="name") String cachedName, @Cached(value="getSymbol(name)") RubySymbol symbolName, @Cached InlinedConditionProfile sameNameProfile, @Cached @Cached.Shared LazyDispatchNode constMissingNode, @Bind(value="this") Node node) {
        return GetConstantNode.doMissingConstant(module, name, symbolName, callConstMissing, constMissingNode.get(node));
    }

    @Specialization(guards={"isNullOrUndefined(constant)"})
    Object missingConstantUncached(LexicalScope lexicalScope, RubyModule module, String name, Object constant, LookupConstantInterface lookupConstantNode, boolean callConstMissing, @Cached @Cached.Shared LazyDispatchNode constMissingNode) {
        return GetConstantNode.doMissingConstant(module, name, this.getSymbol(name), callConstMissing, constMissingNode.get(this));
    }

    private static Object doMissingConstant(RubyModule module, String name, RubySymbol symbolName, boolean callConstMissing, DispatchNode constMissingNode) {
        CompilerAsserts.partialEvaluationConstant((boolean)callConstMissing);
        if (callConstMissing) {
            return constMissingNode.call((Object)module, "const_missing", symbolName);
        }
        return null;
    }

    protected boolean isNullOrUndefined(Object constant) {
        return constant == null || ((RubyConstant)constant).isUndefined();
    }

    @SuppressFBWarnings(value={"ES"})
    protected boolean guardName(Node node, String name, String cachedName, InlinedConditionProfile sameNameProfile) {
        if (sameNameProfile.profile(node, name == cachedName)) {
            return true;
        }
        return name.equals(cachedName);
    }

    protected int getCacheLimit() {
        return this.getLanguage().options.CONSTANT_CACHE;
    }
}

