/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.arguments;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.truffleruby.core.hash.HashNodes;
import org.truffleruby.core.hash.RubyHash;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.ArgumentsDescriptor;
import org.truffleruby.language.arguments.KeywordArgumentsDescriptor;
import org.truffleruby.language.arguments.RubyArguments;

public final class ReadRestArgumentNode
extends RubyContextSourceNode {
    private final int startIndex;
    private final int postArgumentsCount;
    private final boolean keywordArguments;
    @CompilerDirectives.CompilationFinal
    boolean markKeywordHashWithFlag = false;
    private final BranchProfile noArgumentsLeftProfile = BranchProfile.create();
    private final BranchProfile subsetOfArgumentsProfile = BranchProfile.create();
    @Node.Child
    HashNodes.CopyHashAndSetRuby2KeywordsNode copyHashAndSetRuby2KeywordsNode;

    public ReadRestArgumentNode(int startIndex, int postArgumentsCount, boolean keywordArguments) {
        this.startIndex = startIndex;
        this.postArgumentsCount = postArgumentsCount;
        this.keywordArguments = keywordArguments;
    }

    private ReadRestArgumentNode(int startIndex, int postArgumentsCount, boolean keywordArguments, boolean markKeywordHashWithFlag) {
        this.startIndex = startIndex;
        this.postArgumentsCount = postArgumentsCount;
        this.keywordArguments = keywordArguments;
        this.markKeywordHashWithFlag = markKeywordHashWithFlag;
    }

    public void markKeywordHashWithFlag() {
        this.markKeywordHashWithFlag = true;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        ArgumentsDescriptor descriptor;
        if (this.markKeywordHashWithFlag && (descriptor = RubyArguments.getDescriptor((Frame)frame)) instanceof KeywordArgumentsDescriptor) {
            if (this.copyHashAndSetRuby2KeywordsNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.copyHashAndSetRuby2KeywordsNode = (HashNodes.CopyHashAndSetRuby2KeywordsNode)this.insert(HashNodes.CopyHashAndSetRuby2KeywordsNode.create());
            }
            RubyHash keywordArguments = (RubyHash)RubyArguments.getLastArgument((Frame)frame);
            RubyHash marked = this.copyHashAndSetRuby2KeywordsNode.execute(keywordArguments, true);
            RubyArguments.setLastArgument((Frame)frame, (Object)marked);
        }
        int positionalArgumentsCount = RubyArguments.getPositionalArgumentsCount((Frame)frame, this.keywordArguments);
        int endIndex = positionalArgumentsCount - this.postArgumentsCount;
        int length = endIndex - this.startIndex;
        if (this.startIndex >= endIndex) {
            this.noArgumentsLeftProfile.enter();
            return this.createEmptyArray();
        }
        this.subsetOfArgumentsProfile.enter();
        return this.createArray(RubyArguments.getRawArguments((Frame)frame, this.startIndex, length), length);
    }

    @Override
    public RubyNode cloneUninitialized() {
        ReadRestArgumentNode copy = new ReadRestArgumentNode(this.startIndex, this.postArgumentsCount, this.keywordArguments, this.markKeywordHashWithFlag);
        return copy.copyFlags(this);
    }
}

