/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.arguments;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.profiles.ConditionProfile;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.RubyArguments;

public final class ReadRemainingArgumentsNode
extends RubyContextSourceNode {
    private final int start;
    private final ConditionProfile remainingArguments = ConditionProfile.create();

    public ReadRemainingArgumentsNode(int start) {
        this.start = start;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        int count = RubyArguments.getPositionalArgumentsCount(frame.getArguments());
        if (this.remainingArguments.profile(this.start < count)) {
            return RubyArguments.getRawArguments((Frame)frame, this.start, count - this.start);
        }
        return EMPTY_ARGUMENTS;
    }

    @Override
    public RubyNode cloneUninitialized() {
        ReadRemainingArgumentsNode copy = new ReadRemainingArgumentsNode(this.start);
        return copy.copyFlags(this);
    }
}

