/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.arguments;

import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.truffleruby.language.NotProvided;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.arguments.MissingArgumentBehavior;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.utils.Utils;

public final class ReadPreArgumentNode
extends RubyContextSourceNode {
    private final int index;
    private final boolean keywordArguments;
    private final BranchProfile outOfRangeProfile = BranchProfile.create();
    private final MissingArgumentBehavior missingArgumentBehavior;

    public ReadPreArgumentNode(int index, boolean keywordArguments, MissingArgumentBehavior missingArgumentBehavior) {
        this.index = index;
        this.keywordArguments = keywordArguments;
        this.missingArgumentBehavior = missingArgumentBehavior;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        int positionalArgumentsCount = RubyArguments.getPositionalArgumentsCount((Frame)frame, this.keywordArguments);
        if (this.index < positionalArgumentsCount) {
            return RubyArguments.getArgument((Frame)frame, this.index);
        }
        this.outOfRangeProfile.enter();
        switch (this.missingArgumentBehavior) {
            case RUNTIME_ERROR: {
                throw new IndexOutOfBoundsException();
            }
            case NOT_PROVIDED: {
                return NotProvided.INSTANCE;
            }
            case NIL: {
                return nil;
            }
        }
        throw Utils.unsupportedOperation("unknown missing argument behaviour");
    }

    @Override
    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + " " + this.index;
    }

    @Override
    public RubyNode cloneUninitialized() {
        ReadPreArgumentNode copy = new ReadPreArgumentNode(this.index, this.keywordArguments, this.missingArgumentBehavior);
        return copy.copyFlags(this);
    }
}

