/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.arguments;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.collections.PEBiFunction;
import org.truffleruby.core.hash.HashGuards;
import org.truffleruby.core.hash.RubyHash;
import org.truffleruby.core.hash.library.EmptyHashStore;
import org.truffleruby.core.hash.library.HashStoreLibrary;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.RubyRootNode;
import org.truffleruby.language.arguments.MissingKeywordArgumentNode;
import org.truffleruby.language.arguments.ReadKeywordArgumentNodeGen;
import org.truffleruby.language.arguments.ReadUserKeywordsHashNode;
import org.truffleruby.language.methods.Arity;

@ImportStatic(value={HashGuards.class})
public abstract class ReadKeywordArgumentNode
extends RubyContextSourceNode
implements PEBiFunction {
    private final RubySymbol name;
    @Node.Child
    private RubyNode defaultValue;
    @Node.Child
    private ReadUserKeywordsHashNode readUserKeywordsHashNode;

    public static ReadKeywordArgumentNode create(RubySymbol name, RubyNode defaultValue) {
        return ReadKeywordArgumentNodeGen.create(name, defaultValue);
    }

    @Override
    public final Object execute(VirtualFrame frame) {
        return this.execute(frame, this.readUserKeywordsHashNode.execute(frame));
    }

    public abstract Object execute(VirtualFrame var1, RubyHash var2);

    protected ReadKeywordArgumentNode(RubySymbol name, RubyNode defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
        this.readUserKeywordsHashNode = new ReadUserKeywordsHashNode();
    }

    @Specialization(guards={"hash == null"})
    Object nullHash(VirtualFrame frame, RubyHash hash) {
        return this.getDefaultValue().execute(frame);
    }

    @Specialization(guards={"hash != null"}, limit="hashStrategyLimit()")
    Object lookupKeywordInHash(VirtualFrame frame, RubyHash hash, @CachedLibrary(value="getHashStore(hash)") HashStoreLibrary hashes) {
        return hashes.lookupOrDefault(hash.store, (Frame)frame, hash, this.name, this);
    }

    protected Object getHashStore(RubyHash hash) {
        return hash == null ? EmptyHashStore.NULL_HASH_STORE : hash.store;
    }

    @Override
    public Object accept(Frame frame, Object hash, Object key) {
        VirtualFrame virtualFrame = (VirtualFrame)frame;
        return this.getDefaultValue().execute(virtualFrame);
    }

    RubyNode getDefaultValue() {
        if (this.defaultValue == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            RubyRootNode rootNode = (RubyRootNode)this.getRootNode();
            Arity arity = rootNode.getSharedMethodInfo().getArity();
            this.defaultValue = (RubyNode)this.insert(new MissingKeywordArgumentNode(this.getLanguage(), arity));
        }
        return this.defaultValue;
    }

    @Override
    public RubyNode cloneUninitialized() {
        ReadKeywordArgumentNode copy = ReadKeywordArgumentNode.create(this.name, ReadKeywordArgumentNode.cloneUninitialized(this.defaultValue));
        return copy.copyFlags(this);
    }
}

