/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language.arguments;

import com.oracle.truffle.api.CompilerDirectives;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.array.ArrayHelpers;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.parser.ArgumentDescriptor;
import org.truffleruby.parser.ArgumentType;

public final class ArgumentDescriptorUtils {
    @CompilerDirectives.TruffleBoundary
    public static RubyArray argumentDescriptorsToParameters(RubyLanguage language, RubyContext context, ArgumentDescriptor[] argsDesc, boolean isLambda) {
        Object[] params = new Object[argsDesc.length];
        for (int i = 0; i < argsDesc.length; ++i) {
            params[i] = ArgumentDescriptorUtils.toArray(language, context, argsDesc[i], isLambda);
        }
        return ArrayHelpers.createArray(context, language, params);
    }

    private static RubyArray toArray(RubyLanguage language, RubyContext context, ArgumentDescriptor argDesc, boolean isLambda) {
        if (argDesc.type == ArgumentType.req && !isLambda) {
            return ArgumentDescriptorUtils.toArray(language, context, ArgumentType.opt, argDesc.name);
        }
        return ArgumentDescriptorUtils.toArray(language, context, argDesc.type, argDesc.name);
    }

    private static RubyArray toArray(RubyLanguage language, RubyContext context, ArgumentType argType, String name) {
        Object[] store;
        if (argType.anonymous || name == null) {
            store = new Object[]{language.getSymbol(argType.symbolicName)};
        } else {
            if (name.startsWith("_$")) {
                name = "_";
            }
            store = new Object[]{language.getSymbol(argType.symbolicName), language.getSymbol(name)};
        }
        return ArrayHelpers.createArray(context, language, store);
    }
}

