/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;

public final class SourceIndexLength {
    public static final int UNAVAILABLE = -1;
    public static final SourceIndexLength UNAVAILABLE_POSITION = new SourceIndexLength();
    private final int charIndex;
    private final int length;

    public static SourceIndexLength fromSourceSection(SourceSection sourceSection) {
        if (!sourceSection.isAvailable()) {
            return UNAVAILABLE_POSITION;
        }
        return new SourceIndexLength(sourceSection.getCharIndex(), sourceSection.getCharLength());
    }

    private SourceIndexLength() {
        this(0, -1);
    }

    public SourceIndexLength(int charIndex, int length) {
        assert (charIndex >= 0 && length >= 0 || charIndex == 0 && length == -1);
        this.charIndex = charIndex;
        this.length = length;
    }

    @CompilerDirectives.TruffleBoundary
    public SourceSection toSourceSection(Source source) {
        if (this.length == -1) {
            return source.createUnavailableSection();
        }
        return source.createSection(this.charIndex, this.length);
    }

    public boolean isAvailable() {
        return this.length != -1;
    }

    public int getCharIndex() {
        return this.charIndex;
    }

    public int getLength() {
        return this.length;
    }

    public int getCharEnd() {
        return this.charIndex + this.length;
    }
}

