/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.ThreadLocalAction;
import com.oracle.truffle.api.nodes.Node;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.fiber.RubyFiber;
import org.truffleruby.core.thread.RubyThread;
import org.truffleruby.language.SafepointPredicate;

public abstract class SafepointAction
extends ThreadLocalAction {
    private static final SafepointPredicate CURRENT_FIBER_OF_THREAD = (context, thread, action) -> thread == action.getTargetThread() && context.getLanguageSlow().getCurrentFiber() == action.getTargetThread().getCurrentFiber();
    private final boolean publicSynchronous;
    private final String reason;
    private final SafepointPredicate filter;
    private final RubyThread targetThread;
    private final AtomicBoolean executed;

    public SafepointAction(String reason, RubyThread targetThread, boolean hasSideEffects, boolean synchronous) {
        this(reason, CURRENT_FIBER_OF_THREAD, hasSideEffects, synchronous, targetThread);
    }

    public SafepointAction(String reason, SafepointPredicate filter, boolean hasSideEffects, boolean synchronous) {
        this(reason, filter, hasSideEffects, synchronous, null);
    }

    private SafepointAction(String reason, SafepointPredicate filter, boolean hasSideEffects, boolean synchronous, RubyThread targetThread) {
        super(hasSideEffects, synchronous);
        this.publicSynchronous = synchronous;
        this.reason = reason;
        this.filter = filter;
        this.targetThread = targetThread;
        this.executed = targetThread != null ? new AtomicBoolean(false) : null;
    }

    public abstract void run(RubyThread var1, Node var2);

    protected final void perform(ThreadLocalAction.Access access) {
        if (Thread.currentThread() != access.getThread()) {
            throw CompilerDirectives.shouldNotReachHere((String)("safepoint action for " + access.getThread() + " executed on other thread: " + Thread.currentThread()));
        }
        RubyLanguage language = RubyLanguage.getCurrentLanguage();
        RubyContext context = RubyLanguage.getCurrentContext();
        RubyThread rubyThread = language.getCurrentThread();
        Node node = access.getLocation();
        if (this.filter.test(context, rubyThread, this)) {
            if (this.executed == null || this.executed.compareAndSet(false, true)) {
                this.run(rubyThread, node);
            }
            if (this.filter == SafepointPredicate.ALL_THREADS_AND_FIBERS) {
                RubyFiber currentFiber = rubyThread.getCurrentFiber();
                for (RubyFiber fiber : rubyThread.runningFibers) {
                    if (fiber == currentFiber) continue;
                    context.fiberManager.safepoint(currentFiber, fiber, this, node);
                }
            }
        }
    }

    public boolean isSynchronous() {
        return this.publicSynchronous;
    }

    public RubyThread getTargetThread() {
        return Objects.requireNonNull(this.targetThread);
    }

    public String toString() {
        return this.reason + " " + Integer.toHexString(System.identityHashCode((Object)this));
    }
}

