/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.Split;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.RubyRootNode;
import org.truffleruby.language.arguments.CheckKeywordArityNode;
import org.truffleruby.language.control.NextException;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.control.RedoException;
import org.truffleruby.language.control.RetryException;
import org.truffleruby.language.control.ReturnID;
import org.truffleruby.language.methods.Arity;
import org.truffleruby.language.methods.SharedMethodInfo;
import org.truffleruby.language.methods.TranslateExceptionNode;

public final class RubyProcRootNode
extends RubyRootNode {
    @Node.Child
    private TranslateExceptionNode translateExceptionNode;
    @Node.Child
    private CheckKeywordArityNode checkKeywordArityNode;
    @CompilerDirectives.CompilationFinal
    private boolean redoProfile;
    @CompilerDirectives.CompilationFinal
    private boolean nextProfile;
    @CompilerDirectives.CompilationFinal
    private boolean retryProfile;

    public RubyProcRootNode(RubyLanguage language, SourceSection sourceSection, FrameDescriptor frameDescriptor, SharedMethodInfo sharedMethodInfo, RubyNode body, Split split, ReturnID returnID, Arity arityForCheck) {
        super(language, sourceSection, frameDescriptor, sharedMethodInfo, body, split, returnID);
        this.checkKeywordArityNode = arityForCheck.hasKeywords() && !arityForCheck.hasKeywordsRest() ? new CheckKeywordArityNode(arityForCheck) : null;
    }

    private RubyProcRootNode(RubyLanguage language, SourceSection sourceSection, FrameDescriptor frameDescriptor, SharedMethodInfo sharedMethodInfo, RubyNode body, Split split, ReturnID returnID, CheckKeywordArityNode checkKeywordArityNode) {
        super(language, sourceSection, frameDescriptor, sharedMethodInfo, body, split, returnID);
        this.checkKeywordArityNode = checkKeywordArityNode;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        TruffleSafepoint.poll((Node)this);
        if (this.checkKeywordArityNode != null) {
            this.checkKeywordArityNode.checkArity(frame);
        }
        try {
            while (true) {
                try {
                    return this.body.execute(frame);
                }
                catch (RedoException e) {
                    if (!this.redoProfile) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.redoProfile = true;
                    }
                    TruffleSafepoint.poll((Node)this);
                    continue;
                }
                break;
            }
        }
        catch (RetryException e) {
            if (!this.retryProfile) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.retryProfile = true;
            }
            throw new RaiseException(this.getContext(), (RubyException)this.getContext().getCoreExceptions().syntaxErrorInvalidRetry((Node)this));
        }
        catch (NextException e) {
            if (!this.nextProfile) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.nextProfile = true;
            }
            return e.getResult();
        }
        catch (Throwable t) {
            if (this.translateExceptionNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.translateExceptionNode = (TranslateExceptionNode)this.insert(TranslateExceptionNode.create());
            }
            throw this.translateExceptionNode.executeTranslation(t);
        }
    }

    @Override
    protected RubyRootNode cloneUninitializedRootNode() {
        CheckKeywordArityNode checkKeywordArityNodeCopy = this.checkKeywordArityNode == null ? null : this.checkKeywordArityNode.cloneUninitialized();
        return new RubyProcRootNode(this.getLanguage(), this.getSourceSection(), this.getFrameDescriptor(), this.getSharedMethodInfo(), this.body.cloneUninitialized(), this.getSplit(), this.returnID, checkKeywordArityNodeCopy);
    }
}

