/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.Split;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.language.RubyCheckArityRootNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.RubyRootNode;
import org.truffleruby.language.control.BreakException;
import org.truffleruby.language.control.BreakID;
import org.truffleruby.language.control.DynamicReturnException;
import org.truffleruby.language.control.LocalReturnException;
import org.truffleruby.language.control.NextException;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.control.RedoException;
import org.truffleruby.language.control.RetryException;
import org.truffleruby.language.control.ReturnID;
import org.truffleruby.language.methods.Arity;
import org.truffleruby.language.methods.SharedMethodInfo;
import org.truffleruby.language.methods.TranslateExceptionNode;

public final class RubyLambdaRootNode
extends RubyCheckArityRootNode {
    public final BreakID breakID;
    @Node.Child
    private TranslateExceptionNode translateExceptionNode;
    @CompilerDirectives.CompilationFinal
    private boolean localReturnProfile;
    @CompilerDirectives.CompilationFinal
    private boolean retryProfile;
    @CompilerDirectives.CompilationFinal
    private boolean matchingReturnProfile;
    @CompilerDirectives.CompilationFinal
    private boolean nonMatchingReturnProfile;
    @CompilerDirectives.CompilationFinal
    private boolean matchingBreakProfile;
    @CompilerDirectives.CompilationFinal
    private boolean nonMatchingBreakProfile;
    @CompilerDirectives.CompilationFinal
    private boolean redoProfile;
    @CompilerDirectives.CompilationFinal
    private boolean nextProfile;

    public static RubyLambdaRootNode of(RootCallTarget callTarget) {
        return (RubyLambdaRootNode)callTarget.getRootNode();
    }

    public RubyLambdaRootNode(RubyLanguage language, SourceSection sourceSection, FrameDescriptor frameDescriptor, SharedMethodInfo sharedMethodInfo, RubyNode body, Split split, ReturnID returnID, BreakID breakID, Arity arityForCheck) {
        super(language, sourceSection, frameDescriptor, sharedMethodInfo, body, split, returnID, arityForCheck);
        this.breakID = breakID;
    }

    public RubyLambdaRootNode copyRootNode(SharedMethodInfo newSharedMethodInfo, RubyNode newBody) {
        return new RubyLambdaRootNode(this.getLanguage(), this.getSourceSection(), this.getFrameDescriptor(), newSharedMethodInfo, newBody, this.getSplit(), this.returnID, this.breakID, this.arityForCheck);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        TruffleSafepoint.poll((Node)this);
        this.checkArity(frame);
        try {
            while (true) {
                try {
                    return this.body.execute(frame);
                }
                catch (RedoException e) {
                    if (!this.redoProfile) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        this.redoProfile = true;
                    }
                    TruffleSafepoint.poll((Node)this);
                    continue;
                }
                break;
            }
        }
        catch (LocalReturnException e) {
            if (!this.localReturnProfile) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.localReturnProfile = true;
            }
            return e.getValue();
        }
        catch (DynamicReturnException e) {
            if (this.returnID != ReturnID.INVALID && e.getReturnID() == this.returnID) {
                if (!this.matchingReturnProfile) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.matchingReturnProfile = true;
                }
                return e.getValue();
            }
            if (!this.nonMatchingReturnProfile) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.nonMatchingReturnProfile = true;
            }
            throw e;
        }
        catch (RetryException e) {
            if (!this.retryProfile) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.retryProfile = true;
            }
            throw new RaiseException(this.getContext(), (RubyException)this.getContext().getCoreExceptions().syntaxErrorInvalidRetry((Node)this));
        }
        catch (NextException e) {
            if (!this.nextProfile) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.nextProfile = true;
            }
            return e.getResult();
        }
        catch (BreakException e) {
            if (this.breakID != BreakID.INVALID && e.getBreakID() == this.breakID) {
                if (!this.matchingBreakProfile) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.matchingBreakProfile = true;
                }
                return e.getResult();
            }
            if (!this.nonMatchingBreakProfile) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.nonMatchingBreakProfile = true;
            }
            throw e;
        }
        catch (Throwable t) {
            if (this.translateExceptionNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.translateExceptionNode = (TranslateExceptionNode)this.insert(TranslateExceptionNode.create());
            }
            throw this.translateExceptionNode.executeTranslation(t);
        }
    }

    @Override
    protected RubyRootNode cloneUninitializedRootNode() {
        return new RubyLambdaRootNode(this.getLanguage(), this.getSourceSection(), this.getFrameDescriptor(), this.getSharedMethodInfo(), this.body.cloneUninitialized(), this.getSplit(), this.returnID, this.breakID, this.arityForCheck);
    }
}

