/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.binding.RubyBinding;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.string.StringOperations;
import org.truffleruby.language.RubyBaseRootNode;
import org.truffleruby.language.backtrace.InternalRootNode;
import org.truffleruby.language.dispatch.DispatchNode;

public final class RubyEvalInteractiveRootNode
extends RubyBaseRootNode
implements InternalRootNode {
    private final TruffleString sourceString;
    @Node.Child
    DispatchNode callEvalNode = DispatchNode.create();

    public RubyEvalInteractiveRootNode(RubyLanguage language, Source source) {
        super(language, null, null);
        this.sourceString = TStringUtils.utf8TString(source.getCharacters().toString());
    }

    public Object execute(VirtualFrame frame) {
        RubyContext context = this.getContext();
        RubyBinding interactiveBinding = context.getCoreLibrary().interactiveBinding;
        return this.callEvalNode.call((Object)interactiveBinding, "eval", (Object)StringOperations.createUTF8String(context, this.getLanguage(), (AbstractTruffleString)this.sourceString));
    }

    public String getName() {
        return "Context#eval(interactiveRubySource)";
    }
}

