/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.Split;
import org.truffleruby.builtins.CoreMethodNodeManager;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyCheckArityRootNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.RubyRootNode;
import org.truffleruby.language.control.ReturnID;
import org.truffleruby.language.methods.Arity;
import org.truffleruby.language.methods.SharedMethodInfo;
import org.truffleruby.language.methods.TranslateExceptionNode;

public final class RubyCoreMethodRootNode
extends RubyCheckArityRootNode {
    private final NodeFactory<? extends RubyBaseNode> nodeFactory;
    private final CoreMethod coreMethod;
    @Node.Child
    private TranslateExceptionNode translateExceptionNode;

    public RubyCoreMethodRootNode(RubyLanguage language, SourceSection sourceSection, FrameDescriptor frameDescriptor, SharedMethodInfo sharedMethodInfo, RubyNode body, Split split, ReturnID returnID, Arity arityForCheck, NodeFactory<? extends RubyBaseNode> nodeFactory, CoreMethod coreMethod) {
        super(language, sourceSection, frameDescriptor, sharedMethodInfo, body, split, returnID, arityForCheck);
        this.nodeFactory = nodeFactory;
        this.coreMethod = coreMethod;
    }

    @Override
    public Object execute(VirtualFrame frame) {
        TruffleSafepoint.poll((Node)this);
        this.checkArity(frame);
        try {
            return this.body.execute(frame);
        }
        catch (Throwable t) {
            if (this.translateExceptionNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.translateExceptionNode = (TranslateExceptionNode)this.insert(TranslateExceptionNode.create());
            }
            throw this.translateExceptionNode.executeTranslation(t);
        }
    }

    @Override
    protected RubyRootNode cloneUninitializedRootNode() {
        return CoreMethodNodeManager.createCoreMethodRootNode(this.nodeFactory, this.getLanguage(), this.getSharedMethodInfo(), this.getSplit(), this.coreMethod);
    }
}

