/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Set;
import org.truffleruby.RubyContext;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.module.RubyModule;
import org.truffleruby.language.AutoloadConstant;
import org.truffleruby.language.LexicalScope;
import org.truffleruby.language.objects.ObjectGraph;
import org.truffleruby.language.objects.ObjectGraphNode;

public final class RubyConstant
implements ObjectGraphNode {
    public static final RubyConstant[] EMPTY_ARRAY = new RubyConstant[0];
    private final RubyModule declaringModule;
    private final String name;
    private final Object value;
    private final boolean isPrivate;
    private final boolean isDeprecated;
    private final AutoloadConstant autoloadConstant;
    private final boolean undefined;
    private final SourceSection sourceSection;

    public RubyConstant(RubyModule declaringModule, String name, Object value, boolean isPrivate, boolean autoload, boolean isDeprecated, SourceSection sourceSection) {
        this(declaringModule, name, value, isPrivate, autoload ? new AutoloadConstant(value) : null, false, isDeprecated, sourceSection);
    }

    private RubyConstant(RubyModule declaringModule, String name, Object value, boolean isPrivate, AutoloadConstant autoloadConstant, boolean undefined, boolean isDeprecated, SourceSection sourceSection) {
        assert (!undefined || autoloadConstant == null) : "undefined and autoload are exclusive";
        this.declaringModule = declaringModule;
        this.name = name;
        this.value = value;
        this.isPrivate = isPrivate;
        this.isDeprecated = isDeprecated;
        this.autoloadConstant = autoloadConstant;
        this.undefined = undefined;
        this.sourceSection = sourceSection;
    }

    public RubyModule getDeclaringModule() {
        return this.declaringModule;
    }

    public String getName() {
        return this.name;
    }

    public boolean hasValue() {
        return !this.isAutoload() && !this.undefined;
    }

    public Object getValue() {
        assert (this.hasValue());
        return this.value;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public SourceSection getSourceSection() {
        return this.sourceSection;
    }

    public RubyConstant withPrivate(boolean isPrivate) {
        if (isPrivate == this.isPrivate) {
            return this;
        }
        return new RubyConstant(this.declaringModule, this.name, this.value, isPrivate, this.autoloadConstant, this.undefined, this.isDeprecated, this.sourceSection);
    }

    public RubyConstant withDeprecated() {
        if (this.isDeprecated()) {
            return this;
        }
        return new RubyConstant(this.declaringModule, this.name, this.value, this.isPrivate, this.autoloadConstant, this.undefined, true, this.sourceSection);
    }

    public RubyConstant undefined() {
        assert (this.isAutoload());
        return new RubyConstant(this.declaringModule, this.name, null, this.isPrivate, null, true, this.isDeprecated, this.sourceSection);
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isVisibleTo(RubyContext context, LexicalScope lexicalScope, RubyModule module) {
        assert (lexicalScope == null || lexicalScope.getLiveModule() == module);
        if (!this.isPrivate) {
            return true;
        }
        if (lexicalScope != null) {
            while (lexicalScope != context.getRootLexicalScope()) {
                if (lexicalScope.getLiveModule() == this.declaringModule) {
                    return true;
                }
                lexicalScope = lexicalScope.getParent();
            }
        }
        if (module instanceof RubyClass) {
            for (RubyModule included : module.fields.ancestors()) {
                if (included == module || included != this.declaringModule) continue;
                return true;
            }
        }
        return lexicalScope != null && context.getCoreLibrary().objectClass == this.declaringModule;
    }

    public boolean isUndefined() {
        return this.undefined;
    }

    public boolean isAutoload() {
        return this.autoloadConstant != null;
    }

    public AutoloadConstant getAutoloadConstant() {
        return this.autoloadConstant;
    }

    @Override
    public void getAdjacentObjects(Set<Object> adjacent) {
        if (ObjectGraph.isRubyObject(this.value)) {
            adjacent.add(this.value);
        }
    }

    public String toString() {
        return this.getDeclaringModule().fields.getName() + "::" + this.getName();
    }
}

