/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.Split;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.RubyRootNode;
import org.truffleruby.language.arguments.CheckKeywordArityNode;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.control.ReturnID;
import org.truffleruby.language.methods.Arity;
import org.truffleruby.language.methods.SharedMethodInfo;

public abstract class RubyCheckArityRootNode
extends RubyRootNode {
    @Node.Child
    private CheckKeywordArityNode checkKeywordArityNode;
    public final Arity arityForCheck;
    private final boolean keywordArguments;
    @CompilerDirectives.CompilationFinal
    private boolean checkArityProfile;

    public RubyCheckArityRootNode(RubyLanguage language, SourceSection sourceSection, FrameDescriptor frameDescriptor, SharedMethodInfo sharedMethodInfo, RubyNode body, Split split, ReturnID returnID, Arity arityForCheck) {
        super(language, sourceSection, frameDescriptor, sharedMethodInfo, body, split, returnID);
        this.arityForCheck = arityForCheck;
        this.keywordArguments = arityForCheck.acceptsKeywords();
        this.checkKeywordArityNode = this.keywordArguments && !arityForCheck.hasKeywordsRest() ? new CheckKeywordArityNode(arityForCheck) : null;
    }

    protected void checkArity(VirtualFrame frame) {
        int given = RubyArguments.getPositionalArgumentsCount((Frame)frame, this.keywordArguments);
        if (!this.arityForCheck.checkPositionalArguments(given)) {
            if (!this.checkArityProfile) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.checkArityProfile = true;
            }
            throw RubyCheckArityRootNode.checkArityError(this.arityForCheck, given, (Node)this);
        }
        if (this.checkKeywordArityNode != null) {
            this.checkKeywordArityNode.checkArity(frame);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static RaiseException checkArityError(Arity arity, int given, Node currentNode) {
        RubyContext context = RubyContext.get(currentNode);
        if (arity.hasRest()) {
            return new RaiseException(context, context.getCoreExceptions().argumentErrorPlus(given, arity.getRequired(), currentNode));
        }
        if (arity.getOptional() > 0) {
            return new RaiseException(context, context.getCoreExceptions().argumentError(given, arity.getRequired(), arity.getOptional(), currentNode));
        }
        return new RaiseException(context, context.getCoreExceptions().argumentError(given, arity.getRequired(), currentNode));
    }
}

