/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.language;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.ControlFlowException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import org.truffleruby.RubyLanguage;
import org.truffleruby.language.NotOptimizedWarningNodeGen;
import org.truffleruby.language.RubyBaseNode;

@GenerateUncached
public abstract class NotOptimizedWarningNode
extends RubyBaseNode {
    private static final Set<String> DISPLAYED_WARNINGS = ConcurrentHashMap.newKeySet();

    @NeverDefault
    public static NotOptimizedWarningNode create() {
        return NotOptimizedWarningNodeGen.create();
    }

    public final void warn(String message) {
        this.executeWarn(message);
    }

    protected abstract void executeWarn(String var1);

    @Specialization(rewriteOn={Warned.class})
    void warnOnce(String message) throws Warned {
        CompilerAsserts.compilationConstant((Object)message);
        if (CompilerDirectives.inInterpreter()) {
            return;
        }
        if (!((Boolean)this.getContext().getWarningCategoryPerformance().get()).booleanValue()) {
            return;
        }
        this.log(message);
        throw new Warned();
    }

    @Specialization(replaces={"warnOnce"})
    void doNotWarn(String message) {
    }

    @CompilerDirectives.TruffleBoundary
    private void log(String message) {
        SourceSection userSourceSection = this.getContext().getCallStack().getTopMostUserSourceSection();
        String displayedWarning = String.format("%s: %s", this.getContext().fileLine(userSourceSection), message);
        if (DISPLAYED_WARNINGS.add(displayedWarning)) {
            RubyLanguage.LOGGER.log(Level.WARNING, displayedWarning);
        }
    }

    protected static final class Warned
    extends ControlFlowException {
        protected Warned() {
        }
    }
}

