/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.interop;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnknownKeyException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import org.truffleruby.core.cast.IntegerCastNode;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.objects.LogicalClassNode;
import org.truffleruby.utils.Utils;

@GenerateUncached
public abstract class TranslateInteropRubyExceptionNode
extends RubyBaseNode {
    public final AssertionError execute(RaiseException exception) throws UnsupportedMessageException {
        try {
            return this.execute(exception, 0L, null, null);
        }
        catch (ArityException | InvalidArrayIndexException | UnknownIdentifierException | UnknownKeyException | UnsupportedTypeException e) {
            throw this.handleBadErrorType((InteropException)e, exception);
        }
    }

    public final AssertionError execute(RaiseException exception, long index) throws UnsupportedMessageException, InvalidArrayIndexException {
        try {
            return this.execute(exception, index, null, null);
        }
        catch (ArityException | UnknownIdentifierException | UnknownKeyException | UnsupportedTypeException e) {
            throw this.handleBadErrorType((InteropException)e, exception);
        }
    }

    public final AssertionError execute(RaiseException exception, String name) throws UnsupportedMessageException, UnknownIdentifierException {
        try {
            return this.execute(exception, 0L, name, null);
        }
        catch (ArityException | InvalidArrayIndexException | UnknownKeyException | UnsupportedTypeException e) {
            throw this.handleBadErrorType((InteropException)e, exception);
        }
    }

    public final AssertionError execute(RaiseException exception, long index, Object value) throws UnsupportedMessageException, InvalidArrayIndexException, UnsupportedTypeException {
        try {
            return this.execute(exception, index, null, new Object[]{value});
        }
        catch (ArityException | UnknownIdentifierException | UnknownKeyException e) {
            throw this.handleBadErrorType((InteropException)e, exception);
        }
    }

    public final AssertionError execute(RaiseException exception, String name, Object ... arguments) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException, ArityException {
        try {
            return this.execute(exception, 0L, name, arguments);
        }
        catch (InvalidArrayIndexException | UnknownKeyException e) {
            throw this.handleBadErrorType((InteropException)e, exception);
        }
    }

    public final AssertionError execute(RaiseException exception, Object key) throws UnsupportedMessageException, UnknownKeyException {
        try {
            return this.execute(exception, 0L, null, new Object[]{key});
        }
        catch (ArityException | InvalidArrayIndexException | UnknownIdentifierException | UnsupportedTypeException e) {
            throw this.handleBadErrorType((InteropException)e, exception);
        }
    }

    protected abstract AssertionError execute(RaiseException var1, long var2, String var4, Object[] var5) throws UnsupportedMessageException, InvalidArrayIndexException, UnknownIdentifierException, UnsupportedTypeException, ArityException, UnknownKeyException;

    @Specialization(guards={"logicalClassNode.execute(exception.getException()) == coreLibrary().unsupportedMessageExceptionClass"})
    AssertionError unsupportedMessageExceptionClass(RaiseException exception, long index, String identifier, Object[] arguments, @Cached @Cached.Shared LogicalClassNode logicalClassNode) throws UnsupportedMessageException {
        throw UnsupportedMessageException.create((Throwable)((Object)exception));
    }

    @Specialization(guards={"logicalClassNode.execute(exception.getException()) == coreLibrary().invalidArrayIndexExceptionClass"})
    AssertionError invalidArrayIndexExceptionClass(RaiseException exception, long index, String identifier, Object[] arguments, @Cached @Cached.Shared LogicalClassNode logicalClassNode) throws InvalidArrayIndexException {
        throw InvalidArrayIndexException.create((long)index, (Throwable)((Object)exception));
    }

    @Specialization(guards={"logicalClassNode.execute(exception.getException()) == coreLibrary().unknownIdentifierExceptionClass"})
    AssertionError unknownIdentifierExceptionClass(RaiseException exception, long index, String identifier, Object[] arguments, @Cached @Cached.Shared LogicalClassNode logicalClassNode) throws UnknownIdentifierException {
        throw UnknownIdentifierException.create((String)identifier, (Throwable)((Object)exception));
    }

    @Specialization(guards={"logicalClassNode.execute(exception.getException()) == coreLibrary().unsupportedTypeExceptionClass"})
    AssertionError unsupportedTypeExceptionClass(RaiseException exception, long index, String identifier, Object[] arguments, @Cached @Cached.Shared LogicalClassNode logicalClassNode) throws UnsupportedTypeException {
        throw UnsupportedTypeException.create((Object[])arguments, null, (Throwable)((Object)exception));
    }

    @Specialization(guards={"logicalClassNode.execute(exception.getException()) == coreLibrary().arityExceptionClass"})
    AssertionError arityExceptionClass(RaiseException exception, long index, String identifier, Object[] arguments, @Cached DispatchNode dispatch, @Cached IntegerCastNode intCastNode, @Cached @Cached.Shared LogicalClassNode logicalClassNode) throws ArityException {
        int minExpected = intCastNode.execute(this, dispatch.call(exception.getException(), "min_expected"));
        int maxExpected = intCastNode.execute(this, dispatch.call(exception.getException(), "max_expected"));
        throw ArityException.create((int)minExpected, (int)maxExpected, (int)arguments.length, (Throwable)((Object)exception));
    }

    @Specialization(guards={"logicalClassNode.execute(exception.getException()) == coreLibrary().unknownKeyExceptionClass"})
    AssertionError unknownKeyExceptionClass(RaiseException exception, long index, String identifier, Object[] arguments, @Cached @Cached.Shared LogicalClassNode logicalClassNode) throws UnknownKeyException {
        throw UnknownKeyException.create((Object)arguments[0]);
    }

    @Fallback
    AssertionError fallback(RaiseException exception, long index, String identifier, Object[] arguments) {
        throw exception;
    }

    @CompilerDirectives.TruffleBoundary
    protected AssertionError handleBadErrorType(InteropException e, RaiseException rubyException) {
        RubyException exception = this.coreExceptions().runtimeError(Utils.concat((Object)"Wrong exception raised from a Ruby method implementing polyglot behavior: ", (Object)e), this);
        exception.cause = rubyException;
        throw new RaiseException(this.getContext(), exception);
    }
}

