/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.interop;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.IOException;
import java.util.Iterator;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.array.ArrayOperations;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.string.StringHelperNodes;
import org.truffleruby.interop.ForeignToRubyNode;
import org.truffleruby.interop.RubyInnerContext;
import org.truffleruby.interop.ToJavaStringNode;
import org.truffleruby.language.NotProvided;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.library.RubyStringLibrary;
import org.truffleruby.language.yield.CallBlockNode;
import org.truffleruby.utils.Utils;

@CoreModule(value="Polyglot")
public abstract class PolyglotNodes {

    @Primitive(name="inner_context_close_force")
    public static abstract class InnerContextCloseExitedNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object closeExited(RubyInnerContext rubyInnerContext) {
            rubyInnerContext.innerContext.closeCancelled((Node)this, "force terminate");
            return nil;
        }
    }

    @Primitive(name="inner_context_close")
    public static abstract class InnerContextCloseNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object close(RubyInnerContext rubyInnerContext) {
            rubyInnerContext.innerContext.close();
            return nil;
        }
    }

    @Primitive(name="inner_context_eval")
    public static abstract class InnerContextEvalNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"idLib.isRubyString(langId)", "codeLib.isRubyString(code)", "filenameLib.isRubyString(filename)", "idEqualNode.execute(idLib, langId, cachedLangId, cachedLangIdEnc)", "codeEqualNode.execute(codeLib, code, cachedCode, cachedCodeEnc)", "filenameEqualNode.execute(filenameLib, filename, cachedFilename, cachedFilenameEnc)"}, limit="getCacheLimit()")
        Object evalCached(RubyInnerContext rubyInnerContext, Object langId, Object code, Object filename, @Cached.Shared @Cached RubyStringLibrary idLib, @Cached.Shared @Cached RubyStringLibrary codeLib, @Cached.Shared @Cached RubyStringLibrary filenameLib, @Cached(value="asTruffleStringUncached(langId)") TruffleString cachedLangId, @Cached(value="idLib.getEncoding(langId)") RubyEncoding cachedLangIdEnc, @Cached(value="asTruffleStringUncached(code)") TruffleString cachedCode, @Cached(value="codeLib.getEncoding(code)") RubyEncoding cachedCodeEnc, @Cached(value="asTruffleStringUncached(filename)") TruffleString cachedFilename, @Cached(value="filenameLib.getEncoding(filename)") RubyEncoding cachedFilenameEnc, @Cached(value="createSource(getJavaString(langId), getJavaString(code), getJavaString(filename))") Source cachedSource, @Cached StringHelperNodes.EqualNode idEqualNode, @Cached StringHelperNodes.EqualNode codeEqualNode, @Cached StringHelperNodes.EqualNode filenameEqualNode, @Cached.Shared @Cached ForeignToRubyNode foreignToRubyNode, @Cached.Shared @Cached InlinedBranchProfile errorProfile) {
            return InnerContextEvalNode.eval(this, rubyInnerContext, cachedSource, foreignToRubyNode, errorProfile);
        }

        @Specialization(guards={"idLib.isRubyString(langId)", "codeLib.isRubyString(code)"}, replaces={"evalCached"})
        static Object evalUncached(RubyInnerContext rubyInnerContext, Object langId, Object code, Object filename, @Cached.Shared @Cached RubyStringLibrary idLib, @Cached.Shared @Cached RubyStringLibrary codeLib, @Cached.Shared @Cached RubyStringLibrary filenameLib, @Cached ToJavaStringNode toJavaStringIDNode, @Cached ToJavaStringNode toJavaStringCodeNode, @Cached ToJavaStringNode toJavaStringFileNode, @Cached.Shared @Cached ForeignToRubyNode foreignToRubyNode, @Cached.Shared @Cached InlinedBranchProfile errorProfile, @Bind(value="this") Node node) {
            String idString = toJavaStringIDNode.execute(node, langId);
            String codeString = toJavaStringCodeNode.execute(node, code);
            String filenameString = toJavaStringFileNode.execute(node, filename);
            Source source = InnerContextEvalNode.createSource(idString, codeString, filenameString);
            return InnerContextEvalNode.eval(node, rubyInnerContext, source, foreignToRubyNode, errorProfile);
        }

        private static Object eval(Node node, RubyInnerContext rubyInnerContext, Source source, ForeignToRubyNode foreignToRubyNode, InlinedBranchProfile errorProfile) {
            Object result;
            try {
                result = rubyInnerContext.innerContext.evalPublic(node, source);
            }
            catch (IllegalStateException closed) {
                errorProfile.enter(node);
                throw new RaiseException(InnerContextEvalNode.getContext(node), InnerContextEvalNode.coreExceptions(node).runtimeError("This Polyglot::InnerContext is closed", node));
            }
            catch (ThreadDeath closed) {
                errorProfile.enter(node);
                throw new RaiseException(InnerContextEvalNode.getContext(node), InnerContextEvalNode.coreExceptions(node).runtimeError("Polyglot::InnerContext was terminated forcefully", node));
            }
            catch (IllegalArgumentException unknownLanguage) {
                errorProfile.enter(node);
                throw new RaiseException(InnerContextEvalNode.getContext(node), InnerContextEvalNode.coreExceptions(node).argumentError(Utils.concat((Object)"Unknown language: ", (Object)source.getLanguage()), node));
            }
            return foreignToRubyNode.execute(node, result);
        }

        @CompilerDirectives.TruffleBoundary
        protected static Source createSource(String idString, String codeString, String filename) {
            return Source.newBuilder((String)idString, (CharSequence)codeString, (String)filename).build();
        }

        protected int getCacheLimit() {
            return this.getLanguage().options.EVAL_CACHE;
        }
    }

    @Primitive(name="inner_context_new")
    public static abstract class InnerContextNewNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyInnerContext newInnerContext(RubyClass rubyClass, RubyArray languages, RubyArray languageOptions, boolean inheritAllAccess, Object codeSharing, RubyProc onCancelledCallback) {
            String[] permittedLanguages = new String[languages.size];
            int i = 0;
            for (Object language : ArrayOperations.toIterable(languages)) {
                permittedLanguages[i++] = RubyGuards.getJavaString(language);
            }
            TruffleContext.Builder builder = this.getContext().getEnv().newInnerContextBuilder(permittedLanguages);
            Iterator<Object> iterator = ArrayOperations.toIterable(languageOptions).iterator();
            while (iterator.hasNext()) {
                Object key = iterator.next();
                Object value = iterator.next();
                builder.option(RubyGuards.getJavaString(key), RubyGuards.getJavaString(value));
            }
            Boolean codeSharingBoolean = codeSharing == nil ? null : Boolean.valueOf((Boolean)codeSharing);
            TruffleContext innerContext = builder.initializeCreatorContext(false).inheritAllAccess(inheritAllAccess).forceSharing(codeSharingBoolean).onCancelled(() -> CallBlockNode.getUncached().yield(onCancelledCallback, new Object[0])).build();
            return new RubyInnerContext(rubyClass, this.getLanguage().innerContextShape, innerContext);
        }
    }

    @CoreMethod(names={"eval_file"}, onSingleton=true, required=1, optional=1, argumentNames={"file_name_or_id", "file_name"})
    public static abstract class EvalFileNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"stringsId.isRubyString(fileName)"})
        Object evalFile(Object fileName, NotProvided id, @Cached.Shared @Cached RubyStringLibrary stringsId) {
            Source source;
            String path = RubyGuards.getJavaString(fileName).intern();
            try {
                TruffleFile file = this.getContext().getEnv().getPublicTruffleFile(path);
                String language = Source.findLanguage((TruffleFile)file);
                if (language == null) {
                    throw new RaiseException(this.getContext(), this.coreExceptions().argumentError("Could not find language of file " + path, this));
                }
                source = Source.newBuilder((String)language, (TruffleFile)file).build();
            }
            catch (IOException e) {
                throw new RaiseException(this.getContext(), this.coreExceptions().ioError(e, (Node)this));
            }
            return this.eval(source);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"stringsId.isRubyString(id)", "stringsFileName.isRubyString(fileName)"}, limit="1")
        Object evalFile(Object id, Object fileName, @Cached.Shared @Cached RubyStringLibrary stringsId, @Cached.Exclusive @Cached RubyStringLibrary stringsFileName) {
            String idString = RubyGuards.getJavaString(id);
            Source source = this.getSource(idString, RubyGuards.getJavaString(fileName));
            return this.eval(source);
        }

        private Object eval(Source source) {
            CallTarget callTarget;
            try {
                callTarget = this.getContext().getEnv().parsePublic(source, new String[0]);
            }
            catch (IllegalStateException e) {
                throw new RaiseException(this.getContext(), this.coreExceptions().argumentError(e.getMessage(), this));
            }
            return callTarget.call(new Object[0]);
        }

        private Source getSource(String language, String fileName) {
            String path = fileName.intern();
            try {
                TruffleFile file = this.getContext().getEnv().getPublicTruffleFile(path);
                return Source.newBuilder((String)language, (TruffleFile)file).build();
            }
            catch (IOException e) {
                throw new RaiseException(this.getContext(), this.coreExceptions().ioError(e, (Node)this));
            }
        }
    }

    @CoreMethod(names={"eval"}, onSingleton=true, required=2)
    @ReportPolymorphism
    public static abstract class EvalNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"stringsId.isRubyString(langId)", "stringsSource.isRubyString(code)", "idEqualNode.execute(stringsId, langId, cachedLangId, cachedLangIdEnc)", "codeEqualNode.execute(stringsSource, code, cachedCode, cachedCodeEnc)"}, limit="getCacheLimit()")
        Object evalCached(Object langId, Object code, @Cached.Shared @Cached RubyStringLibrary stringsId, @Cached.Shared @Cached RubyStringLibrary stringsSource, @Cached(value="asTruffleStringUncached(langId)") TruffleString cachedLangId, @Cached(value="stringsId.getEncoding(langId)") RubyEncoding cachedLangIdEnc, @Cached(value="asTruffleStringUncached(code)") TruffleString cachedCode, @Cached(value="stringsSource.getEncoding(code)") RubyEncoding cachedCodeEnc, @Bind(value="this") Node node, @Cached(value="create(parse(node, getJavaString(langId), getJavaString(code)))") DirectCallNode callNode, @Cached StringHelperNodes.EqualNode idEqualNode, @Cached StringHelperNodes.EqualNode codeEqualNode) {
            return callNode.call(EMPTY_ARGUMENTS);
        }

        @Specialization(guards={"stringsId.isRubyString(langId)", "stringsSource.isRubyString(code)"}, replaces={"evalCached"})
        static Object evalUncached(Object langId, Object code, @Cached.Shared @Cached RubyStringLibrary stringsId, @Cached.Shared @Cached RubyStringLibrary stringsSource, @Cached ToJavaStringNode toJavaStringLandNode, @Cached ToJavaStringNode toJavaStringCodeNode, @Cached IndirectCallNode callNode, @Bind(value="this") Node node) {
            return callNode.call(EvalNode.parse(node, toJavaStringLandNode.execute(node, langId), toJavaStringCodeNode.execute(node, code)), EMPTY_ARGUMENTS);
        }

        @CompilerDirectives.TruffleBoundary
        protected static CallTarget parse(Node node, String langId, String code) {
            Source source = Source.newBuilder((String)langId, (CharSequence)code, (String)"(eval)").build();
            try {
                return EvalNode.getContext(node).getEnv().parsePublic(source, new String[0]);
            }
            catch (IllegalStateException e) {
                throw new RaiseException(EvalNode.getContext(node), EvalNode.coreExceptions(node).argumentError(e.getMessage(), node));
            }
        }

        protected int getCacheLimit() {
            return this.getLanguage().options.EVAL_CACHE;
        }
    }
}

