/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.interop;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.NodeLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.DirectCallNode;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Map;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.array.ArrayGuards;
import org.truffleruby.core.array.ArrayToObjectArrayNode;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.array.library.ArrayStoreLibrary;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.numeric.FixnumOrBignumNode;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.string.StringHelperNodes;
import org.truffleruby.core.string.StringOperations;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.interop.ForeignToRubyNode;
import org.truffleruby.interop.FromJavaStringNode;
import org.truffleruby.interop.ProxyForeignObject;
import org.truffleruby.interop.RubySourceLocation;
import org.truffleruby.interop.SymbolToByteOrderNode;
import org.truffleruby.interop.ToJavaStringNode;
import org.truffleruby.interop.TranslateInteropExceptionNode;
import org.truffleruby.language.Nil;
import org.truffleruby.language.NotProvided;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.library.RubyStringLibrary;
import org.truffleruby.language.loader.FileLoader;
import org.truffleruby.language.objects.LogicalClassNode;

@CoreModule(value="Truffle::Interop")
public abstract class InteropNodes {
    public static Object execute(Node node, Object receiver, Object[] args, InteropLibrary receivers, TranslateInteropExceptionNode translateInteropExceptionNode) {
        try {
            return receivers.execute(receiver, args);
        }
        catch (InteropException e) {
            throw translateInteropExceptionNode.execute(node, e);
        }
    }

    public static Object readMember(Node node, InteropLibrary interop, Object receiver, String name, TranslateInteropExceptionNode translateInteropException) {
        try {
            return interop.readMember(receiver, name);
        }
        catch (InteropException e) {
            throw translateInteropException.execute(node, e);
        }
    }

    @CoreMethod(names={"iterator_next_element"}, onSingleton=true, required=1)
    public static abstract class GetIteratorNextElementNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static Object getIteratorNextElement(Object receiver, @CachedLibrary(value="receiver") InteropLibrary interop, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                return interop.getIteratorNextElement(receiver);
            }
            catch (InteropException e) {
                throw translateInteropException.execute(node, e);
            }
        }
    }

    @CoreMethod(names={"has_iterator_next_element?"}, onSingleton=true, required=1)
    public static abstract class HasIteratorNextElementNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static boolean hasIteratorNextElement(Object receiver, @CachedLibrary(value="receiver") InteropLibrary interop, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                return interop.hasIteratorNextElement(receiver);
            }
            catch (UnsupportedMessageException e) {
                throw translateInteropException.execute(node, (InteropException)((Object)e));
            }
        }
    }

    @CoreMethod(names={"iterator"}, onSingleton=true, required=1)
    public static abstract class GetIteratorNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static Object getIterator(Object receiver, @CachedLibrary(value="receiver") InteropLibrary interop, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                return interop.getIterator(receiver);
            }
            catch (UnsupportedMessageException e) {
                throw translateInteropException.execute(node, (InteropException)((Object)e));
            }
        }
    }

    @CoreMethod(names={"iterator?"}, onSingleton=true, required=1)
    public static abstract class IsIteratorNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean isIterator(Object receiver, @CachedLibrary(value="receiver") InteropLibrary interop) {
            return interop.isIterator(receiver);
        }
    }

    @CoreMethod(names={"has_iterator?"}, onSingleton=true, required=1)
    public static abstract class HasIteratorNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean hasIterator(Object receiver, @CachedLibrary(value="receiver") InteropLibrary interop) {
            return interop.hasIterator(receiver);
        }
    }

    @CoreMethod(names={"write_buffer_double"}, onSingleton=true, required=4)
    public static abstract class WriteBufferDoubleNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()", guards={"interopValue.fitsInDouble(value)"})
        static Object writeBufferDouble(Object receiver, Object orderObject, long byteOffset, Object value, @CachedLibrary(value="receiver") InteropLibrary interop, @CachedLibrary(value="value") InteropLibrary interopValue, @Cached SymbolToByteOrderNode symbolToByteOrderNode, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                ByteOrder order = symbolToByteOrderNode.execute(node, orderObject);
                double doubleValue = interopValue.asDouble(value);
                interop.writeBufferDouble(receiver, order, byteOffset, doubleValue);
            }
            catch (InteropException e) {
                throw translateInteropException.execute(node, e);
            }
            return value;
        }
    }

    @CoreMethod(names={"read_buffer_double"}, onSingleton=true, required=3)
    public static abstract class ReadBufferDoubleNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static double readBufferDouble(Object receiver, Object byteOrderObject, long byteOffset, @CachedLibrary(value="receiver") InteropLibrary interop, @Cached SymbolToByteOrderNode symbolToByteOrderNode, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                ByteOrder byteOrder = symbolToByteOrderNode.execute(node, byteOrderObject);
                return interop.readBufferDouble(receiver, byteOrder, byteOffset);
            }
            catch (InteropException e) {
                throw translateInteropException.execute(node, e);
            }
        }
    }

    @CoreMethod(names={"write_buffer_float"}, onSingleton=true, required=4)
    public static abstract class WriteBufferFloatNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()", guards={"interopValue.fitsInDouble(value)"})
        static Object writeBufferFloat(Object receiver, Object orderObject, long byteOffset, Object value, @CachedLibrary(value="receiver") InteropLibrary interop, @CachedLibrary(value="value") InteropLibrary interopValue, @Cached SymbolToByteOrderNode symbolToByteOrderNode, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                ByteOrder order = symbolToByteOrderNode.execute(node, orderObject);
                float floatValue = (float)interopValue.asDouble(value);
                interop.writeBufferFloat(receiver, order, byteOffset, floatValue);
            }
            catch (InteropException e) {
                throw translateInteropException.execute(node, e);
            }
            return value;
        }
    }

    @CoreMethod(names={"read_buffer_float"}, onSingleton=true, required=3)
    public static abstract class ReadBufferFloatNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static double readBufferFloat(Object receiver, Object byteOrderObject, long byteOffset, @CachedLibrary(value="receiver") InteropLibrary interop, @Cached SymbolToByteOrderNode symbolToByteOrderNode, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                ByteOrder byteOrder = symbolToByteOrderNode.execute(node, byteOrderObject);
                return interop.readBufferFloat(receiver, byteOrder, byteOffset);
            }
            catch (InteropException e) {
                throw translateInteropException.execute(node, e);
            }
        }
    }

    @CoreMethod(names={"write_buffer_long"}, onSingleton=true, required=4)
    public static abstract class WriteBufferLongNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()", guards={"interopValue.fitsInLong(value)"})
        static Object writeBufferLong(Object receiver, Object orderObject, long byteOffset, Object value, @CachedLibrary(value="receiver") InteropLibrary interop, @CachedLibrary(value="value") InteropLibrary interopValue, @Cached SymbolToByteOrderNode symbolToByteOrderNode, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                ByteOrder order = symbolToByteOrderNode.execute(node, orderObject);
                long longValue = interopValue.asLong(value);
                interop.writeBufferLong(receiver, order, byteOffset, longValue);
            }
            catch (InteropException e) {
                throw translateInteropException.execute(node, e);
            }
            return value;
        }
    }

    @CoreMethod(names={"read_buffer_long"}, onSingleton=true, required=3)
    public static abstract class ReadBufferLongNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static long readBufferLong(Object receiver, Object byteOrderObject, long byteOffset, @CachedLibrary(value="receiver") InteropLibrary interop, @Cached SymbolToByteOrderNode symbolToByteOrderNode, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                ByteOrder byteOrder = symbolToByteOrderNode.execute(node, byteOrderObject);
                return interop.readBufferLong(receiver, byteOrder, byteOffset);
            }
            catch (InteropException e) {
                throw translateInteropException.execute(node, e);
            }
        }
    }

    @CoreMethod(names={"write_buffer_int"}, onSingleton=true, required=4, lowerFixnum={4})
    public static abstract class WriteBufferIntNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()", guards={"interopValue.fitsInInt(value)"})
        static Object writeBufferInt(Object receiver, Object orderObject, long byteOffset, Object value, @CachedLibrary(value="receiver") InteropLibrary interop, @CachedLibrary(value="value") InteropLibrary interopValue, @Cached SymbolToByteOrderNode symbolToByteOrderNode, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                ByteOrder order = symbolToByteOrderNode.execute(node, orderObject);
                int intValue = interopValue.asInt(value);
                interop.writeBufferInt(receiver, order, byteOffset, intValue);
            }
            catch (InteropException e) {
                throw translateInteropException.execute(node, e);
            }
            return value;
        }
    }

    @CoreMethod(names={"read_buffer_int"}, onSingleton=true, required=3)
    public static abstract class ReadBufferIntNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static int readBufferInt(Object receiver, Object byteOrderObject, long byteOffset, @CachedLibrary(value="receiver") InteropLibrary interop, @Cached SymbolToByteOrderNode symbolToByteOrderNode, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                ByteOrder byteOrder = symbolToByteOrderNode.execute(node, byteOrderObject);
                return interop.readBufferInt(receiver, byteOrder, byteOffset);
            }
            catch (InteropException e) {
                throw translateInteropException.execute(node, e);
            }
        }
    }

    @CoreMethod(names={"write_buffer_short"}, onSingleton=true, required=4)
    public static abstract class WriteBufferShortNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()", guards={"interopValue.fitsInShort(value)"})
        static Object writeBufferShort(Object receiver, Object byteOrderObject, long byteOffset, Object value, @CachedLibrary(value="receiver") InteropLibrary interop, @CachedLibrary(value="value") InteropLibrary interopValue, @Cached SymbolToByteOrderNode symbolToByteOrderNode, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                ByteOrder byteOrder = symbolToByteOrderNode.execute(node, byteOrderObject);
                short shortValue = interopValue.asShort(value);
                interop.writeBufferShort(receiver, byteOrder, byteOffset, shortValue);
            }
            catch (InteropException e) {
                throw translateInteropException.execute(node, e);
            }
            return value;
        }
    }

    @CoreMethod(names={"read_buffer_short"}, onSingleton=true, required=3)
    public static abstract class ReadBufferShortNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static short readBufferShort(Object receiver, Object byteOrderObject, long byteOffset, @CachedLibrary(value="receiver") InteropLibrary interop, @Cached SymbolToByteOrderNode symbolToByteOrderNode, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                ByteOrder byteOrder = symbolToByteOrderNode.execute(node, byteOrderObject);
                return interop.readBufferShort(receiver, byteOrder, byteOffset);
            }
            catch (InteropException e) {
                throw translateInteropException.execute(node, e);
            }
        }
    }

    @CoreMethod(names={"write_buffer_byte"}, onSingleton=true, required=3)
    public static abstract class WriteBufferByteNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()", guards={"interopValue.fitsInByte(value)"})
        static Object writeBufferByte(Object receiver, long byteOffset, Object value, @CachedLibrary(value="receiver") InteropLibrary interop, @CachedLibrary(value="value") InteropLibrary interopValue, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                byte byteValue = interopValue.asByte(value);
                interop.writeBufferByte(receiver, byteOffset, byteValue);
            }
            catch (InteropException e) {
                throw translateInteropException.execute(node, e);
            }
            return value;
        }
    }

    @CoreMethod(names={"read_buffer_byte"}, onSingleton=true, required=2)
    public static abstract class ReadBufferByteNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static byte readBufferByte(Object receiver, long byteOffset, @CachedLibrary(value="receiver") InteropLibrary interop, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                return interop.readBufferByte(receiver, byteOffset);
            }
            catch (InteropException e) {
                throw translateInteropException.execute(node, e);
            }
        }
    }

    @CoreMethod(names={"buffer_size"}, onSingleton=true, required=1)
    public static abstract class GetBufferSizeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static long getBufferSize(Object receiver, @CachedLibrary(value="receiver") InteropLibrary interop, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                return interop.getBufferSize(receiver);
            }
            catch (UnsupportedMessageException e) {
                throw translateInteropException.execute(node, (InteropException)((Object)e));
            }
        }
    }

    @CoreMethod(names={"buffer_writable?"}, onSingleton=true, required=1)
    public static abstract class IsBufferWritableNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static boolean isBufferWritable(Object receiver, @CachedLibrary(value="receiver") InteropLibrary interop, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                return interop.isBufferWritable(receiver);
            }
            catch (UnsupportedMessageException e) {
                throw translateInteropException.execute(node, (InteropException)((Object)e));
            }
        }
    }

    @CoreMethod(names={"has_buffer_elements?"}, onSingleton=true, required=1)
    public static abstract class HasBufferElementsNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean hasBufferElements(Object receiver, @CachedLibrary(value="receiver") InteropLibrary interop) {
            return interop.hasBufferElements(receiver);
        }
    }

    @Primitive(name="top_scope")
    public static abstract class GetTopScopeNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object getTopScope() {
            return this.getContext().getTopScopeObject();
        }
    }

    @Primitive(name="current_scope")
    public static abstract class GetCurrentScopeNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object getScope(VirtualFrame frame, @CachedLibrary(limit="1") NodeLibrary nodeLibrary, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                return nodeLibrary.getScope((Object)this, (Frame)frame, true);
            }
            catch (UnsupportedMessageException e) {
                throw translateInteropException.execute(node, (InteropException)((Object)e));
            }
        }
    }

    @CoreMethod(names={"scope_parent"}, onSingleton=true, required=1)
    public static abstract class GetScopeParentNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static Object getScope(Object scope, @CachedLibrary(value="scope") InteropLibrary interopLibrary, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            if (interopLibrary.hasScopeParent(scope)) {
                try {
                    return interopLibrary.getScopeParent(scope);
                }
                catch (UnsupportedMessageException e) {
                    throw translateInteropException.execute(node, (InteropException)((Object)e));
                }
            }
            return nil;
        }
    }

    @CoreMethod(names={"has_scope_parent?"}, onSingleton=true, required=1)
    public static abstract class HasScopeParentNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean hasScopeParent(Object receiver, @CachedLibrary(value="receiver") InteropLibrary interop) {
            return interop.hasScopeParent(receiver);
        }
    }

    @CoreMethod(names={"scope?"}, onSingleton=true, required=1)
    public static abstract class IsScopeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean isScope(Object receiver, @CachedLibrary(value="receiver") InteropLibrary interop) {
            return interop.isScope(receiver);
        }
    }

    @CoreMethod(names={"identity_hash_code"}, onSingleton=true, required=1)
    public static abstract class InteropIdentityHashCodeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static int identityHashCode(Object value, @CachedLibrary(value="value") InteropLibrary interop, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            if (interop.hasIdentity(value)) {
                try {
                    return interop.identityHashCode(value);
                }
                catch (UnsupportedMessageException e) {
                    throw translateInteropException.execute(node, (InteropException)((Object)e));
                }
            }
            return System.identityHashCode(value);
        }
    }

    @CoreMethod(names={"has_identity?"}, onSingleton=true, required=1)
    public static abstract class HasIdentityNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean hasIdentity(Object receiver, @CachedLibrary(value="receiver") InteropLibrary interop) {
            return interop.hasIdentity(receiver);
        }
    }

    @CoreMethod(names={"identical?"}, onSingleton=true, required=2)
    public static abstract class IsIdenticalNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean isIdentical(Object receiver, Object other, @CachedLibrary(value="receiver") InteropLibrary lhsInterop, @CachedLibrary(value="other") InteropLibrary rhsInterop) {
            return lhsInterop.isIdentical(receiver, other, rhsInterop);
        }
    }

    @CoreMethod(names={"write_hash_entry"}, onSingleton=true, required=3)
    public static abstract class WriteHashEntryNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static Object writeHashEntry(Object receiver, Object key, Object value, @CachedLibrary(value="receiver") InteropLibrary interop, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                interop.writeHashEntry(receiver, key, value);
                return value;
            }
            catch (InteropException e) {
                throw translateInteropException.execute(node, e);
            }
        }
    }

    @CoreMethod(names={"remove_hash_entry"}, onSingleton=true, required=2)
    public static abstract class RemoveHashEntryNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static Object removeHashEntry(Object receiver, Object key, @CachedLibrary(value="receiver") InteropLibrary interop, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                interop.removeHashEntry(receiver, key);
                return nil;
            }
            catch (InteropException e) {
                throw translateInteropException.execute(node, e);
            }
        }
    }

    @CoreMethod(names={"read_hash_value_or_default"}, onSingleton=true, required=3)
    public static abstract class ReadHashValueOrDefaultNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static Object readHashValueOrDefault(Object receiver, Object key, Object defaultValue, @CachedLibrary(value="receiver") InteropLibrary interop, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                return interop.readHashValueOrDefault(receiver, key, defaultValue);
            }
            catch (UnsupportedMessageException e) {
                throw translateInteropException.execute(node, (InteropException)((Object)e));
            }
        }
    }

    @CoreMethod(names={"read_hash_value"}, onSingleton=true, required=2)
    public static abstract class ReadHashValueNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static Object readHashValue(Object receiver, Object key, @CachedLibrary(value="receiver") InteropLibrary interop, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                return interop.readHashValue(receiver, key);
            }
            catch (InteropException e) {
                throw translateInteropException.execute(node, e);
            }
        }
    }

    @CoreMethod(names={"hash_values_iterator"}, onSingleton=true, required=1)
    public static abstract class HashValuesIteratorNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static Object hashValuesIterator(Object receiver, @CachedLibrary(value="receiver") InteropLibrary interop, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                return interop.getHashValuesIterator(receiver);
            }
            catch (UnsupportedMessageException e) {
                throw translateInteropException.execute(node, (InteropException)((Object)e));
            }
        }
    }

    @CoreMethod(names={"hash_size"}, onSingleton=true, required=1)
    public static abstract class HashSizeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static long hashSize(Object receiver, @CachedLibrary(value="receiver") InteropLibrary interop, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                return interop.getHashSize(receiver);
            }
            catch (UnsupportedMessageException e) {
                throw translateInteropException.execute(node, (InteropException)((Object)e));
            }
        }
    }

    @CoreMethod(names={"hash_keys_iterator"}, onSingleton=true, required=1)
    public static abstract class HashKeysIteratorNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static Object hashKeysIterator(Object receiver, @CachedLibrary(value="receiver") InteropLibrary interop, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                return interop.getHashKeysIterator(receiver);
            }
            catch (UnsupportedMessageException e) {
                throw translateInteropException.execute(node, (InteropException)((Object)e));
            }
        }
    }

    @CoreMethod(names={"hash_entry_writable?"}, onSingleton=true, required=2)
    public static abstract class HashEntryWritableNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean hashEntryWritable(Object receiver, Object key, @CachedLibrary(value="receiver") InteropLibrary interop) {
            return interop.isHashEntryWritable(receiver, key);
        }
    }

    @CoreMethod(names={"hash_entry_removable?"}, onSingleton=true, required=2)
    public static abstract class HashEntryRemovableNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean hashEntryRemovable(Object receiver, Object key, @CachedLibrary(value="receiver") InteropLibrary interop) {
            return interop.isHashEntryRemovable(receiver, key);
        }
    }

    @CoreMethod(names={"hash_entry_readable?"}, onSingleton=true, required=2)
    public static abstract class HashEntryReadableNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean hashEntryReadable(Object receiver, Object key, @CachedLibrary(value="receiver") InteropLibrary interop) {
            return interop.isHashEntryReadable(receiver, key);
        }
    }

    @CoreMethod(names={"hash_entry_modifiable?"}, onSingleton=true, required=2)
    public static abstract class HashEntryModifiableNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean hashEntryModifiable(Object receiver, Object key, @CachedLibrary(value="receiver") InteropLibrary interop) {
            return interop.isHashEntryModifiable(receiver, key);
        }
    }

    @CoreMethod(names={"hash_entry_insertable?"}, onSingleton=true, required=2)
    public static abstract class HashEntryInsertableNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean hashEntryInsertable(Object receiver, Object key, @CachedLibrary(value="receiver") InteropLibrary interop) {
            return interop.isHashEntryInsertable(receiver, key);
        }
    }

    @CoreMethod(names={"hash_entry_existing?"}, onSingleton=true, required=2)
    public static abstract class HashEntryExistingNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean hashEntryExisting(Object receiver, Object key, @CachedLibrary(value="receiver") InteropLibrary interop) {
            return interop.isHashEntryExisting(receiver, key);
        }
    }

    @CoreMethod(names={"hash_entries_iterator"}, onSingleton=true, required=1)
    public static abstract class HashEntriesIteratorNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static Object hashEntriesIterator(Object receiver, @CachedLibrary(value="receiver") InteropLibrary interop, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                return interop.getHashEntriesIterator(receiver);
            }
            catch (UnsupportedMessageException e) {
                throw translateInteropException.execute(node, (InteropException)((Object)e));
            }
        }
    }

    @CoreMethod(names={"has_hash_entries?"}, onSingleton=true, required=1)
    public static abstract class HasHashEntriesNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean hasHashEntriesNode(Object receiver, @CachedLibrary(value="receiver") InteropLibrary interop) {
            return interop.hasHashEntries(receiver);
        }
    }

    @CoreMethod(names={"meta_parents"}, onSingleton=true, required=1)
    public static abstract class GetMetaParentsNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static Object getMetaParents(Object value, @CachedLibrary(value="value") InteropLibrary interop, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                return interop.getMetaParents(value);
            }
            catch (UnsupportedMessageException e) {
                throw translateInteropException.execute(node, (InteropException)((Object)e));
            }
        }
    }

    @CoreMethod(names={"has_meta_parents?"}, onSingleton=true, required=1)
    public static abstract class HasMetaParentsNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean hasMetaParents(Object receiver, @CachedLibrary(value="receiver") InteropLibrary interop) {
            return interop.hasMetaParents(receiver);
        }
    }

    @CoreMethod(names={"meta_qualified_name"}, onSingleton=true, required=1)
    public static abstract class GetMetaQualifiedNameNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static Object getMetaQualifiedName(Object metaObject, @CachedLibrary(value="metaObject") InteropLibrary interop, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                return interop.getMetaQualifiedName(metaObject);
            }
            catch (UnsupportedMessageException e) {
                throw translateInteropException.execute(node, (InteropException)((Object)e));
            }
        }
    }

    @CoreMethod(names={"meta_simple_name"}, onSingleton=true, required=1)
    public static abstract class GetMetaSimpleNameNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static Object getMetaSimpleName(Object metaObject, @CachedLibrary(value="metaObject") InteropLibrary interop, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                return interop.getMetaSimpleName(metaObject);
            }
            catch (UnsupportedMessageException e) {
                throw translateInteropException.execute(node, (InteropException)((Object)e));
            }
        }
    }

    @CoreMethod(names={"meta_instance?"}, onSingleton=true, required=2)
    public static abstract class IsMetaInstanceNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static boolean isMetaInstance(Object metaObject, Object instance, @CachedLibrary(value="metaObject") InteropLibrary interop, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                return interop.isMetaInstance(metaObject, instance);
            }
            catch (UnsupportedMessageException e) {
                throw translateInteropException.execute(node, (InteropException)((Object)e));
            }
        }
    }

    @CoreMethod(names={"declaring_meta_object"}, onSingleton=true, required=1)
    public static abstract class DeclaringMetaObjectNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static Object declaringMetaObject(Object value, @CachedLibrary(value="value") InteropLibrary interop, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                return interop.getDeclaringMetaObject(value);
            }
            catch (UnsupportedMessageException e) {
                throw translateInteropException.execute(node, (InteropException)((Object)e));
            }
        }
    }

    @CoreMethod(names={"has_declaring_meta_object?"}, onSingleton=true, required=1)
    public static abstract class HasDeclaringMetaObjectNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean hasDeclaringMetaObject(Object receiver, @CachedLibrary(value="receiver") InteropLibrary interop) {
            return interop.hasDeclaringMetaObject(receiver);
        }
    }

    @CoreMethod(names={"meta_object"}, onSingleton=true, required=1)
    public static abstract class InteropMetaObjectNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static Object metaObject(Object value, @CachedLibrary(value="value") InteropLibrary interop, @Cached InlinedBranchProfile errorProfile, @Cached LogicalClassNode logicalClassNode, @Bind(value="this") Node node) {
            if (interop.hasMetaObject(value)) {
                try {
                    return interop.getMetaObject(value);
                }
                catch (UnsupportedMessageException e) {
                    errorProfile.enter(node);
                    return logicalClassNode.execute(value);
                }
            }
            return logicalClassNode.execute(value);
        }
    }

    @CoreMethod(names={"has_meta_object?"}, onSingleton=true, required=1)
    public static abstract class HasMetaObjectNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean hasMetaObject(Object receiver, @CachedLibrary(value="receiver") InteropLibrary interop) {
            return interop.hasMetaObject(receiver);
        }
    }

    @CoreMethod(names={"meta_object?"}, onSingleton=true, required=1)
    public static abstract class IsMetaObjectNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean isMetaObject(Object receiver, @CachedLibrary(value="receiver") InteropLibrary interop) {
            return interop.isMetaObject(receiver);
        }
    }

    @Primitive(name="java_add_to_classpath")
    public static abstract class JavaAddToClasspathNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"strings.isRubyString(path)"}, limit="1")
        boolean javaAddToClasspath(Object path, @Cached RubyStringLibrary strings) {
            TruffleLanguage.Env env = this.getContext().getEnv();
            try {
                TruffleFile file = FileLoader.getSafeTruffleFile(this.getLanguage(), this.getContext(), RubyGuards.getJavaString(path));
                env.addToHostClassPath(file);
                return true;
            }
            catch (SecurityException e) {
                throw new RaiseException(this.getContext(), this.coreExceptions().securityError("unable to add to classpath", this), e);
            }
        }
    }

    @CoreMethod(names={"java_type"}, onSingleton=true, required=1)
    public static abstract class JavaTypeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object javaType(Object name, @Cached ToJavaStringNode toJavaStringNode) {
            return this.lookupJavaType(toJavaStringNode.execute(this, name));
        }

        @CompilerDirectives.TruffleBoundary
        private Object lookupJavaType(String name) {
            TruffleLanguage.Env env = this.getContext().getEnv();
            if (!env.isHostLookupAllowed()) {
                throw new RaiseException(this.getContext(), this.getContext().getCoreExceptions().securityError("host access is not allowed", this));
            }
            return env.lookupHostSymbol(name);
        }
    }

    @Primitive(name="interop_to_java_list")
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class InteropToJavaListNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"stores.accepts(array.getStore())"})
        Object toJavaList(RubyArray array, @CachedLibrary(limit="storageStrategyLimit()") ArrayStoreLibrary stores) {
            int size = array.size;
            Object[] copy = stores.boxedCopyOfRange(array.getStore(), 0, size);
            return this.getContext().getEnv().asGuestValue(ArrayUtils.asList(copy));
        }

        @Specialization(guards={"!isRubyArray(array)"})
        Object coerce(Object array) {
            return FAILURE;
        }
    }

    @Primitive(name="interop_to_java_array")
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class InteropToJavaArrayNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"stores.accepts(array.getStore())"})
        Object toJavaArray(RubyArray array, @CachedLibrary(limit="storageStrategyLimit()") ArrayStoreLibrary stores) {
            return this.getContext().getEnv().asGuestValue(stores.toJavaArrayCopy(array.getStore(), array.size));
        }

        @Specialization(guards={"!isRubyArray(array)"})
        Object coerce(Object array) {
            return FAILURE;
        }
    }

    @Primitive(name="to_java_string")
    public static abstract class ToJavaStringPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        String toJavaString(Object value, @Cached ToJavaStringNode toJavaStringNode) {
            return toJavaStringNode.execute(this, value);
        }
    }

    @CoreMethod(names={"java_instanceof?"}, onSingleton=true, required=2)
    public static abstract class InteropJavaInstanceOfNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isJavaObject(object)", "isJavaClassOrInterface(boxedJavaClass)"})
        boolean javaInstanceOfJava(Object object, Object boxedJavaClass) {
            Object hostInstance = this.getContext().getEnv().asHostObject(object);
            if (hostInstance == null) {
                return false;
            }
            Class javaClass = (Class)this.getContext().getEnv().asHostObject(boxedJavaClass);
            return javaClass.isAssignableFrom(hostInstance.getClass());
        }

        @Specialization(guards={"!isJavaObject(object)", "isJavaClassOrInterface(boxedJavaClass)"})
        boolean javaInstanceOfNotJava(Object object, Object boxedJavaClass) {
            Class javaClass = (Class)this.getContext().getEnv().asHostObject(boxedJavaClass);
            return javaClass.isInstance(object);
        }

        protected boolean isJavaObject(Object object) {
            return this.getContext().getEnv().isHostObject(object);
        }

        protected boolean isJavaClassOrInterface(Object object) {
            return this.getContext().getEnv().isHostObject(object) && this.getContext().getEnv().asHostObject(object) instanceof Class;
        }
    }

    @CoreMethod(names={"java_string?"}, onSingleton=true, required=1)
    public static abstract class InteropIsJavaStringNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isJavaString(Object value) {
            return value instanceof String;
        }
    }

    @CoreMethod(names={"java_class?"}, onSingleton=true, required=1)
    public static abstract class InteropIsJavaClassNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isJavaClass(Object value) {
            return this.getContext().getEnv().isHostObject(value) && this.getContext().getEnv().asHostObject(value) instanceof Class;
        }
    }

    @CoreMethod(names={"java?"}, onSingleton=true, required=1)
    public static abstract class InteropIsJavaNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isJava(Object value) {
            return this.getContext().getEnv().isHostObject(value);
        }
    }

    @CoreMethod(names={"other_languages?"}, onSingleton=true, required=0)
    public static abstract class HasOtherLanguagesNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean hasOtherlanguages() {
            return this.getContext().hasOtherPublicLanguages();
        }
    }

    @CoreMethod(names={"languages"}, onSingleton=true, required=0)
    public static abstract class LanguagesNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyArray languages() {
            Map languages = this.getContext().getEnv().getPublicLanguages();
            String[] languagesArray = languages.keySet().toArray(StringUtils.EMPTY_STRING_ARRAY);
            Object[] rubyStringArray = new Object[languagesArray.length];
            for (int i = 0; i < languagesArray.length; ++i) {
                rubyStringArray[i] = StringOperations.createUTF8String(this.getContext(), this.getLanguage(), languagesArray[i]);
            }
            return this.createArray(rubyStringArray);
        }
    }

    @CoreMethod(names={"language"}, onSingleton=true, required=1)
    public static abstract class GetLanguageNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static Object getLanguage(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers, @Cached FromJavaStringNode fromJavaStringNode, @Bind(value="this") Node node) {
            Class language;
            if (!receivers.hasLanguage(receiver)) {
                return nil;
            }
            try {
                language = receivers.getLanguage(receiver);
            }
            catch (UnsupportedMessageException e) {
                return nil;
            }
            String name = GetLanguageNode.languageClassToLanguageName(language);
            return fromJavaStringNode.executeFromJavaString(node, name);
        }

        @CompilerDirectives.TruffleBoundary
        private static String languageClassToLanguageName(Class<? extends TruffleLanguage<?>> language) {
            String name = language.getSimpleName();
            if (name.endsWith("Language")) {
                name = name.substring(0, name.length() - "Language".length());
            }
            if (name.equals("Host")) {
                name = "Java";
            }
            return name;
        }
    }

    @CoreMethod(names={"has_language?"}, onSingleton=true, required=1)
    public static abstract class HasLanguageNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean hasLanguage(Object receiver, @CachedLibrary(value="receiver") InteropLibrary interop) {
            return interop.hasLanguage(receiver);
        }
    }

    @CoreMethod(names={"import"}, onSingleton=true, required=1)
    public static abstract class ImportNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object importObject(Object name, @Cached InlinedBranchProfile errorProfile, @Cached ForeignToRubyNode foreignToRubyNode, @Cached ToJavaStringNode toJavaStringNode) {
            String nameAsString = toJavaStringNode.execute(this, name);
            Object value = this.doImport(nameAsString);
            if (value != null) {
                return foreignToRubyNode.execute(this, value);
            }
            errorProfile.enter((Node)this);
            throw new RaiseException(this.getContext(), (RubyException)this.coreExceptions().nameErrorImportNotFound(nameAsString, this));
        }

        @CompilerDirectives.TruffleBoundary
        private Object doImport(String name) {
            return this.getContext().getEnv().importSymbol(name);
        }
    }

    @CoreMethod(names={"export"}, onSingleton=true, required=2)
    public static abstract class ExportNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object export(Object name, Object object, @Cached ToJavaStringNode toJavaStringNode) {
            String nameAsString = toJavaStringNode.execute(this, name);
            this.getContext().getEnv().exportSymbol(nameAsString, object);
            return object;
        }
    }

    @CoreMethod(names={"has_member_write_side_effects?"}, onSingleton=true, required=2)
    public static abstract class HasMemberWriteSideEffectsNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static boolean hasMemberWriteSideEffects(Object receiver, Object name, @Cached ToJavaStringNode toJavaStringNode, @CachedLibrary(value="receiver") InteropLibrary receivers, @Bind(value="this") Node node) {
            return receivers.hasMemberWriteSideEffects(receiver, toJavaStringNode.execute(node, name));
        }
    }

    @CoreMethod(names={"has_member_read_side_effects?"}, onSingleton=true, required=2)
    public static abstract class HasMemberReadSideEffectsNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static boolean hasMemberReadSideEffects(Object receiver, Object name, @Cached ToJavaStringNode toJavaStringNode, @CachedLibrary(value="receiver") InteropLibrary receivers, @Bind(value="this") Node node) {
            return receivers.hasMemberReadSideEffects(receiver, toJavaStringNode.execute(node, name));
        }
    }

    @CoreMethod(names={"member_existing?"}, onSingleton=true, required=2)
    public static abstract class IsMemberExistingNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static boolean isMemberExisting(Object receiver, Object name, @Cached ToJavaStringNode toJavaStringNode, @CachedLibrary(value="receiver") InteropLibrary receivers, @Bind(value="this") Node node) {
            return receivers.isMemberExisting(receiver, toJavaStringNode.execute(node, name));
        }
    }

    @CoreMethod(names={"member_writable?"}, onSingleton=true, required=2)
    public static abstract class IsMemberWritableNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static boolean isMemberWritable(Object receiver, Object name, @Cached ToJavaStringNode toJavaStringNode, @CachedLibrary(value="receiver") InteropLibrary receivers, @Bind(value="this") Node node) {
            return receivers.isMemberWritable(receiver, toJavaStringNode.execute(node, name));
        }
    }

    @CoreMethod(names={"member_internal?"}, onSingleton=true, required=2)
    public static abstract class IsMemberInternalNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static boolean isMemberInternal(Object receiver, Object name, @Cached ToJavaStringNode toJavaStringNode, @CachedLibrary(value="receiver") InteropLibrary receivers, @Bind(value="this") Node node) {
            return receivers.isMemberInternal(receiver, toJavaStringNode.execute(node, name));
        }
    }

    @CoreMethod(names={"member_invocable?"}, onSingleton=true, required=2)
    public static abstract class IsMemberInvocableNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static boolean isMemberInvocable(Object receiver, Object name, @Cached ToJavaStringNode toJavaStringNode, @CachedLibrary(value="receiver") InteropLibrary receivers, @Bind(value="this") Node node) {
            return receivers.isMemberInvocable(receiver, toJavaStringNode.execute(node, name));
        }
    }

    @CoreMethod(names={"member_removable?"}, onSingleton=true, required=2)
    public static abstract class IsMemberRemovableNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static boolean isMemberRemovable(Object receiver, Object name, @Cached ToJavaStringNode toJavaStringNode, @CachedLibrary(value="receiver") InteropLibrary receivers, @Bind(value="this") Node node) {
            return receivers.isMemberRemovable(receiver, toJavaStringNode.execute(node, name));
        }
    }

    @CoreMethod(names={"member_insertable?"}, onSingleton=true, required=2)
    public static abstract class IsMemberInsertableNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static boolean isMemberInsertable(Object receiver, Object name, @Cached ToJavaStringNode toJavaStringNode, @CachedLibrary(value="receiver") InteropLibrary receivers, @Bind(value="this") Node node) {
            return receivers.isMemberInsertable(receiver, toJavaStringNode.execute(node, name));
        }
    }

    @CoreMethod(names={"member_modifiable?"}, onSingleton=true, required=2)
    public static abstract class IsMemberModifiableNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static boolean isMemberModifiable(Object receiver, Object name, @Cached ToJavaStringNode toJavaStringNode, @CachedLibrary(value="receiver") InteropLibrary receivers, @Bind(value="this") Node node) {
            return receivers.isMemberModifiable(receiver, toJavaStringNode.execute(node, name));
        }
    }

    @CoreMethod(names={"member_readable?"}, onSingleton=true, required=2)
    public static abstract class IsMemberReadableNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static boolean isMemberReadable(Object receiver, Object name, @Cached ToJavaStringNode toJavaStringNode, @CachedLibrary(value="receiver") InteropLibrary receivers, @Bind(value="this") Node node) {
            return receivers.isMemberReadable(receiver, toJavaStringNode.execute(node, name));
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class InvokeMemberNode
    extends RubyBaseNode {
        private static Object invoke(Node node, InteropLibrary receivers, Object receiver, String member, Object[] args, TranslateInteropExceptionNode translateInteropExceptionNode) {
            try {
                return receivers.invokeMember(receiver, member, args);
            }
            catch (InteropException e) {
                throw translateInteropExceptionNode.executeInInvokeMember(node, e, receiver, args);
            }
        }

        public abstract Object execute(Node var1, Object var2, Object var3, Object[] var4);

        @Specialization(limit="getInteropCacheLimit()")
        static Object invokeCached(Node node, Object receiver, Object identifier, Object[] args, @Cached ToJavaStringNode toJavaStringNode, @CachedLibrary(value="receiver") InteropLibrary receivers, @Cached ForeignToRubyNode foreignToRubyNode, @Cached TranslateInteropExceptionNode translateInteropException) {
            String name = toJavaStringNode.execute(node, identifier);
            Object foreign = InvokeMemberNode.invoke(node, receivers, receiver, name, args, translateInteropException);
            return foreignToRubyNode.execute(node, foreign);
        }
    }

    @CoreMethod(names={"invoke_member"}, onSingleton=true, required=2, rest=true)
    public static abstract class InteropInvokeMemberNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object invokeMember(Object receiver, Object identifier, Object[] args, @Cached InvokeMemberNode invokeMemberNode) {
            return invokeMemberNode.execute(this, receiver, identifier, args);
        }
    }

    @CoreMethod(names={"remove_member"}, onSingleton=true, required=2)
    public static abstract class RemoveMemberNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isRubySymbolOrString(identifier)"}, limit="getInteropCacheLimit()")
        static Nil remove(Object receiver, Object identifier, @CachedLibrary(value="receiver") InteropLibrary receivers, @Cached ToJavaStringNode toJavaStringNode, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            String name = toJavaStringNode.execute(node, identifier);
            try {
                receivers.removeMember(receiver, name);
            }
            catch (InteropException e) {
                throw translateInteropException.execute(node, e);
            }
            return Nil.INSTANCE;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class WriteMemberWithoutConversionNode
    extends RubyBaseNode {
        public abstract Object execute(Node var1, Object var2, Object var3, Object var4);

        @Specialization(limit="getInteropCacheLimit()")
        static Object write(Node node, Object receiver, Object identifier, Object value, @CachedLibrary(value="receiver") InteropLibrary receivers, @Cached ToJavaStringNode toJavaStringNode, @Cached TranslateInteropExceptionNode translateInteropException) {
            String name = toJavaStringNode.execute(node, identifier);
            try {
                receivers.writeMember(receiver, name, value);
            }
            catch (InteropException e) {
                throw translateInteropException.execute(node, e);
            }
            return value;
        }
    }

    @CoreMethod(names={"write_member_without_conversion"}, onSingleton=true, required=3)
    public static abstract class InteropWriteMemberWithoutConversionNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object write(Object receiver, Object identifier, Object value, @Cached WriteMemberWithoutConversionNode writeMemberWithoutConversionNode) {
            return writeMemberWithoutConversionNode.execute(this, receiver, identifier, value);
        }
    }

    @CoreMethod(names={"write_member"}, onSingleton=true, required=3)
    public static abstract class WriteMemberNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static Object write(Object receiver, Object identifier, Object value, @CachedLibrary(value="receiver") InteropLibrary receivers, @Cached ToJavaStringNode toJavaStringNode, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            String name = toJavaStringNode.execute(node, identifier);
            try {
                receivers.writeMember(receiver, name, value);
            }
            catch (InteropException e) {
                throw translateInteropException.execute(node, e);
            }
            return value;
        }
    }

    @CoreMethod(names={"read_member_without_conversion"}, onSingleton=true, required=2)
    public static abstract class ReadMemberWithoutConversionNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static Object readMember(Object receiver, Object identifier, @CachedLibrary(value="receiver") InteropLibrary receivers, @Cached TranslateInteropExceptionNode translateInteropException, @Cached ToJavaStringNode toJavaStringNode, @Bind(value="this") Node node) {
            String name = toJavaStringNode.execute(node, identifier);
            return InteropNodes.readMember(node, receivers, receiver, name, translateInteropException);
        }
    }

    @GenerateUncached
    @GenerateCached(value=false)
    @GenerateInline
    public static abstract class ReadMemberNode
    extends RubyBaseNode {
        public abstract Object execute(Node var1, Object var2, Object var3);

        @Specialization(limit="getInteropCacheLimit()")
        static Object readMember(Node node, Object receiver, Object identifier, @CachedLibrary(value="receiver") InteropLibrary receivers, @Cached TranslateInteropExceptionNode translateInteropException, @Cached ToJavaStringNode toJavaStringNode, @Cached ForeignToRubyNode foreignToRubyNode) {
            String name = toJavaStringNode.execute(node, identifier);
            Object foreign = InteropNodes.readMember(node, receivers, receiver, name, translateInteropException);
            return foreignToRubyNode.execute(node, foreign);
        }
    }

    @CoreMethod(names={"read_member"}, onSingleton=true, required=2)
    public static abstract class InteropReadMemberNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object readMember(Object receiver, Object identifier, @Cached ReadMemberNode readMemberNode) {
            return readMemberNode.execute(this, receiver, identifier);
        }
    }

    @CoreMethod(names={"members"}, onSingleton=true, required=1, optional=1)
    public static abstract class GetMembersNode
    extends CoreMethodArrayArgumentsNode {
        protected abstract Object executeMembers(Object var1, boolean var2);

        @Specialization
        Object members(Object receiver, NotProvided internal) {
            return this.executeMembers(receiver, false);
        }

        @Specialization(limit="getInteropCacheLimit()")
        static Object members(Object receiver, boolean internal, @CachedLibrary(value="receiver") InteropLibrary receivers, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                return receivers.getMembers(receiver, internal);
            }
            catch (InteropException e) {
                throw translateInteropException.execute(node, e);
            }
        }
    }

    @CoreMethod(names={"has_members?"}, onSingleton=true, required=1)
    public static abstract class HasMembersNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean hasMembers(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers) {
            return receivers.hasMembers(receiver);
        }
    }

    @CoreMethod(names={"to_native"}, onSingleton=true, required=1)
    public static abstract class ToNativeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        Nil toNative(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers) {
            receivers.toNative(receiver);
            return Nil.INSTANCE;
        }
    }

    @CoreMethod(names={"as_pointer"}, onSingleton=true, required=1)
    public static abstract class AsPointerNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static long asPointer(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                return receivers.asPointer(receiver);
            }
            catch (InteropException e) {
                throw translateInteropException.execute(node, e);
            }
        }
    }

    @CoreMethod(names={"pointer?"}, onSingleton=true, required=1)
    public static abstract class PointerNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean isPointer(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers) {
            return receivers.isPointer(receiver);
        }
    }

    @CoreMethod(names={"null?"}, onSingleton=true, required=1)
    public static abstract class IsNullNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean isNull(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers) {
            return receivers.isNull(receiver);
        }
    }

    @CoreMethod(names={"as_double"}, onSingleton=true, required=1)
    public static abstract class AsDoubleNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static double as(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                return receivers.asDouble(receiver);
            }
            catch (InteropException e) {
                throw translateInteropException.execute(node, e);
            }
        }
    }

    @CoreMethod(names={"as_float"}, onSingleton=true, required=1)
    public static abstract class AsFloatNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static double as(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                return receivers.asFloat(receiver);
            }
            catch (InteropException e) {
                throw translateInteropException.execute(node, e);
            }
        }
    }

    @CoreMethod(names={"as_big_integer"}, onSingleton=true, required=1)
    public static abstract class AsBigIntegerNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static Object as(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers, @Cached FixnumOrBignumNode fixnumOrBignumNode, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                return fixnumOrBignumNode.execute(node, receivers.asBigInteger(receiver));
            }
            catch (InteropException e) {
                throw translateInteropException.execute(node, e);
            }
        }
    }

    @CoreMethod(names={"as_long"}, onSingleton=true, required=1)
    public static abstract class AsLongNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static long as(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                return receivers.asLong(receiver);
            }
            catch (InteropException e) {
                throw translateInteropException.execute(node, e);
            }
        }
    }

    @CoreMethod(names={"as_int"}, onSingleton=true, required=1)
    public static abstract class AsIntNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static int as(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                return receivers.asInt(receiver);
            }
            catch (InteropException e) {
                throw translateInteropException.execute(node, e);
            }
        }
    }

    @CoreMethod(names={"as_short"}, onSingleton=true, required=1)
    public static abstract class AsShortNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static int as(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                return receivers.asShort(receiver);
            }
            catch (InteropException e) {
                throw translateInteropException.execute(node, e);
            }
        }
    }

    @CoreMethod(names={"as_byte"}, onSingleton=true, required=1)
    public static abstract class AsByteNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static int as(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                return receivers.asByte(receiver);
            }
            catch (InteropException e) {
                throw translateInteropException.execute(node, e);
            }
        }
    }

    @CoreMethod(names={"fits_in_double?"}, onSingleton=true, required=1)
    public static abstract class FitsInDoubleNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean fits(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers) {
            return receivers.fitsInDouble(receiver);
        }
    }

    @CoreMethod(names={"fits_in_float?"}, onSingleton=true, required=1)
    public static abstract class FitsInFloatNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean fits(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers) {
            return receivers.fitsInFloat(receiver);
        }
    }

    @CoreMethod(names={"fits_in_big_integer?"}, onSingleton=true, required=1)
    public static abstract class FitsInBigIntegerNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean fits(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers) {
            return receivers.fitsInBigInteger(receiver);
        }
    }

    @CoreMethod(names={"fits_in_long?"}, onSingleton=true, required=1)
    public static abstract class FitsInLongNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean fits(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers) {
            return receivers.fitsInLong(receiver);
        }
    }

    @CoreMethod(names={"fits_in_int?"}, onSingleton=true, required=1)
    public static abstract class FitsInIntNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean fits(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers) {
            return receivers.fitsInInt(receiver);
        }
    }

    @CoreMethod(names={"fits_in_short?"}, onSingleton=true, required=1)
    public static abstract class FitsInShortNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean fits(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers) {
            return receivers.fitsInShort(receiver);
        }
    }

    @CoreMethod(names={"fits_in_byte?"}, onSingleton=true, required=1)
    public static abstract class FitsInByteNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean fits(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers) {
            return receivers.fitsInByte(receiver);
        }
    }

    @CoreMethod(names={"number?"}, onSingleton=true, required=1)
    public static abstract class IsNumberNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean isNumber(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers) {
            return receivers.isNumber(receiver);
        }
    }

    @CoreMethod(names={"as_time_zone"}, onSingleton=true, required=1)
    public static abstract class AsTimeZoneNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static Object asTimeZone(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                return AsTimeZoneNode.getContext(node).getEnv().asGuestValue((Object)receivers.asTimeZone(receiver));
            }
            catch (UnsupportedMessageException e) {
                throw translateInteropException.execute(node, (InteropException)((Object)e));
            }
        }
    }

    @CoreMethod(names={"time_zone?"}, onSingleton=true, required=1)
    public static abstract class IsTimeZoneNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean isTimeZone(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers) {
            return receivers.isTimeZone(receiver);
        }
    }

    @CoreMethod(names={"as_time"}, onSingleton=true, required=1)
    public static abstract class AsTimeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static Object asTime(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                return AsTimeNode.getContext(node).getEnv().asGuestValue((Object)receivers.asTime(receiver));
            }
            catch (UnsupportedMessageException e) {
                throw translateInteropException.execute(node, (InteropException)((Object)e));
            }
        }
    }

    @CoreMethod(names={"time?"}, onSingleton=true, required=1)
    public static abstract class IsTimeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean isTime(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers) {
            return receivers.isTime(receiver);
        }
    }

    @CoreMethod(names={"as_instant"}, onSingleton=true, required=1)
    public static abstract class AsInstantNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static Object asInstant(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                return AsInstantNode.getContext(node).getEnv().asGuestValue((Object)receivers.asInstant(receiver));
            }
            catch (UnsupportedMessageException e) {
                throw translateInteropException.execute(node, (InteropException)((Object)e));
            }
        }
    }

    @CoreMethod(names={"instant?"}, onSingleton=true, required=1)
    public static abstract class IsInstantNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean isInstant(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers) {
            return receivers.isInstant(receiver);
        }
    }

    @CoreMethod(names={"as_duration"}, onSingleton=true, required=1)
    public static abstract class AsDurationNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static Object asDuration(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                return AsDurationNode.getContext(node).getEnv().asGuestValue((Object)receivers.asDuration(receiver));
            }
            catch (UnsupportedMessageException e) {
                throw translateInteropException.execute(node, (InteropException)((Object)e));
            }
        }
    }

    @CoreMethod(names={"duration?"}, onSingleton=true, required=1)
    public static abstract class IsDurationNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean isDuration(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers) {
            return receivers.isDuration(receiver);
        }
    }

    @CoreMethod(names={"as_date"}, onSingleton=true, required=1)
    public static abstract class AsDateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static Object asDate(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                return AsDateNode.getContext(node).getEnv().asGuestValue((Object)receivers.asDate(receiver));
            }
            catch (UnsupportedMessageException e) {
                throw translateInteropException.execute(node, (InteropException)((Object)e));
            }
        }
    }

    @CoreMethod(names={"date?"}, onSingleton=true, required=1)
    public static abstract class IsDateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean isDate(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers) {
            return receivers.isDate(receiver);
        }
    }

    @CoreMethod(names={"as_boolean"}, onSingleton=true, required=1)
    public static abstract class AsBooleanNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static boolean asBoolean(Object receiver, @Cached TranslateInteropExceptionNode translateInteropException, @CachedLibrary(value="receiver") InteropLibrary receivers, @Bind(value="this") Node node) {
            try {
                return receivers.asBoolean(receiver);
            }
            catch (InteropException e) {
                throw translateInteropException.execute(node, e);
            }
        }
    }

    @CoreMethod(names={"boolean?"}, onSingleton=true, required=1)
    public static abstract class IsBooleanNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean isBoolean(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers) {
            return receivers.isBoolean(receiver);
        }
    }

    @CoreMethod(names={"to_string"}, onSingleton=true, required=1)
    public static abstract class ToStringNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyString toString(Object value, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            return this.createString(fromJavaStringNode, String.valueOf(value), Encodings.UTF_8);
        }
    }

    @CoreMethod(names={"to_display_string"}, onSingleton=true, required=1)
    public static abstract class ToDisplayStringNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        Object toDisplayString(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers) {
            return receivers.toDisplayString(receiver, true);
        }
    }

    @Primitive(name="foreign_string_to_ruby_string")
    public static abstract class ForeignStringToRubyStringNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static RubyString foreignStringToRubyString(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers, @Cached TranslateInteropExceptionNode translateInteropException, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Bind(value="this") Node node) {
            TruffleString truffleString;
            try {
                truffleString = receivers.asTruffleString(receiver);
            }
            catch (InteropException e) {
                throw translateInteropException.execute(node, e);
            }
            TruffleString asUTF8 = switchEncodingNode.execute((AbstractTruffleString)truffleString, TruffleString.Encoding.UTF_8);
            RubyString rubyString = ForeignStringToRubyStringNode.createString(node, asUTF8, Encodings.UTF_8);
            rubyString.freeze();
            return rubyString;
        }
    }

    @CoreMethod(names={"as_truffle_string"}, onSingleton=true, required=1)
    public static abstract class AsTruffleStringNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static TruffleString asTruffleString(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                return receivers.asTruffleString(receiver);
            }
            catch (InteropException e) {
                throw translateInteropException.execute(node, e);
            }
        }
    }

    @CoreMethod(names={"as_string"}, onSingleton=true, required=1)
    public static abstract class AsStringNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static String asString(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                return receivers.asString(receiver);
            }
            catch (InteropException e) {
                throw translateInteropException.execute(node, e);
            }
        }
    }

    @CoreMethod(names={"string?"}, onSingleton=true, required=1)
    public static abstract class IsStringNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean isString(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers) {
            return receivers.isString(receiver);
        }
    }

    @CoreMethod(names={"source_location"}, onSingleton=true, required=1)
    public static abstract class GetSourceLocationNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static RubySourceLocation getSourceLocation(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            SourceSection sourceLocation;
            try {
                sourceLocation = receivers.getSourceLocation(receiver);
            }
            catch (UnsupportedMessageException e) {
                throw translateInteropException.execute(node, (InteropException)((Object)e));
            }
            return new RubySourceLocation(GetSourceLocationNode.coreLibrary((Node)node).sourceLocationClass, GetSourceLocationNode.getLanguage((Node)node).sourceLocationShape, sourceLocation);
        }
    }

    @CoreMethod(names={"has_source_location?"}, onSingleton=true, required=1)
    public static abstract class HasSourceLocationNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean hasSourceLocation(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers) {
            return receivers.hasSourceLocation(receiver);
        }
    }

    @CoreMethod(names={"array_element_existing?"}, onSingleton=true, required=2)
    public static abstract class IsArrayElementExistingNode
    extends CoreMethodArrayArgumentsNode {
        public abstract boolean execute(Object var1, long var2);

        @Specialization(limit="getInteropCacheLimit()")
        boolean isArrayElementExisting(Object receiver, long index, @CachedLibrary(value="receiver") InteropLibrary receivers) {
            return receivers.isArrayElementExisting(receiver, index);
        }
    }

    @CoreMethod(names={"array_element_writable?"}, onSingleton=true, required=2)
    public static abstract class IsArrayElementWritableNode
    extends CoreMethodArrayArgumentsNode {
        public abstract boolean execute(Object var1, long var2);

        @Specialization(limit="getInteropCacheLimit()")
        boolean isArrayElementWritable(Object receiver, long index, @CachedLibrary(value="receiver") InteropLibrary receivers) {
            return receivers.isArrayElementWritable(receiver, index);
        }
    }

    @CoreMethod(names={"array_element_removable?"}, onSingleton=true, required=2)
    public static abstract class IsArrayElementRemovableNode
    extends CoreMethodArrayArgumentsNode {
        public abstract boolean execute(Object var1, long var2);

        @Specialization(limit="getInteropCacheLimit()")
        boolean isArrayElementRemovable(Object receiver, long index, @CachedLibrary(value="receiver") InteropLibrary receivers) {
            return receivers.isArrayElementRemovable(receiver, index);
        }
    }

    @CoreMethod(names={"array_element_insertable?"}, onSingleton=true, required=2)
    public static abstract class IsArrayElementInsertableNode
    extends CoreMethodArrayArgumentsNode {
        public abstract boolean execute(Object var1, long var2);

        @Specialization(limit="getInteropCacheLimit()")
        boolean isArrayElementInsertable(Object receiver, long index, @CachedLibrary(value="receiver") InteropLibrary receivers) {
            return receivers.isArrayElementInsertable(receiver, index);
        }
    }

    @CoreMethod(names={"array_element_modifiable?"}, onSingleton=true, required=2)
    public static abstract class IsArrayElementModifiableNode
    extends CoreMethodArrayArgumentsNode {
        public abstract boolean execute(Object var1, long var2);

        @Specialization(limit="getInteropCacheLimit()")
        boolean isArrayElementModifiable(Object receiver, long index, @CachedLibrary(value="receiver") InteropLibrary receivers) {
            return receivers.isArrayElementModifiable(receiver, index);
        }
    }

    @CoreMethod(names={"array_element_readable?"}, onSingleton=true, required=2)
    public static abstract class IsArrayElementReadableNode
    extends CoreMethodArrayArgumentsNode {
        public abstract boolean execute(Object var1, long var2);

        @Specialization(limit="getInteropCacheLimit()")
        boolean isArrayElementReadable(Object receiver, long index, @CachedLibrary(value="receiver") InteropLibrary receivers) {
            return receivers.isArrayElementReadable(receiver, index);
        }
    }

    @CoreMethod(names={"remove_array_element"}, onSingleton=true, required=2)
    public static abstract class RemoveArrayElementNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static Nil readArrayElement(Object receiver, long identifier, @CachedLibrary(value="receiver") InteropLibrary receivers, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                receivers.removeArrayElement(receiver, identifier);
            }
            catch (InteropException e) {
                throw translateInteropException.execute(node, e);
            }
            return Nil.INSTANCE;
        }
    }

    @CoreMethod(names={"write_array_element"}, onSingleton=true, required=3)
    public static abstract class WriteArrayElementNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static Object write(Object receiver, long identifier, Object value, @CachedLibrary(value="receiver") InteropLibrary receivers, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                receivers.writeArrayElement(receiver, identifier, value);
            }
            catch (InteropException e) {
                throw translateInteropException.execute(node, e);
            }
            return value;
        }
    }

    @CoreMethod(names={"read_array_element"}, onSingleton=true, required=2)
    public static abstract class ReadArrayElementNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static Object readArrayElement(Object receiver, long identifier, @CachedLibrary(value="receiver") InteropLibrary receivers, @Cached ForeignToRubyNode foreignToRubyNode, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            Object foreign;
            try {
                foreign = receivers.readArrayElement(receiver, identifier);
            }
            catch (InteropException e) {
                throw translateInteropException.execute(node, e);
            }
            return foreignToRubyNode.execute(node, foreign);
        }
    }

    @CoreMethod(names={"array_size"}, onSingleton=true, required=1)
    public static abstract class ArraySizeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static Object arraySize(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            try {
                return receivers.getArraySize(receiver);
            }
            catch (InteropException e) {
                throw translateInteropException.execute(node, e);
            }
        }
    }

    @CoreMethod(names={"has_array_elements?"}, onSingleton=true, required=1)
    public static abstract class HasArrayElementsNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean hasArrayElements(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers) {
            return receivers.hasArrayElements(receiver);
        }
    }

    @CoreMethod(names={"instantiate"}, onSingleton=true, required=1, rest=true)
    public static abstract class InstantiateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static Object newCached(Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary receivers, @Cached ForeignToRubyNode foreignToRubyNode, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            Object foreign;
            try {
                foreign = receivers.instantiate(receiver, args);
            }
            catch (InteropException e) {
                throw translateInteropException.execute(node, e);
            }
            return foreignToRubyNode.execute(node, foreign);
        }
    }

    @CoreMethod(names={"instantiable?"}, onSingleton=true, required=1)
    public static abstract class InstantiableNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean isInstantiable(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers) {
            return receivers.isInstantiable(receiver);
        }
    }

    @CoreMethod(names={"execute_without_conversion"}, onSingleton=true, required=1, rest=true)
    public static abstract class ExecuteWithoutConversionNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static Object interopExecuteWithoutConversion(Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary receivers, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            return InteropNodes.execute(node, receiver, args, receivers, translateInteropException);
        }
    }

    @CoreMethod(names={"execute"}, onSingleton=true, required=1, rest=true)
    public static abstract class ExecuteNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static Object interopExecute(Object receiver, Object[] args, @CachedLibrary(value="receiver") InteropLibrary receivers, @Cached ForeignToRubyNode foreignToRubyNode, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            Object foreign = InteropNodes.execute(node, receiver, args, receivers, translateInteropException);
            return foreignToRubyNode.execute(node, foreign);
        }
    }

    @CoreMethod(names={"executable_name"}, onSingleton=true, required=1)
    public static abstract class ExecutableNameNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static Object getExecutableName(Object receiver, @Cached TranslateInteropExceptionNode translateInteropException, @CachedLibrary(value="receiver") InteropLibrary receivers, @Bind(value="this") Node node) {
            try {
                return receivers.getExecutableName(receiver);
            }
            catch (UnsupportedMessageException e) {
                throw translateInteropException.execute(node, (InteropException)((Object)e));
            }
        }
    }

    @CoreMethod(names={"has_executable_name?"}, onSingleton=true, required=1)
    public static abstract class HasExecutableNameNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean hasExecutableName(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers) {
            return receivers.hasExecutableName(receiver);
        }
    }

    @CoreMethod(names={"executable?"}, onSingleton=true, required=1)
    public static abstract class IsExecutableNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean isExecutable(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers) {
            return receivers.isExecutable(receiver);
        }
    }

    @CoreMethod(names={"throw_exception"}, onSingleton=true, required=1)
    public static abstract class ThrowExceptionNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static Object throwException(Object receiver, @Cached TranslateInteropExceptionNode translateInteropException, @CachedLibrary(value="receiver") InteropLibrary receivers, @Bind(value="this") Node node) {
            try {
                throw receivers.throwException(receiver);
            }
            catch (UnsupportedMessageException e) {
                throw translateInteropException.execute(node, (InteropException)((Object)e));
            }
        }
    }

    @CoreMethod(names={"exception_type"}, onSingleton=true, required=1)
    public static abstract class ExceptionTypeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static RubySymbol getExceptionType(Object receiver, @Cached TranslateInteropExceptionNode translateInteropException, @CachedLibrary(value="receiver") InteropLibrary receivers, @Bind(value="this") Node node) {
            try {
                ExceptionType exceptionType = receivers.getExceptionType(receiver);
                return ExceptionTypeNode.getLanguage(node).getSymbol(exceptionType.name());
            }
            catch (UnsupportedMessageException e) {
                throw translateInteropException.execute(node, (InteropException)((Object)e));
            }
        }
    }

    @CoreMethod(names={"exception_stack_trace"}, onSingleton=true, required=1)
    public static abstract class ExceptionStackTraceNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static Object getExceptionStackTrace(Object receiver, @Cached TranslateInteropExceptionNode translateInteropException, @CachedLibrary(value="receiver") InteropLibrary receivers, @Bind(value="this") Node node) {
            try {
                return receivers.getExceptionStackTrace(receiver);
            }
            catch (UnsupportedMessageException e) {
                throw translateInteropException.execute(node, (InteropException)((Object)e));
            }
        }
    }

    @CoreMethod(names={"has_exception_stack_trace?"}, onSingleton=true, required=1)
    public static abstract class HasExceptionStackTraceNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean hasExceptionStackTrace(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers) {
            return receivers.hasExceptionStackTrace(receiver);
        }
    }

    @CoreMethod(names={"exception_message"}, onSingleton=true, required=1)
    public static abstract class ExceptionMessageNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static Object getExceptionMessage(Object receiver, @Cached TranslateInteropExceptionNode translateInteropException, @CachedLibrary(value="receiver") InteropLibrary receivers, @Bind(value="this") Node node) {
            try {
                return receivers.getExceptionMessage(receiver);
            }
            catch (UnsupportedMessageException e) {
                throw translateInteropException.execute(node, (InteropException)((Object)e));
            }
        }
    }

    @CoreMethod(names={"has_exception_message?"}, onSingleton=true, required=1)
    public static abstract class HasExceptionMessageNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean hasExceptionMessage(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers) {
            return receivers.hasExceptionMessage(receiver);
        }
    }

    @CoreMethod(names={"exception_incomplete_source?"}, onSingleton=true, required=1)
    public static abstract class IsExceptionIncompleteSourceNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static boolean isExceptionIncompleteSource(Object receiver, @Cached TranslateInteropExceptionNode translateInteropException, @CachedLibrary(value="receiver") InteropLibrary receivers, @Bind(value="this") Node node) {
            try {
                return receivers.isExceptionIncompleteSource(receiver);
            }
            catch (UnsupportedMessageException e) {
                throw translateInteropException.execute(node, (InteropException)((Object)e));
            }
        }
    }

    @CoreMethod(names={"exception_exit_status"}, onSingleton=true, required=1)
    public static abstract class ExceptionExitStatusSourceNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static int getExceptionExitStatus(Object receiver, @Cached TranslateInteropExceptionNode translateInteropException, @CachedLibrary(value="receiver") InteropLibrary receivers, @Bind(value="this") Node node) {
            try {
                return receivers.getExceptionExitStatus(receiver);
            }
            catch (UnsupportedMessageException e) {
                throw translateInteropException.execute(node, (InteropException)((Object)e));
            }
        }
    }

    @CoreMethod(names={"exception_cause"}, onSingleton=true, required=1)
    public static abstract class ExceptionCauseNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static Object getExceptionCause(Object receiver, @Cached TranslateInteropExceptionNode translateInteropException, @CachedLibrary(value="receiver") InteropLibrary receivers, @Bind(value="this") Node node) {
            try {
                return receivers.getExceptionCause(receiver);
            }
            catch (UnsupportedMessageException e) {
                throw translateInteropException.execute(node, (InteropException)((Object)e));
            }
        }
    }

    @CoreMethod(names={"has_exception_cause?"}, onSingleton=true, required=1)
    public static abstract class HasExceptionCauseNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean hasExceptionCause(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers) {
            return receivers.hasExceptionCause(receiver);
        }
    }

    @CoreMethod(names={"exception?"}, onSingleton=true, required=1)
    public static abstract class IsExceptionNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean isException(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers) {
            return receivers.isException(receiver);
        }
    }

    @CoreMethod(names={"polyglot_bindings_access?"}, onSingleton=true)
    public static abstract class IsPolyglotBindingsAccessAllowedNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isPolyglotBindingsAccessAllowed() {
            return this.getContext().getEnv().isPolyglotBindingsAccessAllowed();
        }
    }

    @Primitive(name="interop_eval_nfi")
    public static abstract class InteropEvalNFINode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"library.isRubyString(code)"}, limit="1")
        Object evalNFI(Object code, @Cached RubyStringLibrary library, @Cached IndirectCallNode callNode) {
            return callNode.call(this.parse(code), EMPTY_ARGUMENTS);
        }

        @CompilerDirectives.TruffleBoundary
        protected CallTarget parse(Object code) {
            Source source = Source.newBuilder((String)"nfi", (CharSequence)RubyGuards.getJavaString(code), (String)"(eval)").build();
            try {
                return this.getContext().getEnv().parseInternal(source, new String[0]);
            }
            catch (IllegalStateException e) {
                throw new RaiseException(this.getContext(), this.coreExceptions().argumentError(e.getMessage(), this));
            }
        }
    }

    @CoreMethod(names={"eval"}, onSingleton=true, required=2)
    @ReportPolymorphism
    public static abstract class EvalNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"stringsMimeType.isRubyString(mimeType)", "stringsSource.isRubyString(source)", "mimeTypeEqualNode.execute(stringsMimeType, mimeType, cachedMimeType, cachedMimeTypeEnc)", "sourceEqualNode.execute(stringsSource, source, cachedSource, cachedSourceEnc)"}, limit="getEvalCacheLimit()")
        Object evalCached(Object mimeType, Object source, @Cached.Shared @Cached RubyStringLibrary stringsMimeType, @Cached.Shared @Cached RubyStringLibrary stringsSource, @Cached(value="asTruffleStringUncached(mimeType)") TruffleString cachedMimeType, @Cached(value="stringsMimeType.getEncoding(mimeType)") RubyEncoding cachedMimeTypeEnc, @Cached(value="asTruffleStringUncached(source)") TruffleString cachedSource, @Cached(value="stringsSource.getEncoding(source)") RubyEncoding cachedSourceEnc, @Bind(value="this") Node node, @Cached(value="create(parse(node, getJavaString(mimeType), getJavaString(source)))") DirectCallNode callNode, @Cached StringHelperNodes.EqualNode mimeTypeEqualNode, @Cached StringHelperNodes.EqualNode sourceEqualNode) {
            return callNode.call(EMPTY_ARGUMENTS);
        }

        @Specialization(guards={"stringsMimeType.isRubyString(mimeType)", "stringsSource.isRubyString(source)"}, replaces={"evalCached"})
        static Object evalUncached(Object mimeType, RubyString source, @Cached.Shared @Cached RubyStringLibrary stringsMimeType, @Cached.Shared @Cached RubyStringLibrary stringsSource, @Cached ToJavaStringNode toJavaStringMimeNode, @Cached ToJavaStringNode toJavaStringSourceNode, @Cached IndirectCallNode callNode, @Bind(value="this") Node node) {
            return callNode.call(EvalNode.parse(node, toJavaStringMimeNode.execute(node, mimeType), toJavaStringSourceNode.execute(node, (Object)source)), EMPTY_ARGUMENTS);
        }

        @CompilerDirectives.TruffleBoundary
        protected static CallTarget parse(Node node, String mimeTypeString, String codeString) {
            String language = Source.findLanguage((String)mimeTypeString);
            if (language == null) {
                language = mimeTypeString;
            }
            Source source = Source.newBuilder((String)language, (CharSequence)codeString, (String)"(eval)").build();
            try {
                return EvalNode.getContext(node).getEnv().parsePublic(source, new String[0]);
            }
            catch (IllegalStateException e) {
                throw new RaiseException(EvalNode.getContext(node), EvalNode.coreExceptions(node).argumentError(e.getMessage(), node));
            }
        }

        protected int getEvalCacheLimit() {
            return this.getLanguage().options.EVAL_CACHE;
        }
    }

    @CoreMethod(names={"import_file"}, onSingleton=true, required=1)
    public static abstract class ImportFileNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"strings.isRubyString(fileName)"}, limit="1")
        Object importFile(Object fileName, @Cached RubyStringLibrary strings) {
            try {
                TruffleFile file = this.getContext().getEnv().getPublicTruffleFile(RubyGuards.getJavaString(fileName).intern());
                Source source = Source.newBuilder((String)"ruby", (TruffleFile)file).build();
                this.getContext().getEnv().parsePublic(source, new String[0]).call(new Object[0]);
            }
            catch (IOException e) {
                throw new RaiseException(this.getContext(), this.coreExceptions().ioError(e, (Node)this));
            }
            return nil;
        }
    }

    @CoreMethod(names={"mime_type_supported?"}, onSingleton=true, required=1)
    public static abstract class MimeTypeSupportedNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"strings.isRubyString(mimeType)"}, limit="1")
        boolean isMimeTypeSupported(RubyString mimeType, @Cached RubyStringLibrary strings) {
            return this.getContext().getEnv().isMimeTypeSupported(RubyGuards.getJavaString((Object)mimeType));
        }
    }

    @CoreMethod(names={"proxy_foreign_object"}, onSingleton=true, required=1, optional=1)
    public static abstract class ProxyForeignObjectNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object proxyForeignObject(Object delegate, NotProvided logger) {
            return new ProxyForeignObject(delegate);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"wasProvided(logger)"})
        Object proxyForeignObject(Object delegate, Object logger) {
            return new ProxyForeignObject(delegate, logger);
        }
    }

    @CoreMethod(names={"foreign?"}, onSingleton=true, required=1)
    public static abstract class InteropIsForeignNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean isForeign(Object value) {
            return RubyGuards.isForeignObject(value);
        }
    }

    @Primitive(name="dispatch_missing")
    public static abstract class DispatchMissingNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object dispatchMissing() {
            return DispatchNode.MISSING;
        }
    }

    @Primitive(name="interop_execute")
    public static abstract class InteropExecuteNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        static Object interopExecuteWithoutConversion(Object receiver, RubyArray argsArray, @CachedLibrary(value="receiver") InteropLibrary receivers, @Cached ArrayToObjectArrayNode arrayToObjectArrayNode, @Cached TranslateInteropExceptionNode translateInteropException, @Bind(value="this") Node node) {
            Object[] args = arrayToObjectArrayNode.executeToObjectArray(argsArray);
            return InteropNodes.execute(node, receiver, args, receivers, translateInteropException);
        }
    }

    @Primitive(name="interop_null?")
    public static abstract class InteropIsNullNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(limit="getInteropCacheLimit()")
        boolean isNull(Object receiver, @CachedLibrary(value="receiver") InteropLibrary receivers) {
            return receivers.isNull(receiver);
        }
    }

    @Primitive(name="interop_library_all_methods")
    public static abstract class AllMethodsOfInteropLibrary
    extends PrimitiveArrayArgumentsNode {
        private static final String[] METHODS = AllMethodsOfInteropLibrary.publicInteropLibraryMethods();

        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyArray allMethodsOfInteropLibrary(@Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            Object[] store = new Object[METHODS.length];
            for (int i = 0; i < METHODS.length; ++i) {
                store[i] = this.createString(fromJavaStringNode, METHODS[i], Encodings.UTF_8);
            }
            return this.createArray(store);
        }

        private static String[] publicInteropLibraryMethods() {
            ArrayList<String> methods = new ArrayList<String>();
            for (Method method : InteropLibrary.class.getDeclaredMethods()) {
                if (!Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || methods.contains(method.getName())) continue;
                methods.add(method.getName());
            }
            return methods.toArray(StringUtils.EMPTY_STRING_ARRAY);
        }
    }
}

