/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.extra;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.Shape;
import java.util.concurrent.ConcurrentHashMap;
import org.truffleruby.core.kernel.KernelNodes;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.language.RubyDynamicObject;

public final class RubyConcurrentMap
extends RubyDynamicObject {
    private ConcurrentHashMap<Key, Object> map;

    public RubyConcurrentMap(RubyClass rubyClass, Shape shape) {
        super(rubyClass, shape);
    }

    @CompilerDirectives.TruffleBoundary
    public void allocateMap(int initialCapacity, float loadFactor) {
        this.map = initialCapacity <= 0 ? new ConcurrentHashMap() : (loadFactor <= 0.0f ? new ConcurrentHashMap(initialCapacity) : new ConcurrentHashMap(initialCapacity, loadFactor));
    }

    public ConcurrentHashMap<Key, Object> getMap() {
        return this.map;
    }

    public static final class Key {
        public final Object key;
        private final int hashCode;

        public Key(Object key, int hashCode) {
            this.key = key;
            this.hashCode = hashCode;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            assert (other instanceof Key);
            Key otherKey = (Key)other;
            if (this.key == otherKey.key) {
                return true;
            }
            if (this.hashCode != otherKey.hashCode) {
                return false;
            }
            return KernelNodes.SameOrEqlNode.getUncached().execute(this.key, otherKey.key);
        }
    }
}

