/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.extra;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.Shape;
import java.util.concurrent.atomic.AtomicReference;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.core.basicobject.ReferenceEqualNode;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.extra.RubyAtomicReference;
import org.truffleruby.language.Nil;
import org.truffleruby.language.NotProvided;
import org.truffleruby.language.RubyGuards;
import org.truffleruby.language.objects.AllocationTracing;

@CoreModule(value="TruffleRuby::AtomicReference", isClass=true)
public abstract class AtomicReferenceNodes {

    @CoreMethod(names={"compare_and_set_reference"}, required=2, visibility=Visibility.PRIVATE)
    public static abstract class CompareAndSetReferenceNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"isPrimitive(expectedValue)"})
        boolean compareAndSetPrimitive(RubyAtomicReference self, Object expectedValue, Object newValue, @Cached ReferenceEqualNode equalNode) {
            Object currentValue;
            while (RubyGuards.isPrimitive(currentValue = self.value.get()) && equalNode.execute(this, expectedValue, currentValue)) {
                if (!self.value.compareAndSet(currentValue, newValue)) continue;
                return true;
            }
            return false;
        }

        @Specialization(guards={"!isPrimitive(expectedValue)"})
        boolean compareAndSetReference(RubyAtomicReference self, Object expectedValue, Object newValue) {
            return self.value.compareAndSet(expectedValue, newValue);
        }
    }

    @CoreMethod(names={"get_and_set"}, required=1)
    public static abstract class GetAndSetNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object getAndSet(RubyAtomicReference self, Object value) {
            return self.value.getAndSet(value);
        }
    }

    @CoreMethod(names={"set"}, required=1)
    public static abstract class SetNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object set(RubyAtomicReference self, Object value) {
            self.value.set(value);
            return value;
        }
    }

    @CoreMethod(names={"get"})
    public static abstract class GetNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object get(RubyAtomicReference self) {
            return self.value.get();
        }
    }

    @CoreMethod(names={"initialize"}, optional=1)
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyAtomicReference initializeNoValue(RubyAtomicReference self, NotProvided value) {
            return self;
        }

        @Specialization
        RubyAtomicReference initializeNil(RubyAtomicReference self, Nil value) {
            return self;
        }

        @Specialization(guards={"!isNil(value)", "wasProvided(value)"})
        RubyAtomicReference initializeWithValue(RubyAtomicReference self, Object value) {
            self.value.set(value);
            return self;
        }
    }

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyAtomicReference allocate(RubyClass rubyClass) {
            Shape shape = this.getLanguage().atomicReferenceShape;
            RubyAtomicReference instance = new RubyAtomicReference(rubyClass, shape, new AtomicReference<Object>(nil));
            AllocationTracing.trace(instance, this);
            return instance;
        }
    }
}

