/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.debug;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;

@ExportLibrary(value=InteropLibrary.class)
public final class VariableNamesObject
implements TruffleObject {
    private final String[] names;

    public VariableNamesObject(String[] names) {
        this.names = names;
    }

    @ExportMessage
    protected boolean hasArrayElements() {
        return true;
    }

    @ExportMessage
    protected long getArraySize() {
        return this.names.length;
    }

    @ExportMessage
    protected Object readArrayElement(long index, @Cached InlinedBranchProfile errorProfile, @Bind(value="$node") Node node) throws InvalidArrayIndexException {
        if (this.isArrayElementReadable(index)) {
            return this.names[(int)index];
        }
        errorProfile.enter(node);
        throw InvalidArrayIndexException.create((long)index);
    }

    @ExportMessage
    protected boolean isArrayElementReadable(long index) {
        return index >= 0L && index < (long)this.names.length;
    }
}

