/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.debug;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.string.StringOperations;
import org.truffleruby.debug.VariableNamesObject;
import org.truffleruby.language.dispatch.DispatchNode;
import org.truffleruby.language.globals.GlobalVariableStorage;
import org.truffleruby.language.globals.GlobalVariables;
import org.truffleruby.parser.Identifiers;

@ExportLibrary(value=InteropLibrary.class)
public final class GlobalVariablesObject
implements TruffleObject {
    private final GlobalVariables globalVariables;

    public GlobalVariablesObject(GlobalVariables globalVariables) {
        this.globalVariables = globalVariables;
    }

    @ExportMessage
    protected boolean hasMembers() {
        return true;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    protected Object getMembers(boolean includeInternal) {
        return new VariableNamesObject(this.globalVariables.keys());
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    protected Object readMember(String member, @CachedLibrary(value="this") InteropLibrary node, @Cached.Exclusive @Cached DispatchNode evalNode) throws UnknownIdentifierException {
        if (!this.isMemberReadable(member)) {
            throw UnknownIdentifierException.create((String)member);
        }
        RubyLanguage language = RubyLanguage.get((Node)node);
        RubyContext context = RubyContext.get((Node)node);
        RubyString string = StringOperations.createUTF8String(context, language, member);
        return evalNode.call((Object)context.getCoreLibrary().topLevelBinding, "eval", (Object)string);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    protected void writeMember(String member, Object value, @CachedLibrary(value="this") InteropLibrary node, @Cached.Exclusive @Cached DispatchNode evalNode, @Cached.Exclusive @Cached DispatchNode callNode) throws UnknownIdentifierException {
        if (!GlobalVariablesObject.isValidGlobalVariableName(member)) {
            throw UnknownIdentifierException.create((String)member);
        }
        RubyLanguage language = RubyLanguage.get((Node)node);
        RubyContext context = RubyContext.get((Node)node);
        String code = "-> value { " + member + " = value }";
        RubyString string = StringOperations.createUTF8String(context, language, code);
        Object lambda = evalNode.call((Object)context.getCoreLibrary().topLevelBinding, "eval", (Object)string);
        callNode.call(lambda, "call", value);
    }

    @ExportMessage.Repeat(value={@ExportMessage(name="hasMemberReadSideEffects"), @ExportMessage(name="hasMemberWriteSideEffects")})
    @CompilerDirectives.TruffleBoundary
    protected boolean hasMemberSideEffects(String member, @CachedLibrary(value="this") InteropLibrary node) {
        if (this.isMemberReadable(member)) {
            RubyLanguage language = RubyLanguage.get((Node)node);
            RubyContext context = RubyContext.get((Node)node);
            int index = language.getGlobalVariableIndex(member);
            GlobalVariableStorage storage = context.getGlobalVariableStorage(index);
            return storage.hasHooks();
        }
        return false;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    protected boolean isMemberReadable(String member) {
        return GlobalVariablesObject.isValidGlobalVariableName(member) && this.globalVariables.contains(member);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    protected boolean isMemberModifiable(String member) {
        return GlobalVariablesObject.isValidGlobalVariableName(member) && this.globalVariables.contains(member);
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    protected boolean isMemberInsertable(String member) {
        return GlobalVariablesObject.isValidGlobalVariableName(member) && !this.globalVariables.contains(member);
    }

    private static boolean isValidGlobalVariableName(String name) {
        return Identifiers.isValidGlobalVariableName(name);
    }
}

