/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.tracepoint;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.profiles.BranchProfile;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveNode;
import org.truffleruby.core.array.ArrayToObjectArrayNode;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.binding.RubyBinding;
import org.truffleruby.core.kernel.TraceManager;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.core.tracepoint.RubyTracePoint;
import org.truffleruby.core.tracepoint.TracePointEvent;
import org.truffleruby.core.tracepoint.TracePointState;
import org.truffleruby.language.Nil;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.methods.InternalMethod;
import org.truffleruby.language.objects.AllocationTracing;
import org.truffleruby.language.yield.CallBlockNode;

@CoreModule(value="TracePoint", isClass=true)
public abstract class TracePointNodes {
    @CompilerDirectives.TruffleBoundary
    public static boolean isEnabled(RubyTracePoint tracePoint) {
        return tracePoint.events[0].hasEventBinding();
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean createEventBindings(RubyContext context, RubyLanguage language, RubyTracePoint tracePoint) {
        TracePointEvent[] events;
        for (TracePointEvent event : events = tracePoint.events) {
            if (event.setupEventBinding(context, language, tracePoint)) continue;
            return false;
        }
        return true;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean disposeEventBindings(RubyTracePoint tracePoint) {
        TracePointEvent[] events;
        for (TracePointEvent event : events = tracePoint.events) {
            if (event.diposeEventBinding()) continue;
            return false;
        }
        return true;
    }

    @CoreMethod(names={"self"})
    public static abstract class SelfNode
    extends TracePointCoreNode {
        @Specialization
        Object self(RubyTracePoint tracePoint) {
            RubyBinding binding = this.getTracePointState().binding;
            return RubyArguments.getSelf((Frame)binding.getFrame());
        }
    }

    @CoreMethod(names={"method_id"})
    public static abstract class MethodIDNode
    extends TracePointCoreNode {
        @Specialization
        RubySymbol methodId(RubyTracePoint tracePoint) {
            RubyBinding binding = this.getTracePointState().binding;
            InternalMethod method = RubyArguments.getMethod((Frame)binding.getFrame());
            return this.getSymbol(method.getName());
        }
    }

    @CoreMethod(names={"binding"})
    public static abstract class BindingNode
    extends TracePointCoreNode {
        @Specialization
        RubyBinding binding(RubyTracePoint tracePoint) {
            return this.getTracePointState().binding;
        }
    }

    @CoreMethod(names={"lineno"})
    public static abstract class LineNode
    extends TracePointCoreNode {
        @Specialization
        int line(RubyTracePoint tracePoint) {
            return this.getTracePointState().line;
        }
    }

    @CoreMethod(names={"path"})
    public static abstract class PathNode
    extends TracePointCoreNode {
        @Specialization
        RubyString path(RubyTracePoint tracePoint) {
            return this.getTracePointState().path;
        }
    }

    @CoreMethod(names={"event"})
    public static abstract class EventNode
    extends TracePointCoreNode {
        @Specialization
        RubySymbol event(RubyTracePoint tracePoint) {
            return this.getTracePointState().event;
        }
    }

    @Primitive(name="trace_point_inside_proc?")
    public static abstract class InsideProcNode
    extends PrimitiveNode {
        @Specialization
        Object insideProc() {
            TracePointState state = this.getLanguage().getCurrentThread().tracePointState;
            return state.insideProc;
        }
    }

    private static abstract class TracePointCoreNode
    extends CoreMethodArrayArgumentsNode {
        private final BranchProfile errorProfile = BranchProfile.create();

        private TracePointCoreNode() {
        }

        protected TracePointState getTracePointState() {
            TracePointState state = this.getLanguage().getCurrentThread().tracePointState;
            if (!state.insideProc) {
                this.errorProfile.enter();
                throw new RaiseException(this.getContext(), this.coreExceptions().runtimeError("access from outside", this));
            }
            return state;
        }
    }

    @CoreMethod(names={"enabled?"})
    public static abstract class EnabledNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean enabled(RubyTracePoint tracePoint) {
            return TracePointNodes.isEnabled(tracePoint);
        }
    }

    @CoreMethod(names={"disable"}, needsBlock=true)
    public static abstract class DisableNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object disable(RubyTracePoint tracePoint, Nil block) {
            return TracePointNodes.disposeEventBindings(tracePoint);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        Object disable(RubyTracePoint tracePoint, RubyProc block, @Cached CallBlockNode yieldNode) {
            boolean wasEnabled = TracePointNodes.disposeEventBindings(tracePoint);
            try {
                Object object = yieldNode.yield(block, new Object[0]);
                return object;
            }
            finally {
                if (wasEnabled) {
                    TracePointNodes.createEventBindings(this.getContext(), this.getLanguage(), tracePoint);
                }
            }
        }
    }

    @CoreMethod(names={"enable"}, needsBlock=true)
    public static abstract class EnableNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean enable(RubyTracePoint tracePoint, Nil block) {
            boolean setupDone = TracePointNodes.createEventBindings(this.getContext(), this.getLanguage(), tracePoint);
            return !setupDone;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        Object enable(RubyTracePoint tracePoint, RubyProc block, @Cached CallBlockNode yieldNode) {
            boolean setupDone = TracePointNodes.createEventBindings(this.getContext(), this.getLanguage(), tracePoint);
            try {
                Object object = yieldNode.yield(block, new Object[0]);
                return object;
            }
            finally {
                if (setupDone) {
                    TracePointNodes.disposeEventBindings(tracePoint);
                }
            }
        }
    }

    @Primitive(name="tracepoint_initialize")
    public static abstract class InitializeNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyTracePoint initialize(RubyTracePoint tracePoint, RubyArray eventsArray, RubyProc block, @Cached ArrayToObjectArrayNode arrayToObjectArrayNode) {
            Object[] eventSymbols = arrayToObjectArrayNode.executeToObjectArray(eventsArray);
            TracePointEvent[] events = new TracePointEvent[eventSymbols.length];
            for (int i = 0; i < eventSymbols.length; ++i) {
                events[i] = this.createEvents(this.getLanguage(), (RubySymbol)eventSymbols[i]);
            }
            tracePoint.events = events;
            tracePoint.proc = block;
            return tracePoint;
        }

        @CompilerDirectives.TruffleBoundary
        private TracePointEvent createEvents(RubyLanguage language, RubySymbol eventSymbol) {
            if (eventSymbol == language.coreSymbols.LINE) {
                return new TracePointEvent(TraceManager.LineTag.class, eventSymbol);
            }
            if (eventSymbol == language.coreSymbols.CLASS) {
                return new TracePointEvent(TraceManager.ClassTag.class, eventSymbol);
            }
            if (eventSymbol == language.coreSymbols.NEVER) {
                return new TracePointEvent(TraceManager.NeverTag.class, eventSymbol);
            }
            throw new UnsupportedOperationException(eventSymbol.getString());
        }
    }

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyTracePoint allocate(RubyClass rubyClass) {
            RubyTracePoint instance = new RubyTracePoint(rubyClass, this.getLanguage().tracePointShape, null, null);
            AllocationTracing.trace(instance, this);
            return instance;
        }
    }
}

