/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.tracepoint;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.instrumentation.EventContext;
import com.oracle.truffle.api.instrumentation.ExecutionEventNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.language.yield.CallBlockNode;
import org.truffleruby.parser.RubySource;

public class TraceBaseEventNode
extends ExecutionEventNode {
    protected final RubyContext context;
    private final RubyLanguage language;
    protected final EventContext eventContext;
    @CompilerDirectives.CompilationFinal
    private RubyString file;
    @CompilerDirectives.CompilationFinal
    private int line;
    @Node.Child
    private CallBlockNode yieldNode;

    public TraceBaseEventNode(RubyContext context, RubyLanguage language, EventContext eventContext) {
        this.context = context;
        this.language = language;
        this.eventContext = eventContext;
    }

    protected RubyString getFile() {
        if (this.file == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            Source source = this.eventContext.getInstrumentedSourceSection().getSource();
            this.file = new RubyString(this.context.getCoreLibrary().stringClass, this.language.stringShape, false, (AbstractTruffleString)this.language.getPathToTStringCache().getCachedPath(source), Encodings.UTF_8);
        }
        return this.file;
    }

    protected int getLine() {
        if (this.line == 0) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.line = RubySource.getStartLineAdjusted(this.context, this.eventContext.getInstrumentedSourceSection());
        }
        return this.line;
    }

    protected Object callBlock(RubyProc block, Object ... arguments) {
        if (this.yieldNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.yieldNode = (CallBlockNode)this.insert(CallBlockNode.create());
        }
        return this.yieldNode.yield(block, arguments);
    }
}

