/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.time;

import org.truffleruby.core.time.RubyDateFormatter;
import org.truffleruby.core.time.RubyTimeOutputFormatter;

public final class StrftimeLexer {
    private final String input;
    private final int length;
    private int n = 0;
    private RubyDateFormatter.Token next = null;

    public StrftimeLexer(String input) {
        this.input = input;
        this.length = input.length();
    }

    public RubyDateFormatter.Token directive(char c) {
        RubyDateFormatter.Token token = RubyDateFormatter.Token.format(c);
        if (token != null) {
            return token;
        }
        return RubyDateFormatter.Token.special(c);
    }

    public RubyDateFormatter.Token formatter(String flags, String widthString) {
        int width = 0;
        if (widthString != null) {
            width = Integer.parseInt(widthString);
        }
        return RubyDateFormatter.Token.formatter(new RubyTimeOutputFormatter(flags, width));
    }

    private char current() {
        return this.input.charAt(this.n);
    }

    private char peek() {
        if (this.n + 1 >= this.length) {
            return '\u0000';
        }
        return this.input.charAt(this.n + 1);
    }

    private boolean consume(char c) {
        if (this.current() == c) {
            ++this.n;
            return true;
        }
        return false;
    }

    public RubyDateFormatter.Token yylex() {
        RubyDateFormatter.Token nextToken = this.next;
        if (nextToken != null) {
            this.next = null;
            return nextToken;
        }
        if (this.n >= this.length) {
            return null;
        }
        if (this.consume('%')) {
            RubyDateFormatter.Token token = this.parseLiteralPercent();
            if (token != null) {
                return token;
            }
            token = this.parseSimpleDirective();
            if (token != null) {
                return token;
            }
            token = this.parseComplexDirective();
            if (token != null) {
                return token;
            }
            return RubyDateFormatter.Token.str("%");
        }
        return this.parseUnknown();
    }

    private RubyDateFormatter.Token parseLiteralPercent() {
        if (this.consume('%')) {
            return RubyDateFormatter.Token.str("%");
        }
        return null;
    }

    private RubyDateFormatter.Token parseSimpleDirective() {
        return this.parseConversion();
    }

    private RubyDateFormatter.Token parseComplexDirective() {
        int from = this.n;
        String flags = this.parseFlags();
        if (flags != null) {
            String width = this.parseWidth();
            RubyDateFormatter.Token directive = this.parseConversion();
            if (directive != null) {
                this.next = directive;
                return this.formatter(flags, width);
            }
        } else {
            RubyDateFormatter.Token directive;
            String width = this.parseWidth();
            if (width != null && (directive = this.parseConversion()) != null) {
                this.next = directive;
                return this.formatter("", width);
            }
        }
        this.n = from;
        return null;
    }

    private String parseFlags() {
        int from = this.n;
        if (this.n < this.length && this.parseFlag()) {
            ++this.n;
            while (this.n < this.length && this.parseFlag()) {
                ++this.n;
            }
            return this.input.substring(from, this.n);
        }
        return null;
    }

    private boolean parseFlag() {
        switch (this.current()) {
            case '#': 
            case '-': 
            case '0': 
            case '^': 
            case '_': {
                return true;
            }
        }
        return false;
    }

    private String parseWidth() {
        int from = this.n++;
        if ('1' <= this.current() && this.current() <= '9') {
            while (this.n < this.length && '0' <= this.current() && this.current() <= '9') {
                ++this.n;
            }
            return this.input.substring(from, this.n);
        }
        return null;
    }

    private RubyDateFormatter.Token parseUnknown() {
        int from = this.n;
        while (this.n < this.length && this.current() != '%') {
            ++this.n;
        }
        return RubyDateFormatter.Token.str(this.input.substring(from, this.n));
    }

    private RubyDateFormatter.Token parseConversion() {
        char c = this.current();
        switch (c) {
            case '+': 
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'G': 
            case 'H': 
            case 'I': 
            case 'L': 
            case 'M': 
            case 'N': 
            case 'P': 
            case 'Q': 
            case 'R': 
            case 'S': 
            case 'T': 
            case 'U': 
            case 'V': 
            case 'W': 
            case 'X': 
            case 'Y': 
            case 'Z': 
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'g': 
            case 'h': 
            case 'j': 
            case 'k': 
            case 'l': 
            case 'm': 
            case 'n': 
            case 'p': 
            case 'r': 
            case 's': 
            case 't': 
            case 'u': 
            case 'v': 
            case 'w': 
            case 'x': 
            case 'y': {
                ++this.n;
                return this.directive(c);
            }
            case 'E': {
                char afterE = this.peek();
                switch (afterE) {
                    case 'C': 
                    case 'X': 
                    case 'Y': 
                    case 'c': 
                    case 'x': 
                    case 'y': {
                        this.n += 2;
                        return this.directive(afterE);
                    }
                }
                return null;
            }
            case 'O': {
                char afterO = this.peek();
                switch (afterO) {
                    case 'H': 
                    case 'I': 
                    case 'M': 
                    case 'S': 
                    case 'U': 
                    case 'V': 
                    case 'W': 
                    case 'd': 
                    case 'e': 
                    case 'k': 
                    case 'l': 
                    case 'm': 
                    case 'u': 
                    case 'w': 
                    case 'y': {
                        this.n += 2;
                        return this.directive(afterO);
                    }
                }
                return null;
            }
            case 'z': {
                ++this.n;
                return RubyDateFormatter.Token.zoneOffsetColons(0);
            }
            case ':': {
                int from = this.n++;
                if (this.consume(':')) {
                    if (this.consume(':')) {
                        if (this.consume('z')) {
                            return RubyDateFormatter.Token.zoneOffsetColons(3);
                        }
                        this.n = from;
                        return null;
                    }
                    if (this.consume('z')) {
                        return RubyDateFormatter.Token.zoneOffsetColons(2);
                    }
                    this.n = from;
                    return null;
                }
                if (this.consume('z')) {
                    return RubyDateFormatter.Token.zoneOffsetColons(1);
                }
                this.n = from;
                return null;
            }
        }
        return null;
    }
}

