/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.thread;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleContext;
import com.oracle.truffle.api.TruffleSafepoint;
import com.oracle.truffle.api.TruffleStackTraceElement;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.graalvm.collections.Pair;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.SuppressFBWarnings;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.collections.Memo;
import org.truffleruby.core.InterruptMode;
import org.truffleruby.core.VMPrimitiveNodes;
import org.truffleruby.core.array.ArrayGuards;
import org.truffleruby.core.array.ArrayToObjectArrayNode;
import org.truffleruby.core.array.RubyArray;
import org.truffleruby.core.basicobject.RubyBasicObject;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.exception.RubyException;
import org.truffleruby.core.fiber.RubyFiber;
import org.truffleruby.core.hash.RubyHash;
import org.truffleruby.core.hash.library.HashStoreLibrary;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.numeric.BigIntegerOps;
import org.truffleruby.core.numeric.RubyBignum;
import org.truffleruby.core.proc.ProcOperations;
import org.truffleruby.core.proc.RubyProc;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.core.support.RubyPRNGRandomizer;
import org.truffleruby.core.symbol.RubySymbol;
import org.truffleruby.core.thread.RubyBacktraceLocation;
import org.truffleruby.core.thread.RubyThread;
import org.truffleruby.core.thread.ThreadManager;
import org.truffleruby.core.thread.ThreadStatus;
import org.truffleruby.interop.ForeignToRubyNode;
import org.truffleruby.interop.TranslateInteropExceptionNode;
import org.truffleruby.language.Nil;
import org.truffleruby.language.NotProvided;
import org.truffleruby.language.SafepointAction;
import org.truffleruby.language.SafepointPredicate;
import org.truffleruby.language.arguments.ArgumentsDescriptor;
import org.truffleruby.language.arguments.RubyArguments;
import org.truffleruby.language.backtrace.Backtrace;
import org.truffleruby.language.backtrace.BacktraceFormatter;
import org.truffleruby.language.control.KillException;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.objects.AllocationTracing;
import org.truffleruby.language.objects.shared.SharedObjects;
import org.truffleruby.language.yield.CallBlockNode;

@CoreModule(value="Thread", isClass=true)
public abstract class ThreadNodes {

    @CoreMethod(names={"each_caller_location"}, needsBlock=true, onSingleton=true)
    public static abstract class EachCallerLocationNode
    extends CoreMethodArrayArgumentsNode {
        private static final int SKIP = 2;
        @Node.Child
        private CallBlockNode yieldNode = CallBlockNode.create();

        @Specialization
        Object eachCallerLocation(VirtualFrame frame, RubyProc block) {
            ArrayList elements = new ArrayList();
            this.getContext().getCallStack().iterateFrameBindings(2, frameInstance -> {
                boolean readyToYield;
                Node location = frameInstance.getCallNode();
                RootCallTarget rootCallTarget = (RootCallTarget)frameInstance.getCallTarget();
                TruffleStackTraceElement element = TruffleStackTraceElement.create((Node)location, (RootCallTarget)rootCallTarget, null);
                elements.add(element);
                TruffleStackTraceElement[] elementsArray = elements.toArray(Backtrace.EMPTY_STACK_TRACE_ELEMENTS_ARRAY);
                boolean bl = readyToYield = BacktraceFormatter.nextAvailableSourceSection(elementsArray, 0) != null;
                if (readyToYield) {
                    for (int i = 0; i < elementsArray.length; ++i) {
                        Backtrace backtrace = new Backtrace(location, 0, elementsArray);
                        RubyBacktraceLocation rubyBacktraceLocation = new RubyBacktraceLocation(this.getContext().getCoreLibrary().threadBacktraceLocationClass, this.getLanguage().threadBacktraceLocationShape, backtrace, i);
                        this.yieldNode.yield(block, new Object[]{rubyBacktraceLocation});
                    }
                    elements.clear();
                }
                return null;
            });
            return nil;
        }

        @Specialization
        Object eachCallerLocation(VirtualFrame frame, Nil block) {
            throw new RaiseException(this.getContext(), this.coreExceptions().localJumpError("no block given", this));
        }
    }

    @Primitive(name="thread_run_blocking_nfi_system_call")
    public static abstract class ThreadRunBlockingSystemCallNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object runBlockingSystemCall(Object executable, RubyArray argsArray, @Cached ArrayToObjectArrayNode arrayToObjectArrayNode, @CachedLibrary(limit="1") InteropLibrary receivers, @Cached TranslateInteropExceptionNode translateInteropExceptionNode, @Cached(value="new(this, receivers, translateInteropExceptionNode)") ThreadManager.BlockingCallInterruptible blockingCallInterruptible, @Cached ForeignToRubyNode foreignToRubyNode) {
            Object[] args = arrayToObjectArrayNode.executeToObjectArray(argsArray);
            RubyThread thread = this.getLanguage().getCurrentThread();
            ThreadManager threadManager = this.getContext().getThreadManager();
            TruffleSafepoint.Interrupter nativeCallInterrupter = threadManager.getNativeCallInterrupter();
            Object result = ThreadManager.executeBlockingCall(thread, nativeCallInterrupter, executable, args, blockingCallInterruptible, this);
            return foreignToRubyNode.execute(this, result);
        }
    }

    @Primitive(name="thread_get_fiber_locals")
    public static abstract class ThreadGetFiberLocalsNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyBasicObject getFiberLocals(RubyThread thread) {
            RubyFiber fiber = thread.getCurrentFiberRacy();
            return fiber.fiberLocals;
        }
    }

    @Primitive(name="thread_set_return_code")
    public static abstract class SetThreadLocalReturnCodeNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object getException(Object processStatus) {
            this.getLanguage().getCurrentThread().threadLocalGlobals.processStatus = processStatus;
            return this.getLanguage().getCurrentThread().threadLocalGlobals.processStatus;
        }
    }

    @Primitive(name="thread_set_exception")
    public static abstract class SetThreadLocalExceptionNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object setException(Object exception) {
            this.getLanguage().getCurrentThread().threadLocalGlobals.setLastException(exception);
            return exception;
        }
    }

    @Primitive(name="thread_get_return_code")
    public static abstract class ThreadGetReturnCodeNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object getExitCode() {
            return this.getLanguage().getCurrentThread().threadLocalGlobals.processStatus;
        }
    }

    @Primitive(name="thread_get_exception")
    public static abstract class ThreadGetExceptionNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object getException() {
            return ThreadGetExceptionNode.getLastException(this.getLanguage().getCurrentThread());
        }

        private static Object getLastException(RubyThread currentThread) {
            return currentThread.threadLocalGlobals.getLastException();
        }

        public static Object getLastException(RubyLanguage language) {
            return ThreadGetExceptionNode.getLastException(language.getCurrentThread());
        }
    }

    @Primitive(name="thread_set_group")
    public static abstract class ThreadSetGroupPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object setGroup(RubyThread thread, Object threadGroup) {
            thread.threadGroup = threadGroup;
            return threadGroup;
        }
    }

    @Primitive(name="thread_set_priority", lowerFixnum={1})
    public static abstract class ThreadSetPriorityPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        int getPriority(RubyThread thread, int javaPriority) {
            Thread javaThread = thread.thread;
            if (javaThread != null) {
                javaThread.setPriority(javaPriority);
            }
            thread.priority = javaPriority;
            return javaPriority;
        }
    }

    @Primitive(name="thread_get_priority")
    public static abstract class ThreadGetPriorityPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        int getPriority(RubyThread thread) {
            Thread javaThread = thread.thread;
            if (javaThread != null) {
                return javaThread.getPriority();
            }
            return thread.priority;
        }
    }

    @Primitive(name="thread_set_name")
    public static abstract class ThreadSetNamePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object setName(RubyThread thread, Object name) {
            thread.name = name;
            return name;
        }
    }

    @CoreMethod(names={"name"})
    public static abstract class ThreadNameNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object getName(RubyThread thread) {
            return thread.name;
        }
    }

    @Primitive(name="thread_source_location")
    public static abstract class ThreadSourceLocationNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private TruffleString.FromJavaStringNode fromJavaStringNode = TruffleString.FromJavaStringNode.create();

        @Specialization
        RubyString sourceLocation(RubyThread thread) {
            return this.createString(this.fromJavaStringNode, thread.sourceLocation, Encodings.UTF_8);
        }
    }

    @Primitive(name="thread_raise")
    public static abstract class ThreadRaisePrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object raise(RubyThread thread, RubyException exception) {
            ThreadRaisePrimitiveNode.raiseInThread(this.getLanguage(), this.getContext(), thread, exception, this);
            return nil;
        }

        @CompilerDirectives.TruffleBoundary
        public static void raiseInThread(RubyLanguage language, RubyContext context, RubyThread rubyThread, final RubyException exception, Node currentNode) {
            SharedObjects.writeBarrier(language, exception);
            context.getSafepointManager().pauseRubyThreadAndExecute(currentNode, new SafepointAction("Thread#raise", rubyThread, true, false){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run(RubyThread rubyThread, Node currentNode) {
                    TruffleSafepoint safepoint = TruffleSafepoint.getCurrent();
                    boolean sideEffects = safepoint.setAllowSideEffects(false);
                    try {
                        RubyContext.send(currentNode, rubyThread, "raise", exception);
                    }
                    finally {
                        safepoint.setAllowSideEffects(sideEffects);
                    }
                    throw CompilerDirectives.shouldNotReachHere((String)"#raise did not throw?");
                }
            });
        }
    }

    @Primitive(name="thread_set_abort_on_exception")
    public static abstract class ThreadSetAbortOnExceptionPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyThread setAbortOnException(RubyThread thread, boolean value) {
            thread.abortOnException = value;
            return thread;
        }
    }

    @Primitive(name="thread_get_abort_on_exception")
    public static abstract class ThreadGetAbortOnExceptionPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        boolean getAbortOnException(RubyThread thread) {
            return thread.abortOnException;
        }
    }

    @Primitive(name="thread_set_report_on_exception")
    public static abstract class ThreadSetReportOnExceptionPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyThread setReportOnException(RubyThread thread, boolean value) {
            thread.reportOnException = value;
            return thread;
        }
    }

    @Primitive(name="thread_get_report_on_exception")
    public static abstract class ThreadGetReportOnExceptionPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        boolean getReportOnException(RubyThread thread) {
            return thread.reportOnException;
        }
    }

    @Primitive(name="thread_detect_recursion_single")
    public static abstract class ThreadDetectRecursionSingleNode
    extends PrimitiveArrayArgumentsNode {
        @Node.Child
        private CallBlockNode yieldNode = CallBlockNode.create();
        @Node.Child
        private HashStoreLibrary hashes = HashStoreLibrary.createDispatched();

        protected boolean add(RubyHash hash, Object key, Object value) {
            return this.hashes.set(hash.store, hash, key, value, true);
        }

        protected Object removeLast(RubyHash hash, Object key) {
            return this.hashes.deleteLast(hash.store, hash, key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        boolean detectRecursionSingle(Object obj, RubyProc block, @Cached InlinedConditionProfile insertedProfile) {
            RubyHash objects = this.getLanguage().getCurrentThread().recursiveObjectsSingle;
            if (insertedProfile.profile((Node)this, this.add(objects, obj, true))) {
                try {
                    this.yieldNode.yield(block, new Object[0]);
                }
                finally {
                    this.removeLast(objects, obj);
                }
                return false;
            }
            return true;
        }
    }

    @Primitive(name="thread_recursive_objects")
    public static abstract class ThreadRecursiveObjectsPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyHash recursiveObjects() {
            return this.getLanguage().getCurrentThread().recursiveObjects;
        }
    }

    @Primitive(name="thread_randomizer")
    public static abstract class ThreadRandomizerPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyPRNGRandomizer randomizer() {
            return this.getLanguage().getCurrentThread().randomizer;
        }
    }

    @Primitive(name="thread_local_variables")
    public static abstract class ThreadLocalVariablesPrimitiveNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyHash threadLocalVariables(RubyThread thread) {
            return thread.threadLocalVariables;
        }
    }

    @CoreMethod(names={"list"}, onSingleton=true)
    public static abstract class ListNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyArray list() {
            return this.createArray(this.getContext().getThreadManager().getThreadList());
        }
    }

    @Primitive(name="call_with_unblocking_function")
    public static abstract class CallWithUnblockingFunctionNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(limit="getCacheLimit()")
        static Object call(RubyThread thread, Object function, Object arg, Object unblocker, Object unblockerArg, @CachedLibrary(value="function") InteropLibrary receivers, @Cached TranslateInteropExceptionNode translateInteropExceptionNode, @Bind(value="this") Node node, @Cached(value="new(node, receivers, translateInteropExceptionNode)") ThreadManager.BlockingCallInterruptible blockingCallInterruptible) {
            ThreadManager threadManager = CallWithUnblockingFunctionNode.getContext(node).getThreadManager();
            TruffleSafepoint.Interrupter interrupter = unblocker == nil ? threadManager.getNativeCallInterrupter() : CallWithUnblockingFunctionNode.makeInterrupter(CallWithUnblockingFunctionNode.getContext(node), unblocker, unblockerArg);
            Object[] args = new Object[]{arg};
            return ThreadManager.executeBlockingCall(thread, interrupter, function, args, blockingCallInterruptible, node);
        }

        @CompilerDirectives.TruffleBoundary
        private static TruffleSafepoint.Interrupter makeInterrupter(RubyContext context, Object function, Object argument) {
            return new CExtInterrupter(context, function, argument);
        }

        protected int getCacheLimit() {
            return this.getLanguage().options.DISPATCH_CACHE;
        }

        private static final class CExtInterrupter
        implements TruffleSafepoint.Interrupter {
            private final RubyContext context;
            private final Object function;
            private final Object argument;

            public CExtInterrupter(RubyContext context, Object function, Object argument) {
                assert (InteropLibrary.getUncached().isExecutable(function));
                this.context = context;
                this.function = function;
                this.argument = argument;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void interrupt(Thread thread) {
                TruffleContext truffleContext = this.context.getEnv().getContext();
                boolean alreadyEntered = truffleContext.isEntered();
                Object prev = null;
                if (!alreadyEntered) {
                    try {
                        if (this.context.getOptions().SINGLE_THREADED) {
                            throw new IllegalStateException("--single-threaded was passed");
                        }
                        prev = truffleContext.enter(null);
                    }
                    catch (IllegalStateException e) {
                        this.context.getLogger().severe("could not unblock thread inside blocking call in C extension because the context does not allow multithreading (" + e.getMessage() + ")");
                        return;
                    }
                }
                try {
                    InteropLibrary.getUncached().execute(this.function, new Object[]{this.argument});
                    if (alreadyEntered) return;
                }
                catch (InteropException e) {
                    try {
                        throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        if (alreadyEntered) throw throwable;
                        truffleContext.leave(null, prev);
                        throw throwable;
                    }
                }
                truffleContext.leave(null, prev);
                return;
            }

            public void resetInterrupted() {
            }
        }
    }

    @CoreMethod(names={"wakeup", "run"})
    public static abstract class WakeupNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"})
        RubyThread wakeup(RubyThread rubyThread) {
            RubyFiber currentFiber = rubyThread.getCurrentFiberRacy();
            Thread thread = currentFiber.thread;
            if (currentFiber.isTerminated() || thread == null) {
                throw new RaiseException(this.getContext(), this.coreExceptions().threadErrorKilledThread(this));
            }
            rubyThread.wakeUp.set(true);
            this.getContext().getSafepointManager().pauseRubyThreadAndExecute(this, new SafepointAction("Thread#wakeup", rubyThread, false, false){

                @Override
                public void run(RubyThread rubyThread, Node currentNode) {
                }
            });
            return rubyThread;
        }
    }

    @CoreMethod(names={"value"})
    public static abstract class ValueNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object value(RubyThread self) {
            JoinNode.doJoin(this.getContext(), this, self);
            Object value = self.value;
            assert (value != null);
            return value;
        }
    }

    @CoreMethod(names={"stop?"})
    public static abstract class StopNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean stop(RubyThread self) {
            ThreadStatus status = self.status;
            return status == ThreadStatus.DEAD || status == ThreadStatus.SLEEP;
        }
    }

    @CoreMethod(names={"native_thread_id"})
    public static abstract class NativeThreadIdNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object nativeThreadId(RubyThread self) {
            return self.nativeThreadId;
        }
    }

    @CoreMethod(names={"status"})
    public static abstract class StatusNode
    extends CoreMethodArrayArgumentsNode {
        @Node.Child
        private TruffleString.FromJavaStringNode fromJavaStringNode = TruffleString.FromJavaStringNode.create();

        @Specialization
        Object status(RubyThread self) {
            ThreadStatus status = self.status;
            if (status == ThreadStatus.DEAD) {
                if (self.exception != null) {
                    return nil;
                }
                return false;
            }
            return this.createString(this.fromJavaStringNode, StringUtils.toLowerCase(status.name()), Encodings.US_ASCII);
        }
    }

    @CoreMethod(names={"pass"}, onSingleton=true)
    public static abstract class PassNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object pass() {
            Thread.yield();
            return nil;
        }
    }

    @CoreMethod(names={"main"}, onSingleton=true)
    public static abstract class MainNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyThread main() {
            return this.getContext().getThreadManager().getRootThread();
        }
    }

    @CoreMethod(names={"join"}, optional=1, lowerFixnum={1})
    public static abstract class JoinNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyThread join(RubyThread thread, NotProvided timeout) {
            JoinNode.doJoin(this.getContext(), this, thread);
            return thread;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyThread join(RubyThread thread, Nil timeout) {
            return this.join(thread, NotProvided.INSTANCE);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object join(RubyThread thread, int timeout) {
            return this.joinNanos(thread, this.clampSecondsToNanos(timeout));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object join(RubyThread thread, long timeout) {
            return this.joinNanos(thread, this.clampSecondsToNanos(timeout));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object join(RubyThread thread, RubyBignum timeout) {
            return this.join(thread, BigIntegerOps.doubleValue(timeout));
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object join(RubyThread thread, double timeout) {
            return this.joinNanos(thread, (long)(timeout * 1.0E9));
        }

        private Object joinNanos(RubyThread self, long timeoutInNanos) {
            if (this.doJoinNanos(self, timeoutInNanos)) {
                return self;
            }
            return nil;
        }

        @CompilerDirectives.TruffleBoundary
        static void doJoin(RubyContext context, Node currentNode, RubyThread thread) {
            context.getThreadManager().runUntilResult(currentNode, () -> {
                thread.finishedLatch.await();
                return true;
            });
            RubyException exception = thread.exception;
            if (exception != null) {
                context.getCoreExceptions().showExceptionIfDebug(exception);
                VMPrimitiveNodes.VMRaiseExceptionNode.reRaiseException(context, exception);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private boolean doJoinNanos(RubyThread thread, long timeoutInNanos) {
            RubyException exception;
            long start = System.nanoTime();
            boolean joined = this.getContext().getThreadManager().runUntilResult(this, () -> {
                long now = System.nanoTime();
                long waited = now - start;
                if (waited >= timeoutInNanos) {
                    return thread.finishedLatch.getCount() == 0L;
                }
                return thread.finishedLatch.await(timeoutInNanos - waited, TimeUnit.NANOSECONDS);
            });
            if (joined && (exception = thread.exception) != null) {
                this.getContext().getCoreExceptions().showExceptionIfDebug(exception);
                VMPrimitiveNodes.VMRaiseExceptionNode.reRaiseException(this.getContext(), exception);
            }
            return joined;
        }

        @CompilerDirectives.TruffleBoundary
        private long clampSecondsToNanos(long timeOutSeconds) {
            if (timeOutSeconds <= 0L) {
                return 0L;
            }
            return TimeUnit.SECONDS.toNanos(timeOutSeconds);
        }
    }

    @Primitive(name="thread_initialize")
    @ImportStatic(value={ArrayGuards.class})
    public static abstract class ThreadInitializeNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object initialize(VirtualFrame frame, RubyThread thread) {
            ArgumentsDescriptor descriptor = RubyArguments.getDescriptor((Frame)frame);
            Object[] args = RubyArguments.getRawArguments((Frame)frame);
            RubyProc block = (RubyProc)RubyArguments.getBlock((Frame)frame);
            return this.init(thread, block, descriptor, args);
        }

        @CompilerDirectives.TruffleBoundary
        private Object init(RubyThread thread, RubyProc block, ArgumentsDescriptor descriptor, Object[] args) {
            SourceSection sourceSection = block.getSharedMethodInfo().getSourceSection();
            String info = this.getContext().fileLine(sourceSection);
            String sharingReason = "creating Ruby Thread " + info;
            if (this.getLanguage().options.SHARED_OBJECTS_ENABLED) {
                this.getContext().getThreadManager().startSharing(thread, sharingReason);
                SharedObjects.shareDeclarationFrame(this.getLanguage(), block, info);
            }
            this.getContext().getThreadManager().initialize(thread, this, info, sharingReason, () -> ProcOperations.rootCall(block, descriptor, args));
            return nil;
        }
    }

    @Primitive(name="thread_initialized?")
    public static abstract class ThreadIsInitializedNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        boolean isInitialized(RubyThread thread) {
            return thread.getRootFiber().initializedLatch.getCount() == 0L;
        }
    }

    @Primitive(name="thread_allocate")
    public static abstract class ThreadAllocateNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        RubyThread allocate(RubyClass rubyClass) {
            if (this.getContext().getOptions().BACKTRACE_ON_NEW_THREAD) {
                this.getContext().getDefaultBacktraceFormatter().printBacktraceOnEnvStderr("thread: ", this);
            }
            Shape shape = this.getLanguage().threadShape;
            RubyThread instance = this.getContext().getThreadManager().createThread(rubyClass, shape, this.getLanguage());
            AllocationTracing.trace(instance, this);
            return instance;
        }
    }

    @CoreMethod(names={"handle_interrupt"}, required=1, needsBlock=true, visibility=Visibility.PRIVATE)
    public static abstract class HandleInterruptNode
    extends CoreMethodArrayArgumentsNode {
        private final BranchProfile errorProfile = BranchProfile.create();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        Object handleInterrupt(RubyThread self, RubySymbol timing, RubyProc block, @Cached InlinedBranchProfile beforeProfile, @Cached InlinedBranchProfile afterProfile, @Cached CallBlockNode yieldNode) {
            InterruptMode newInterruptMode = this.symbolToInterruptMode(this.getLanguage(), timing);
            boolean allowSideEffects = newInterruptMode == InterruptMode.IMMEDIATE;
            TruffleSafepoint safepoint = TruffleSafepoint.getCurrent();
            InterruptMode oldInterruptMode = self.interruptMode;
            self.interruptMode = newInterruptMode;
            boolean prevSideEffects = safepoint.setAllowSideEffects(allowSideEffects);
            try {
                if (newInterruptMode == InterruptMode.IMMEDIATE) {
                    beforeProfile.enter((Node)this);
                    this.runPendingSafepointActions("before");
                }
                Object object = yieldNode.yield(block, new Object[0]);
                return object;
            }
            finally {
                self.interruptMode = oldInterruptMode;
                safepoint.setAllowSideEffects(prevSideEffects);
                if (oldInterruptMode != InterruptMode.NEVER) {
                    afterProfile.enter((Node)this);
                    this.runPendingSafepointActions("after");
                }
            }
        }

        @CompilerDirectives.TruffleBoundary
        private void runPendingSafepointActions(String when) {
            if (this.getContext().getOptions().LOG_PENDING_INTERRUPTS) {
                RubyLanguage.LOGGER.info("Running pending interrupts " + when + " Thread.handle_interrupt");
            }
            TruffleSafepoint.pollHere((Node)this);
        }

        private InterruptMode symbolToInterruptMode(RubyLanguage language, RubySymbol symbol) {
            if (symbol == language.coreSymbols.IMMEDIATE) {
                return InterruptMode.IMMEDIATE;
            }
            if (symbol == language.coreSymbols.ON_BLOCKING) {
                return InterruptMode.ON_BLOCKING;
            }
            if (symbol == language.coreSymbols.NEVER) {
                return InterruptMode.NEVER;
            }
            this.errorProfile.enter();
            throw new RaiseException(this.getContext(), this.coreExceptions().argumentError("invalid timing symbol", this));
        }
    }

    @CoreMethod(names={"pending_interrupt?"})
    public static abstract class PendingInterruptNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean pendingInterrupt(RubyThread self, @Cached InlinedBranchProfile errorProfile) {
            RubyThread currentThread = this.getLanguage().getCurrentThread();
            if (currentThread != self) {
                errorProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().argumentError("Thread#pending_interrupt? does not support being called for another Thread than the current Thread", this));
            }
            return TruffleSafepoint.getCurrent().hasPendingSideEffectingActions();
        }
    }

    @CoreMethod(names={"kill", "exit", "terminate"})
    public static abstract class KillNode
    extends CoreMethodArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyThread kill(RubyThread rubyThread) {
            ThreadManager threadManager = this.getContext().getThreadManager();
            final RubyThread rootThread = threadManager.getRootThread();
            this.getContext().getSafepointManager().pauseRubyThreadAndExecute(this, new SafepointAction("Thread#kill", rubyThread, true, false){

                @Override
                public void run(RubyThread rubyThread, Node currentNode) {
                    if (rubyThread == rootThread) {
                        throw new RaiseException(this.getContext(), (RubyException)this.coreExceptions().systemExit(0, currentNode));
                    }
                    rubyThread.status = ThreadStatus.ABORTING;
                    throw new KillException(currentNode);
                }
            });
            return rubyThread;
        }
    }

    @CoreMethod(names={"group"})
    public static abstract class GroupNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object group(RubyThread thread) {
            return thread.threadGroup;
        }
    }

    @CoreMethod(names={"current"}, onSingleton=true)
    public static abstract class CurrentNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyThread current() {
            return this.getLanguage().getCurrentThread();
        }
    }

    @Primitive(name="thread_backtrace_locations", lowerFixnum={1, 2})
    public static abstract class BacktraceLocationsNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object backtraceLocations(RubyThread rubyThread, int first, NotProvided second) {
            return this.backtraceLocationsInternal(rubyThread, first, -1);
        }

        @Specialization
        Object backtraceLocations(RubyThread rubyThread, int first, int second) {
            return this.backtraceLocationsInternal(rubyThread, first, second);
        }

        @CompilerDirectives.TruffleBoundary
        private Object backtraceLocationsInternal(RubyThread rubyThread, final int omit, final int length) {
            final Memo<Object> backtraceLocationsMemo = new Memo<Object>(null);
            this.getContext().getSafepointManager().pauseRubyThreadAndExecute(this, new SafepointAction("Thread#backtrace_locations", rubyThread, false, true){

                @Override
                public void run(RubyThread rubyThread, Node currentNode) {
                    Backtrace backtrace = this.getContext().getCallStack().getBacktrace(currentNode, omit);
                    Object locations = backtrace.getBacktraceLocations(this.getContext(), this.getLanguage(), length, currentNode);
                    backtraceLocationsMemo.set(locations);
                }
            });
            return backtraceLocationsMemo.get() == null ? nil : backtraceLocationsMemo.get();
        }
    }

    @Primitive(name="all_fibers_backtraces")
    public static abstract class AllFibersBacktracesNode
    extends PrimitiveArrayArgumentsNode {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        RubyArray allFibersBacktraces() {
            final ArrayList backtraces = new ArrayList();
            this.getContext().getSafepointManager().pauseAllThreadsAndExecute(this, new SafepointAction("all Fibers backtraces", SafepointPredicate.ALL_THREADS_AND_FIBERS, false, true){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run(RubyThread rubyThread, Node currentNode) {
                    Backtrace backtrace = this.getContext().getCallStack().getBacktrace(currentNode, 0);
                    backtrace.getStackTrace();
                    RubyFiber fiber = this.getLanguage().getCurrentFiber();
                    List list = backtraces;
                    synchronized (list) {
                        backtraces.add(Pair.create((Object)fiber, (Object)backtrace));
                    }
                }
            });
            Object[] backtracesArray = new Object[backtraces.size()];
            for (int i = 0; i < backtracesArray.length; ++i) {
                Pair pair = (Pair)backtraces.get(i);
                RubyArray backtrace = this.getContext().getUserBacktraceFormatter().formatBacktraceAsRubyStringArray(null, (Backtrace)pair.getRight());
                backtracesArray[i] = this.createArray(new Object[]{pair.getLeft(), backtrace});
            }
            return this.createArray(backtracesArray);
        }
    }

    @Primitive(name="thread_backtrace", lowerFixnum={1, 2})
    public static abstract class BacktraceNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization
        Object backtrace(RubyThread rubyThread, int omit, NotProvided length) {
            return this.backtrace(rubyThread, omit, Integer.MAX_VALUE);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object backtrace(RubyThread rubyThread, final int omit, int length) {
            final Memo<Object> backtraceMemo = new Memo<Object>(null);
            this.getContext().getSafepointManager().pauseRubyThreadAndExecute(this, new SafepointAction("Thread#backtrace", rubyThread, false, true){

                @Override
                public void run(RubyThread rubyThread, Node currentNode) {
                    Backtrace backtrace = this.getContext().getCallStack().getBacktrace(currentNode, omit);
                    backtrace.getStackTrace();
                    backtraceMemo.set(backtrace);
                }
            });
            Backtrace backtrace = backtraceMemo.get();
            if (backtrace == null || omit > backtrace.getTotalUnderlyingElements()) {
                return nil;
            }
            if (length < 0) {
                length = backtrace.getStackTrace().length + 1 + length;
            }
            return this.getContext().getUserBacktraceFormatter().formatBacktraceAsRubyStringArray(null, backtrace, length);
        }
    }

    @CoreMethod(names={"alive?"})
    public static abstract class AliveNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        boolean alive(RubyThread thread) {
            ThreadStatus status = thread.status;
            return status != ThreadStatus.DEAD;
        }
    }

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object allocate(RubyClass rubyClass) {
            throw new RaiseException(this.getContext(), this.coreExceptions().typeErrorAllocatorUndefinedFor(rubyClass, this));
        }
    }
}

