/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.thread;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import org.truffleruby.RubyContext;
import org.truffleruby.core.thread.RubyThread;
import org.truffleruby.extra.ffi.Pointer;

public final class ThreadLocalBuffer {
    private static final long ALIGNMENT = 8L;
    private static final long ALIGNMENT_MASK = 7L;
    public final Pointer start;
    long remaining;
    private final ThreadLocalBuffer parent;

    public ThreadLocalBuffer(Pointer start, ThreadLocalBuffer parent) {
        this.start = start;
        this.remaining = start.getSize();
        this.parent = parent;
    }

    private boolean invariants() {
        assert (this.remaining >= 0L && this.remaining <= this.start.getSize());
        return true;
    }

    private boolean isEmpty() {
        return this.remaining == this.start.getSize();
    }

    private long cursor() {
        return this.start.getEndAddress() - this.remaining;
    }

    private void freeMemory() {
        this.remaining = 0L;
        this.start.freeNoAutorelease();
    }

    public void free(Node node, RubyThread thread, Pointer ptr, InlinedConditionProfile freeProfile) {
        assert (ptr.getEndAddress() == this.cursor()) : "free(" + Long.toHexString(ptr.getEndAddress()) + ") but expected " + Long.toHexString(this.cursor()) + " to be free'd first";
        this.remaining += ptr.getSize();
        assert (this.invariants());
        if (freeProfile.profile(node, this.parent != null && this.isEmpty())) {
            thread.ioBuffer = this.parent;
            this.freeMemory();
        }
    }

    public void freeAll(RubyThread thread) {
        ThreadLocalBuffer current = this;
        thread.ioBuffer = null;
        while (current != null) {
            current.freeMemory();
            current = current.parent;
        }
    }

    public Pointer allocate(Node node, RubyContext context, RubyThread thread, long size, InlinedConditionProfile allocationProfile) {
        long allocationSize = ThreadLocalBuffer.alignUp(size);
        if (allocationProfile.profile(node, this.remaining >= allocationSize)) {
            Pointer pointer = new Pointer(context, this.cursor(), allocationSize);
            this.remaining -= allocationSize;
            assert (this.invariants());
            return pointer;
        }
        ThreadLocalBuffer newBuffer = this.allocateNewBlock(context, thread, allocationSize);
        Pointer pointer = new Pointer(context, newBuffer.start.getAddress(), allocationSize);
        newBuffer.remaining -= allocationSize;
        assert (newBuffer.invariants());
        return pointer;
    }

    private static long alignUp(long size) {
        return size + 7L & 0xFFFFFFFFFFFFFFF8L;
    }

    @CompilerDirectives.TruffleBoundary
    private ThreadLocalBuffer allocateNewBlock(RubyContext context, RubyThread thread, long size) {
        ThreadLocalBuffer newBuffer;
        long blockSize = Math.max(size, 1024L);
        if (this.parent == null && this.isEmpty()) {
            this.freeMemory();
            newBuffer = new ThreadLocalBuffer(Pointer.malloc(context, blockSize), null);
        } else {
            newBuffer = new ThreadLocalBuffer(Pointer.malloc(context, blockSize), this);
        }
        thread.ioBuffer = newBuffer;
        return newBuffer;
    }
}

