/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.support;

import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import org.truffleruby.annotations.CoreMethod;
import org.truffleruby.annotations.CoreModule;
import org.truffleruby.annotations.Primitive;
import org.truffleruby.annotations.Visibility;
import org.truffleruby.builtins.CoreMethodArrayArgumentsNode;
import org.truffleruby.builtins.PrimitiveArrayArgumentsNode;
import org.truffleruby.core.array.ArrayUtils;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.support.RubyByteArray;
import org.truffleruby.extra.ffi.Pointer;
import org.truffleruby.extra.ffi.PointerNodes;
import org.truffleruby.extra.ffi.RubyPointer;
import org.truffleruby.language.control.RaiseException;
import org.truffleruby.language.library.RubyStringLibrary;
import org.truffleruby.language.objects.AllocationTracing;

@CoreModule(value="Truffle::ByteArray", isClass=true)
public abstract class ByteArrayNodes {

    @Primitive(name="bytearray_locate", lowerFixnum={2, 3})
    public static abstract class LocateNode
    extends PrimitiveArrayArgumentsNode {
        @Specialization(guards={"isSingleBytePattern(patternTString, patternEncoding)"})
        Object getByteSingleByte(RubyByteArray byteArray, Object pattern, int start, int length, @Cached TruffleString.ReadByteNode readByteNode, @Cached InlinedBranchProfile tooSmallStartProfile, @Cached InlinedBranchProfile tooLargeStartProfile, @Cached @Cached.Shared RubyStringLibrary libPattern, @Bind(value="libPattern.getTString(pattern)") AbstractTruffleString patternTString, @Bind(value="libPattern.getTEncoding(pattern)") TruffleString.Encoding patternEncoding) {
            int index;
            byte[] bytes = byteArray.bytes;
            int searchByte = readByteNode.execute(patternTString, 0, patternEncoding);
            if (start >= length) {
                tooLargeStartProfile.enter((Node)this);
                return nil;
            }
            if (start < 0) {
                tooSmallStartProfile.enter((Node)this);
                start = 0;
            }
            return (index = com.oracle.truffle.api.ArrayUtils.indexOf((byte[])bytes, (int)start, (int)length, (byte[])new byte[]{(byte)searchByte})) == -1 ? nil : Integer.valueOf(index + 1);
        }

        @Specialization(guards={"!isSingleBytePattern(patternTString, patternEncoding)"})
        Object getByte(RubyByteArray byteArray, Object pattern, int start, int length, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.GetInternalByteArrayNode getInternalByteArrayNode, @Cached InlinedConditionProfile noCopyProfile, @Cached InlinedConditionProfile notFoundProfile, @Cached @Cached.Shared RubyStringLibrary libPattern, @Bind(value="libPattern.getTString(pattern)") AbstractTruffleString patternTString, @Bind(value="libPattern.getTEncoding(pattern)") TruffleString.Encoding patternEncoding) {
            byte[] patternBytes = TStringUtils.getBytesOrCopy(this, patternTString, patternEncoding, getInternalByteArrayNode, noCopyProfile);
            int index = com.oracle.truffle.api.ArrayUtils.indexOfWithOrMask((byte[])byteArray.bytes, (int)start, (int)length, (byte[])patternBytes, null);
            if (notFoundProfile.profile((Node)this, index == -1)) {
                return nil;
            }
            return index + codePointLengthNode.execute(patternTString, patternEncoding);
        }

        protected boolean isSingleBytePattern(AbstractTruffleString string, TruffleString.Encoding encoding) {
            return string.byteLength(encoding) == 1;
        }
    }

    @CoreMethod(names={"fill"}, required=4, lowerFixnum={1, 3, 4})
    public static abstract class FillNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        Object fillFromString(RubyByteArray destByteArray, int dstStart, RubyString source, int srcStart, int length, @Cached RubyStringLibrary libString, @Cached TruffleString.CopyToByteArrayNode copyToByteArrayNode) {
            AbstractTruffleString tstring = source.tstring;
            TruffleString.Encoding encoding = libString.getTEncoding((Object)source);
            copyToByteArrayNode.execute(tstring, srcStart, destByteArray.bytes, dstStart, length, encoding);
            return source;
        }

        @Specialization
        Object fillFromPointer(RubyByteArray byteArray, int dstStart, RubyPointer source, int srcStart, int length, @Cached PointerNodes.CheckNullPointerNode checkNullPointerNode) {
            assert (length > 0);
            Pointer ptr = source.pointer;
            byte[] bytes = byteArray.bytes;
            checkNullPointerNode.execute(this, ptr);
            ptr.readBytes(srcStart, bytes, dstStart, length);
            return source;
        }
    }

    @CoreMethod(names={"[]="}, required=2, lowerFixnum={1, 2})
    public static abstract class SetByteNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int setByte(RubyByteArray byteArray, int index, int value, @Cached InlinedBranchProfile errorProfile) {
            byte[] bytes = byteArray.bytes;
            if (index < 0 || index >= bytes.length) {
                errorProfile.enter((Node)this);
                throw new RaiseException(this.getContext(), this.coreExceptions().indexError("index out of bounds", this));
            }
            bytes[index] = (byte)value;
            return value;
        }
    }

    @CoreMethod(names={"prepend"}, required=1)
    public static abstract class PrependNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization(guards={"strings.isRubyString(string)"}, limit="1")
        RubyByteArray prepend(RubyByteArray byteArray, Object string, @Cached RubyStringLibrary strings, @Cached TruffleString.CopyToByteArrayNode copyToByteArrayNode) {
            byte[] bytes = byteArray.bytes;
            AbstractTruffleString tstring = strings.getTString(string);
            TruffleString.Encoding encoding = strings.getTEncoding(string);
            int prependLength = tstring.byteLength(encoding);
            int originalLength = bytes.length;
            int newLength = prependLength + originalLength;
            byte[] prependedBytes = new byte[newLength];
            copyToByteArrayNode.execute(tstring, 0, prependedBytes, 0, prependLength, encoding);
            System.arraycopy(bytes, 0, prependedBytes, prependLength, originalLength);
            RubyByteArray instance = new RubyByteArray(this.coreLibrary().byteArrayClass, this.getLanguage().byteArrayShape, prependedBytes);
            AllocationTracing.trace(instance, this);
            return instance;
        }
    }

    @CoreMethod(names={"[]"}, required=1, lowerFixnum={1})
    public static abstract class GetByteNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        int getByte(RubyByteArray byteArray, int index) {
            return byteArray.bytes[index] & 0xFF;
        }
    }

    @CoreMethod(names={"initialize"}, required=1, lowerFixnum={1})
    public static abstract class InitializeNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyByteArray initialize(RubyByteArray byteArray, int size) {
            byte[] bytes = new byte[size];
            byteArray.bytes = bytes;
            return byteArray;
        }
    }

    @CoreMethod(names={"__allocate__", "__layout_allocate__"}, constructor=true, visibility=Visibility.PRIVATE)
    public static abstract class AllocateNode
    extends CoreMethodArrayArgumentsNode {
        @Specialization
        RubyByteArray allocate(RubyClass rubyClass) {
            Shape shape = this.getLanguage().byteArrayShape;
            RubyByteArray instance = new RubyByteArray(rubyClass, shape, ArrayUtils.EMPTY_BYTES);
            AllocationTracing.trace(instance, this);
            return instance;
        }
    }
}

