/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.string;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.truffleruby.core.encoding.TStringUtils;

public final class TStringConstants {
    public static final Map<String, TruffleString> TSTRING_CONSTANTS = new HashMap<String, TruffleString>();
    public static final TruffleString EMPTY_BINARY = TruffleString.Encoding.BYTES.getEmpty();
    public static final TruffleString EMPTY_US_ASCII = TruffleString.Encoding.US_ASCII.getEmpty();
    public static final TruffleString EMPTY_UTF8 = TruffleString.Encoding.UTF_8.getEmpty();
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public static final byte[] EMPTY_BYTES = new byte[0];
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public static final byte[] NEWLINE_BYTE_ARRAY = new byte[]{10};
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public static final TruffleString[] UTF8_SINGLE_BYTE = new TruffleString[256];
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public static final TruffleString[] US_ASCII_SINGLE_BYTE = new TruffleString[256];
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public static final TruffleString[] BINARY_SINGLE_BYTE = new TruffleString[256];
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private static final TruffleString[] PADDED_NUMBERS = TStringConstants.createPaddedNumbersTable();
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private static final TruffleString[] PADDING_ZEROS = TStringConstants.createPaddingZeroTable();
    public static final TruffleString __FILE__;
    public static final TruffleString __LINE__;
    public static final TruffleString __ENCODING__;
    public static final TruffleString AMPERSAND;
    public static final TruffleString AMPERSAND_AMPERSAND;
    public static final TruffleString AMPERSAND_DOT;
    public static final TruffleString BACKTICK;
    public static final TruffleString BACKSLASH;
    public static final TruffleString BANG;
    public static final TruffleString BANG_EQ;
    public static final TruffleString BANG_TILDE;
    public static final TruffleString CALL;
    public static final TruffleString CARET;
    public static final TruffleString COLON;
    public static final TruffleString COLON_COLON;
    public static final TruffleString COMMA;
    public static final TruffleString DOT;
    public static final TruffleString DOT_DOT;
    public static final TruffleString DOT_DOT_DOT;
    public static final TruffleString DOLLAR_BANG;
    public static final TruffleString DOLLAR_ZERO;
    public static final TruffleString EQ;
    public static final TruffleString EQ_EQ;
    public static final TruffleString EQ_EQ_EQ;
    public static final TruffleString EQ_GT;
    public static final TruffleString EQ_TILDE;
    public static final TruffleString FALSE;
    public static final TruffleString GT;
    public static final TruffleString GT_EQ;
    public static final TruffleString GT_GT;
    public static final TruffleString LBRACKET;
    public static final TruffleString LBRACKET_RBRACKET;
    public static final TruffleString LBRACKET_RBRACKET_EQ;
    public static final TruffleString LCURLY;
    public static final TruffleString LT;
    public static final TruffleString LT_EQ;
    public static final TruffleString LT_EQ_GT;
    public static final TruffleString LT_LT;
    public static final TruffleString MINUS;
    public static final TruffleString MINUS_AT;
    public static final TruffleString MINUS_GT;
    public static final TruffleString NIL;
    public static final TruffleString OR;
    public static final TruffleString OR_OR;
    public static final TruffleString PERCENT;
    public static final TruffleString PLUS;
    public static final TruffleString PLUS_AT;
    public static final TruffleString Q;
    public static final TruffleString QQ;
    public static final TruffleString QUESTION;
    public static final TruffleString RBRACKET;
    public static final TruffleString RCURLY;
    public static final TruffleString RPAREN;
    public static final TruffleString SELF;
    public static final TruffleString SEMICOLON;
    public static final TruffleString SLASH;
    public static final TruffleString STAR;
    public static final TruffleString STAR_STAR;
    public static final TruffleString TILDE;
    public static final TruffleString TRUE;
    public static final TruffleString ASCII_8BIT;
    public static final TruffleString US_ASCII;
    public static final TruffleString UTF_8;
    public static final TruffleString BIG5;
    public static final TruffleString BIG5_HKSCS;
    public static final TruffleString BIG5_UAO;
    public static final TruffleString CP949;
    public static final TruffleString EMACS_MULE;
    public static final TruffleString EUC_JP;
    public static final TruffleString EUC_KR;
    public static final TruffleString EUC_TW;
    public static final TruffleString GB18030;
    public static final TruffleString GBK;
    public static final TruffleString ISO_8859_1;
    public static final TruffleString ISO_8859_2;
    public static final TruffleString ISO_8859_3;
    public static final TruffleString ISO_8859_4;
    public static final TruffleString ISO_8859_5;
    public static final TruffleString ISO_8859_6;
    public static final TruffleString ISO_8859_7;
    public static final TruffleString ISO_8859_8;
    public static final TruffleString ISO_8859_9;
    public static final TruffleString ISO_8859_10;
    public static final TruffleString ISO_8859_11;
    public static final TruffleString ISO_8859_13;
    public static final TruffleString ISO_8859_14;
    public static final TruffleString ISO_8859_15;
    public static final TruffleString ISO_8859_16;
    public static final TruffleString KOI8_R;
    public static final TruffleString KOI8_U;
    public static final TruffleString SHIFT_JIS;
    public static final TruffleString UTF_16BE;
    public static final TruffleString UTF_16LE;
    public static final TruffleString UTF_32BE;
    public static final TruffleString UTF_32LE;
    public static final TruffleString WINDOWS_31J;
    public static final TruffleString WINDOWS_1250;
    public static final TruffleString WINDOWS_1251;
    public static final TruffleString WINDOWS_1252;
    public static final TruffleString WINDOWS_1253;
    public static final TruffleString WINDOWS_1254;
    public static final TruffleString WINDOWS_1257;
    public static final TruffleString IBM437;
    public static final TruffleString IBM737;
    public static final TruffleString IBM775;
    public static final TruffleString CP850;
    public static final TruffleString IBM852;
    public static final TruffleString CP852;
    public static final TruffleString IBM855;
    public static final TruffleString CP855;
    public static final TruffleString IBM857;
    public static final TruffleString IBM860;
    public static final TruffleString IBM861;
    public static final TruffleString IBM862;
    public static final TruffleString IBM863;
    public static final TruffleString IBM864;
    public static final TruffleString IBM865;
    public static final TruffleString IBM866;
    public static final TruffleString IBM869;
    public static final TruffleString WINDOWS_1258;
    public static final TruffleString GB1988;
    public static final TruffleString MACCENTEURO;
    public static final TruffleString MACCROATIAN;
    public static final TruffleString MACCYRILLIC;
    public static final TruffleString MACGREEK;
    public static final TruffleString MACICELAND;
    public static final TruffleString MACROMAN;
    public static final TruffleString MACROMANIA;
    public static final TruffleString MACTHAI;
    public static final TruffleString MACTURKISH;
    public static final TruffleString MACUKRAINE;
    public static final TruffleString CP950;
    public static final TruffleString CP951;
    public static final TruffleString IBM037;
    public static final TruffleString STATELESS_ISO_2022_JP;
    public static final TruffleString EUCJP_MS;
    public static final TruffleString CP51932;
    public static final TruffleString EUC_JIS_2004;
    public static final TruffleString GB2312;
    public static final TruffleString GB12345;
    public static final TruffleString ISO_2022_JP;
    public static final TruffleString ISO_2022_JP_2;
    public static final TruffleString CP50220;
    public static final TruffleString CP50221;
    public static final TruffleString WINDOWS_1256;
    public static final TruffleString WINDOWS_1255;
    public static final TruffleString TIS_620;
    public static final TruffleString WINDOWS_874;
    public static final TruffleString MACJAPANESE;
    public static final TruffleString UTF_7;
    public static final TruffleString UTF8_MAC;
    public static final TruffleString UTF_16;
    public static final TruffleString UTF_32;
    public static final TruffleString UTF8_DOCOMO;
    public static final TruffleString SJIS_DOCOMO;
    public static final TruffleString UTF8_KDDI;
    public static final TruffleString SJIS_KDDI;
    public static final TruffleString ISO_2022_JP_KDDI;
    public static final TruffleString STATELESS_ISO_2022_JP_KDDI;
    public static final TruffleString UTF8_SOFTBANK;
    public static final TruffleString SJIS_SOFTBANK;
    public static final TruffleString IBM720;
    public static final TruffleString CESU_8;

    private static TruffleString ascii(String string) {
        if (string.length() == 1) {
            return US_ASCII_SINGLE_BYTE[string.charAt(0)];
        }
        TruffleString tstring = TStringUtils.fromJavaString(string, TruffleString.Encoding.US_ASCII);
        TruffleString before = TSTRING_CONSTANTS.putIfAbsent(string, tstring);
        if (before != null) {
            throw new AssertionError((Object)("Duplicate TruffleString in TStringConstants: " + before));
        }
        return tstring;
    }

    public static TruffleString lookupUSASCIITString(String string) {
        if (string.isEmpty()) {
            return EMPTY_US_ASCII;
        }
        if (string.length() == 1) {
            return US_ASCII_SINGLE_BYTE[string.charAt(0)];
        }
        return TSTRING_CONSTANTS.get(string);
    }

    private static TruffleString[] createPaddedNumbersTable() {
        TruffleString[] table = new TruffleString[100];
        for (int n = 0; n < table.length; ++n) {
            table[n] = TruffleString.fromByteArrayUncached((byte[])new byte[]{(byte)(48 + n / 10), (byte)(48 + n % 10)}, (TruffleString.Encoding)TruffleString.Encoding.UTF_8, (boolean)false);
        }
        return table;
    }

    public static TruffleString paddedNumber(int n) {
        return PADDED_NUMBERS[n];
    }

    private static TruffleString[] createPaddingZeroTable() {
        TruffleString[] table = new TruffleString[6];
        for (int n = 0; n < table.length; ++n) {
            byte[] bytes = new byte[n];
            Arrays.fill(bytes, (byte)48);
            table[n] = TruffleString.fromByteArrayUncached((byte[])bytes, (TruffleString.Encoding)TruffleString.Encoding.UTF_8, (boolean)false);
        }
        return table;
    }

    public static TruffleString paddingZeros(int n) {
        return PADDING_ZEROS[n];
    }

    private static <T> T withHashCode(T object) {
        object.hashCode();
        return object;
    }

    static {
        for (int i = 0; i < 256; ++i) {
            byte[] bytes = new byte[]{(byte)i};
            TStringConstants.UTF8_SINGLE_BYTE[i] = TStringConstants.withHashCode(TStringUtils.fromByteArray(bytes, TruffleString.Encoding.UTF_8));
            TStringConstants.US_ASCII_SINGLE_BYTE[i] = TStringConstants.withHashCode(TStringUtils.fromByteArray(bytes, TruffleString.Encoding.US_ASCII));
            TStringConstants.BINARY_SINGLE_BYTE[i] = TStringConstants.withHashCode(TStringUtils.fromByteArray(bytes, TruffleString.Encoding.BYTES));
        }
        __FILE__ = TStringConstants.ascii("__FILE__");
        __LINE__ = TStringConstants.ascii("__LINE__");
        __ENCODING__ = TStringConstants.ascii("__ENCODING__");
        AMPERSAND = TStringConstants.ascii("&");
        AMPERSAND_AMPERSAND = TStringConstants.ascii("&&");
        AMPERSAND_DOT = TStringConstants.ascii("&.");
        BACKTICK = TStringConstants.ascii("`");
        BACKSLASH = TStringConstants.ascii("\\");
        BANG = TStringConstants.ascii("!");
        BANG_EQ = TStringConstants.ascii("!=");
        BANG_TILDE = TStringConstants.ascii("!~");
        CALL = TStringConstants.ascii("call");
        CARET = TStringConstants.ascii("^");
        COLON = TStringConstants.ascii(":");
        COLON_COLON = TStringConstants.ascii("::");
        COMMA = TStringConstants.ascii(",");
        DOT = TStringConstants.ascii(".");
        DOT_DOT = TStringConstants.ascii("..");
        DOT_DOT_DOT = TStringConstants.ascii("...");
        DOLLAR_BANG = TStringConstants.ascii("$!");
        DOLLAR_ZERO = TStringConstants.ascii("$0");
        EQ = TStringConstants.ascii("=");
        EQ_EQ = TStringConstants.ascii("==");
        EQ_EQ_EQ = TStringConstants.ascii("===");
        EQ_GT = TStringConstants.ascii("=>");
        EQ_TILDE = TStringConstants.ascii("=~");
        FALSE = TStringConstants.ascii("false");
        GT = TStringConstants.ascii(">");
        GT_EQ = TStringConstants.ascii(">=");
        GT_GT = TStringConstants.ascii(">>");
        LBRACKET = TStringConstants.ascii("[");
        LBRACKET_RBRACKET = TStringConstants.ascii("[]");
        LBRACKET_RBRACKET_EQ = TStringConstants.ascii("[]=");
        LCURLY = TStringConstants.ascii("{");
        LT = TStringConstants.ascii("<");
        LT_EQ = TStringConstants.ascii("<=");
        LT_EQ_GT = TStringConstants.ascii("<=>");
        LT_LT = TStringConstants.ascii("<<");
        MINUS = TStringConstants.ascii("-");
        MINUS_AT = TStringConstants.ascii("-@");
        MINUS_GT = TStringConstants.ascii("->");
        NIL = TStringConstants.ascii("nil");
        OR = TStringConstants.ascii("|");
        OR_OR = TStringConstants.ascii("||");
        PERCENT = TStringConstants.ascii("%");
        PLUS = TStringConstants.ascii("+");
        PLUS_AT = TStringConstants.ascii("+@");
        Q = TStringConstants.ascii("'");
        QQ = TStringConstants.ascii("\"");
        QUESTION = TStringConstants.ascii("?");
        RBRACKET = TStringConstants.ascii("]");
        RCURLY = TStringConstants.ascii("}");
        RPAREN = TStringConstants.ascii(")");
        SELF = TStringConstants.ascii("self");
        SEMICOLON = TStringConstants.ascii(";");
        SLASH = TStringConstants.ascii("/");
        STAR = TStringConstants.ascii("*");
        STAR_STAR = TStringConstants.ascii("**");
        TILDE = TStringConstants.ascii("~");
        TRUE = TStringConstants.ascii("true");
        ASCII_8BIT = TStringConstants.ascii("ASCII-8BIT");
        US_ASCII = TStringConstants.ascii("US-ASCII");
        UTF_8 = TStringConstants.ascii("UTF-8");
        BIG5 = TStringConstants.ascii("Big5");
        BIG5_HKSCS = TStringConstants.ascii("Big5-HKSCS");
        BIG5_UAO = TStringConstants.ascii("Big5-UAO");
        CP949 = TStringConstants.ascii("CP949");
        EMACS_MULE = TStringConstants.ascii("Emacs-Mule");
        EUC_JP = TStringConstants.ascii("EUC-JP");
        EUC_KR = TStringConstants.ascii("EUC-KR");
        EUC_TW = TStringConstants.ascii("EUC-TW");
        GB18030 = TStringConstants.ascii("GB18030");
        GBK = TStringConstants.ascii("GBK");
        ISO_8859_1 = TStringConstants.ascii("ISO-8859-1");
        ISO_8859_2 = TStringConstants.ascii("ISO-8859-2");
        ISO_8859_3 = TStringConstants.ascii("ISO-8859-3");
        ISO_8859_4 = TStringConstants.ascii("ISO-8859-4");
        ISO_8859_5 = TStringConstants.ascii("ISO-8859-5");
        ISO_8859_6 = TStringConstants.ascii("ISO-8859-6");
        ISO_8859_7 = TStringConstants.ascii("ISO-8859-7");
        ISO_8859_8 = TStringConstants.ascii("ISO-8859-8");
        ISO_8859_9 = TStringConstants.ascii("ISO-8859-9");
        ISO_8859_10 = TStringConstants.ascii("ISO-8859-10");
        ISO_8859_11 = TStringConstants.ascii("ISO-8859-11");
        ISO_8859_13 = TStringConstants.ascii("ISO-8859-13");
        ISO_8859_14 = TStringConstants.ascii("ISO-8859-14");
        ISO_8859_15 = TStringConstants.ascii("ISO-8859-15");
        ISO_8859_16 = TStringConstants.ascii("ISO-8859-16");
        KOI8_R = TStringConstants.ascii("KOI8-R");
        KOI8_U = TStringConstants.ascii("KOI8-U");
        SHIFT_JIS = TStringConstants.ascii("Shift_JIS");
        UTF_16BE = TStringConstants.ascii("UTF-16BE");
        UTF_16LE = TStringConstants.ascii("UTF-16LE");
        UTF_32BE = TStringConstants.ascii("UTF-32BE");
        UTF_32LE = TStringConstants.ascii("UTF-32LE");
        WINDOWS_31J = TStringConstants.ascii("Windows-31J");
        WINDOWS_1250 = TStringConstants.ascii("Windows-1250");
        WINDOWS_1251 = TStringConstants.ascii("Windows-1251");
        WINDOWS_1252 = TStringConstants.ascii("Windows-1252");
        WINDOWS_1253 = TStringConstants.ascii("Windows-1253");
        WINDOWS_1254 = TStringConstants.ascii("Windows-1254");
        WINDOWS_1257 = TStringConstants.ascii("Windows-1257");
        IBM437 = TStringConstants.ascii("IBM437");
        IBM737 = TStringConstants.ascii("IBM737");
        IBM775 = TStringConstants.ascii("IBM775");
        CP850 = TStringConstants.ascii("CP850");
        IBM852 = TStringConstants.ascii("IBM852");
        CP852 = TStringConstants.ascii("CP852");
        IBM855 = TStringConstants.ascii("IBM855");
        CP855 = TStringConstants.ascii("CP855");
        IBM857 = TStringConstants.ascii("IBM857");
        IBM860 = TStringConstants.ascii("IBM860");
        IBM861 = TStringConstants.ascii("IBM861");
        IBM862 = TStringConstants.ascii("IBM862");
        IBM863 = TStringConstants.ascii("IBM863");
        IBM864 = TStringConstants.ascii("IBM864");
        IBM865 = TStringConstants.ascii("IBM865");
        IBM866 = TStringConstants.ascii("IBM866");
        IBM869 = TStringConstants.ascii("IBM869");
        WINDOWS_1258 = TStringConstants.ascii("Windows-1258");
        GB1988 = TStringConstants.ascii("GB1988");
        MACCENTEURO = TStringConstants.ascii("macCentEuro");
        MACCROATIAN = TStringConstants.ascii("macCroatian");
        MACCYRILLIC = TStringConstants.ascii("macCyrillic");
        MACGREEK = TStringConstants.ascii("macGreek");
        MACICELAND = TStringConstants.ascii("macIceland");
        MACROMAN = TStringConstants.ascii("macRoman");
        MACROMANIA = TStringConstants.ascii("macRomania");
        MACTHAI = TStringConstants.ascii("macThai");
        MACTURKISH = TStringConstants.ascii("macTurkish");
        MACUKRAINE = TStringConstants.ascii("macUkraine");
        CP950 = TStringConstants.ascii("CP950");
        CP951 = TStringConstants.ascii("CP951");
        IBM037 = TStringConstants.ascii("IBM037");
        STATELESS_ISO_2022_JP = TStringConstants.ascii("stateless-ISO-2022-JP");
        EUCJP_MS = TStringConstants.ascii("eucJP-ms");
        CP51932 = TStringConstants.ascii("CP51932");
        EUC_JIS_2004 = TStringConstants.ascii("EUC-JIS-2004");
        GB2312 = TStringConstants.ascii("GB2312");
        GB12345 = TStringConstants.ascii("GB12345");
        ISO_2022_JP = TStringConstants.ascii("ISO-2022-JP");
        ISO_2022_JP_2 = TStringConstants.ascii("ISO-2022-JP-2");
        CP50220 = TStringConstants.ascii("CP50220");
        CP50221 = TStringConstants.ascii("CP50221");
        WINDOWS_1256 = TStringConstants.ascii("Windows-1256");
        WINDOWS_1255 = TStringConstants.ascii("Windows-1255");
        TIS_620 = TStringConstants.ascii("TIS-620");
        WINDOWS_874 = TStringConstants.ascii("Windows-874");
        MACJAPANESE = TStringConstants.ascii("MacJapanese");
        UTF_7 = TStringConstants.ascii("UTF-7");
        UTF8_MAC = TStringConstants.ascii("UTF8-MAC");
        UTF_16 = TStringConstants.ascii("UTF-16");
        UTF_32 = TStringConstants.ascii("UTF-32");
        UTF8_DOCOMO = TStringConstants.ascii("UTF8-DoCoMo");
        SJIS_DOCOMO = TStringConstants.ascii("SJIS-DoCoMo");
        UTF8_KDDI = TStringConstants.ascii("UTF8-KDDI");
        SJIS_KDDI = TStringConstants.ascii("SJIS-KDDI");
        ISO_2022_JP_KDDI = TStringConstants.ascii("ISO-2022-JP-KDDI");
        STATELESS_ISO_2022_JP_KDDI = TStringConstants.ascii("stateless-ISO-2022-JP-KDDI");
        UTF8_SOFTBANK = TStringConstants.ascii("UTF8-SoftBank");
        SJIS_SOFTBANK = TStringConstants.ascii("SJIS-SoftBank");
        IBM720 = TStringConstants.ascii("IBM720");
        CESU_8 = TStringConstants.ascii("CESU-8");
    }
}

