/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.string;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.string.RubyString;
import org.truffleruby.core.string.StringUtils;

public abstract class StringOperations {
    public static RubyString createUTF8String(RubyContext context, RubyLanguage language, String string) {
        RubyString instance = new RubyString(context.getCoreLibrary().stringClass, language.stringShape, false, (AbstractTruffleString)TStringUtils.utf8TString(string), Encodings.UTF_8);
        return instance;
    }

    public static RubyString createUTF8String(RubyContext context, RubyLanguage language, AbstractTruffleString string) {
        RubyString instance = new RubyString(context.getCoreLibrary().stringClass, language.stringShape, false, string, Encodings.UTF_8);
        return instance;
    }

    @CompilerDirectives.TruffleBoundary
    public static byte[] encodeBytes(String value, Encoding encoding) {
        if (encoding == ASCIIEncoding.INSTANCE && !StringOperations.isAsciiOnly(value)) {
            throw new UnsupportedOperationException(StringUtils.format("Can't convert Java String (%s) to Ruby BINARY String because it contains non-ASCII characters", value));
        }
        Charset charset = encoding.getCharset();
        if (charset == null) {
            throw new UnsupportedOperationException("Cannot find Charset to encode " + value + " with " + encoding);
        }
        ByteBuffer buffer = charset.encode(CharBuffer.wrap(value));
        byte[] bytes = new byte[buffer.limit()];
        buffer.get(bytes);
        return bytes;
    }

    public static boolean isAsciiOnly(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Encoding.isAscii((int)c)) continue;
            return false;
        }
        return true;
    }

    public static byte[] encodeAsciiBytes(String value) {
        assert (StringOperations.isAsciiOnly(value)) : "String contained non ascii characters \"" + value + "\"";
        byte[] bytes = new byte[value.length()];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)value.charAt(i);
        }
        return bytes;
    }
}

