/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.string;

import com.oracle.truffle.api.strings.TruffleString;
import java.util.ArrayList;
import java.util.List;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.string.FrozenStringLiterals;
import org.truffleruby.core.string.ImmutableRubyString;
import org.truffleruby.core.string.TStringConstants;

public final class FrozenStrings {
    static final List<TruffleString> TSTRINGS = new ArrayList<TruffleString>();
    public static final ImmutableRubyString EMPTY_US_ASCII = FrozenStringLiterals.createStringAndCacheLater(TStringConstants.EMPTY_US_ASCII, Encodings.US_ASCII);
    public static final ImmutableRubyString YIELD = FrozenStrings.createFrozenStaticBinaryString("yield");
    public static final ImmutableRubyString ASSIGNMENT = FrozenStrings.createFrozenStaticBinaryString("assignment");
    public static final ImmutableRubyString CLASS_VARIABLE = FrozenStrings.createFrozenStaticBinaryString("class variable");
    public static final ImmutableRubyString CONSTANT = FrozenStrings.createFrozenStaticBinaryString("constant");
    public static final ImmutableRubyString EXPRESSION = FrozenStrings.createFrozenStaticBinaryString("expression");
    public static final ImmutableRubyString FALSE = FrozenStrings.createFrozenStaticBinaryString("false");
    public static final ImmutableRubyString GLOBAL_VARIABLE = FrozenStrings.createFrozenStaticBinaryString("global-variable");
    public static final ImmutableRubyString INSTANCE_VARIABLE = FrozenStrings.createFrozenStaticBinaryString("instance-variable");
    public static final ImmutableRubyString LOCAL_VARIABLE = FrozenStrings.createFrozenStaticBinaryString("local-variable");
    public static final ImmutableRubyString METHOD = FrozenStrings.createFrozenStaticBinaryString("method");
    public static final ImmutableRubyString NIL = FrozenStrings.createFrozenStaticBinaryString("nil");
    public static final ImmutableRubyString SELF = FrozenStrings.createFrozenStaticBinaryString("self");
    public static final ImmutableRubyString SUPER = FrozenStrings.createFrozenStaticBinaryString("super");
    public static final ImmutableRubyString TRUE = FrozenStrings.createFrozenStaticBinaryString("true");
    public static final ImmutableRubyString TZ = FrozenStrings.createFrozenStaticBinaryString("TZ");

    private static ImmutableRubyString createFrozenStaticBinaryString(String string) {
        return FrozenStrings.createFrozenStaticString(string, Encodings.BINARY);
    }

    private static ImmutableRubyString createFrozenStaticString(String string, RubyEncoding encoding) {
        TruffleString tstring = TStringUtils.fromJavaString(string, encoding);
        TSTRINGS.add(tstring);
        return FrozenStringLiterals.createStringAndCacheLater(tstring, encoding);
    }
}

