/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.string;

import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.InternalByteArray;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.parser.SafeDoubleParser;

public final class DoubleConverter {
    private byte[] bytes;
    private int index;
    private int endIndex;
    private boolean isStrict;
    private char[] chars;
    private int charsIndex;
    private int significantDigitsProcessed;
    private int adjustExponent;
    private boolean wroteExponent;
    private double result;
    private static final int SIGNIFICANT_DIGITS_LIMIT = 30;
    private static final int EXPONENT_DIGITS_LIMIT = 3;
    private static final int MAX_EXPONENT = (int)Math.pow(10.0, 3.0) - 1;
    private static final int MAX_LENGTH = 39;

    public void init(AbstractTruffleString tstring, RubyEncoding encoding, boolean isStrict) {
        InternalByteArray byteArray = tstring.getInternalByteArrayUncached(encoding.tencoding);
        this.bytes = byteArray.getArray();
        this.index = byteArray.getOffset();
        this.endIndex = byteArray.getEnd();
        this.isStrict = isStrict;
        this.chars = new char[Math.min(byteArray.getLength() + 2, 39)];
        this.charsIndex = 0;
        this.significantDigitsProcessed = 0;
        this.adjustExponent = 0;
        this.wroteExponent = false;
        this.result = -1.0;
    }

    private byte next() {
        return this.bytes[this.index++];
    }

    private boolean previous() {
        --this.index;
        return false;
    }

    private boolean isEOS() {
        return this.index >= this.endIndex;
    }

    private boolean stopParsing() {
        this.index = this.endIndex;
        return true;
    }

    private boolean isDigit(byte b) {
        return b >= 48 && b <= 57;
    }

    private boolean isExponent(byte b) {
        return b == 101 || b == 69;
    }

    private boolean isWhitespace(byte b) {
        return b == 32 || b <= 13 && b >= 9 && b != 11;
    }

    private void addToResult(byte b) {
        this.chars[this.charsIndex++] = (char)b;
    }

    private void addExponentToResult(int exponent) {
        String exp = Integer.toString(exponent);
        for (int i = 0; i < exp.length(); ++i) {
            this.addToResult((byte)exp.charAt(i));
        }
    }

    private boolean eatUnderscores() {
        while (!this.isEOS()) {
            byte value = this.next();
            if (value != 95) {
                this.previous();
                return this.isEOS();
            }
            if (!this.isStrict) continue;
            this.strictError();
        }
        return true;
    }

    private double completeCalculation() {
        if (this.charsIndex == 0 || this.charsIndex == 1 && this.chars[0] == '-') {
            this.strictError();
            return 0.0;
        }
        if (this.isExponent((byte)this.chars[this.charsIndex - 1])) {
            this.strictError();
            this.addExponentToResult(this.adjustExponent);
        } else if (this.isStrict && !this.isEOS()) {
            this.strictError();
        } else if (!this.wroteExponent && this.adjustExponent != 0) {
            this.addToResult((byte)69);
            this.addExponentToResult(this.adjustExponent);
        }
        return SafeDoubleParser.parseDouble(new String(this.chars, 0, this.charsIndex));
    }

    private boolean strictError() {
        if (this.isStrict) {
            throw new LightweightNumberFormatException("does not meet strict criteria");
        }
        return true;
    }

    public double parse(AbstractTruffleString tstring, RubyEncoding encoding, boolean strict, boolean is19) {
        this.init(tstring, encoding, strict);
        if (this.skipWhitespace()) {
            return this.completeCalculation();
        }
        if (this.parseOptionalSign()) {
            return this.completeCalculation();
        }
        this.parseDigits();
        if (this.result != -1.0) {
            return this.result;
        }
        return this.completeCalculation();
    }

    private boolean skipWhitespace() {
        while (!this.isEOS()) {
            byte value = this.next();
            if (this.isWhitespace(value)) continue;
            return this.previous();
        }
        return true;
    }

    private boolean parseOptionalSign() {
        byte sign = this.next();
        if (sign == 45) {
            this.addToResult(sign);
        } else if (sign != 43) {
            this.previous();
        }
        return this.isEOS();
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean parseDigits() {
        byte value;
        block12: {
            if (!this.isEOS()) {
                value = this.next();
                if (this.isDigit(value)) {
                    if (value != 48) {
                        ++this.significantDigitsProcessed;
                    }
                    this.addToResult(value);
                    break block12;
                } else {
                    if (value == 46) {
                        this.addToResult(value);
                        return this.parseDecimalDigits();
                    }
                    return this.isEOS();
                }
            }
            this.strictError();
        }
        while (true) {
            if (this.isEOS()) {
                return true;
            }
            value = this.next();
            if (this.isDigit(value)) {
                if (this.significantDigitsProcessed < 30) {
                    if (value == 48 && this.significantDigitsProcessed <= 0) continue;
                    ++this.significantDigitsProcessed;
                    this.addToResult(value);
                    continue;
                }
                ++this.adjustExponent;
                continue;
            }
            if (value == 46) {
                this.addToResult(value);
                return this.parseDecimalDigits();
            }
            if (value != 95) break;
            this.verifyNumberAfterUnderscore();
        }
        if (this.isExponent(value)) {
            this.addToResult(value);
            return this.parseExponent();
        }
        if (this.isWhitespace(value)) {
            return this.skipWhitespace();
        }
        return this.strictError();
    }

    private boolean parseDecimalDigits() {
        if (this.isEOS()) {
            return this.strictError();
        }
        byte value = this.next();
        if (value == 95) {
            this.strictError();
            if (this.isEOS()) {
                return this.strictError();
            }
            value = this.next();
        }
        if (this.isDigit(value)) {
            if (this.significantDigitsProcessed < 30) {
                if (value != 48 || this.significantDigitsProcessed != 0) {
                    ++this.significantDigitsProcessed;
                }
            } else {
                value = 48;
            }
            this.addToResult(value);
        } else {
            return this.strictError();
        }
        while (!this.isEOS()) {
            value = this.next();
            if (this.isDigit(value)) {
                if (this.significantDigitsProcessed >= 30) continue;
                if (value == 48 && this.significantDigitsProcessed == 0) {
                    --this.adjustExponent;
                    continue;
                }
                ++this.significantDigitsProcessed;
                this.addToResult(value);
                continue;
            }
            if (this.isExponent(value)) {
                this.addToResult(value);
                return this.parseExponent();
            }
            if (value == 95) {
                this.verifyNumberAfterUnderscore();
                continue;
            }
            if (this.isWhitespace(value)) {
                return this.skipWhitespace();
            }
            return this.strictError();
        }
        return true;
    }

    private boolean parseExponent() {
        if (this.eatUnderscores()) {
            return this.isEOS();
        }
        byte value = this.next();
        int exponent = 0;
        int digits = 0;
        boolean negative = false;
        if (value == 45) {
            negative = true;
        } else if (value != 43) {
            this.previous();
        }
        while (!this.isEOS()) {
            value = this.next();
            if (this.isDigit(value)) {
                if (digits < 3) {
                    if (value == 48 && digits <= 0) continue;
                    ++digits;
                    exponent = 10 * exponent + (value - 48);
                    continue;
                }
                return this.tooLargeExponent(this.chars[0] == '-', negative);
            }
            if (this.isWhitespace(value)) {
                this.skipWhitespace();
                break;
            }
            if (value == 95) {
                this.verifyNumberAfterUnderscore();
                continue;
            }
            this.strictError();
            this.stopParsing();
            break;
        }
        if (negative) {
            exponent = -exponent;
        }
        if (-MAX_EXPONENT <= (exponent += this.adjustExponent) && exponent <= MAX_EXPONENT) {
            this.addExponentToResult(exponent);
            this.wroteExponent = true;
            return this.isEOS();
        }
        return this.tooLargeExponent(this.chars[0] == '-', negative);
    }

    private boolean tooLargeExponent(boolean negativeFloat, boolean negativeExponent) {
        this.result = negativeExponent ? (negativeFloat ? -0.0 : 0.0) : (negativeFloat ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
        return this.stopParsing();
    }

    private void verifyNumberAfterUnderscore() {
        if (this.isStrict && (this.isEOS() || !this.isDigit(this.bytes[this.index]))) {
            this.strictError();
        }
    }

    static final class LightweightNumberFormatException
    extends NumberFormatException {
        public LightweightNumberFormatException(String message) {
            super(message);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

