/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.regexp;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.charset.UnsupportedCharsetException;
import org.truffleruby.RubyContext;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.encoding.TStringUtils;
import org.truffleruby.core.regexp.ClassicRegexp;
import org.truffleruby.core.regexp.RegexpOptions;
import org.truffleruby.core.regexp.RegexpSupport;
import org.truffleruby.core.regexp.RubyRegexp;
import org.truffleruby.core.regexp.TruffleRegexpNodes;
import org.truffleruby.core.string.CannotConvertBinaryRubyStringToJavaString;
import org.truffleruby.core.string.TStringBuilder;
import org.truffleruby.core.string.TStringWithEncoding;
import org.truffleruby.interop.InteropNodes;
import org.truffleruby.interop.TranslateInteropExceptionNodeGen;
import org.truffleruby.language.Nil;
import org.truffleruby.language.control.DeferredRaiseException;

public final class TRegexCache {
    private Object usAsciiRegex;
    private Object latin1Regex;
    private Object utf8Regex;
    private Object binaryRegex;
    private Object usAsciiRegexAtStart;
    private Object latin1RegexAtStart;
    private Object utf8RegexAtStart;
    private Object binaryRegexAtStart;

    public Object getUSASCIIRegex(boolean atStart) {
        return atStart ? this.usAsciiRegex : this.usAsciiRegexAtStart;
    }

    public Object getLatin1Regex(boolean atStart) {
        return atStart ? this.latin1Regex : this.latin1RegexAtStart;
    }

    public Object getUTF8Regex(boolean atStart) {
        return atStart ? this.utf8Regex : this.utf8RegexAtStart;
    }

    public Object getBinaryRegex(boolean atStart) {
        return atStart ? this.binaryRegex : this.binaryRegexAtStart;
    }

    @CompilerDirectives.TruffleBoundary
    public Object compile(RubyContext context, RubyRegexp regexp, boolean atStart, RubyEncoding encoding, TruffleRegexpNodes.TRegexCompileNode node) {
        Object tregex = TRegexCache.compileTRegex(context, regexp, atStart, encoding);
        if (tregex == null) {
            tregex = Nil.INSTANCE;
            if (context.getOptions().WARN_TRUFFLE_REGEX_COMPILE_FALLBACK) {
                node.getWarnOnFallbackNode().call(context.getCoreLibrary().truffleRegexpOperationsModule, "warn_fallback_regex", regexp, (Object)atStart, (Object)encoding);
            }
        } else if (TRegexCache.isBacktracking(tregex) && context.getOptions().WARN_TRUFFLE_REGEX_COMPILE_FALLBACK) {
            node.getWarnOnFallbackNode().call(context.getCoreLibrary().truffleRegexpOperationsModule, "warn_backtracking", regexp, (Object)atStart, (Object)encoding);
        }
        if (encoding == Encodings.US_ASCII) {
            if (atStart) {
                this.usAsciiRegex = tregex;
            } else {
                this.usAsciiRegexAtStart = tregex;
            }
        } else if (encoding == Encodings.ISO_8859_1) {
            if (atStart) {
                this.latin1Regex = tregex;
            } else {
                this.latin1RegexAtStart = tregex;
            }
        } else if (encoding == Encodings.UTF_8) {
            if (atStart) {
                this.utf8Regex = tregex;
            } else {
                this.utf8RegexAtStart = tregex;
            }
        } else if (encoding == Encodings.BINARY) {
            if (atStart) {
                this.binaryRegex = tregex;
            } else {
                this.binaryRegexAtStart = tregex;
            }
        } else {
            throw CompilerDirectives.shouldNotReachHere();
        }
        return tregex;
    }

    private static boolean isBacktracking(Object tregex) {
        return (Boolean)InteropNodes.readMember(null, InteropLibrary.getUncached(), tregex, "isBacktracking", TranslateInteropExceptionNodeGen.getUncached());
    }

    public static String toTRegexEncoding(RubyEncoding encoding) {
        if (encoding == Encodings.UTF_8) {
            return "UTF-8";
        }
        if (encoding == Encodings.US_ASCII) {
            return "ASCII";
        }
        if (encoding == Encodings.ISO_8859_1) {
            return "LATIN-1";
        }
        if (encoding == Encodings.BINARY) {
            return "BYTES";
        }
        return null;
    }

    @CompilerDirectives.TruffleBoundary
    private static Object compileTRegex(RubyContext context, RubyRegexp regexp, boolean atStart, RubyEncoding enc) {
        String processedRegexpSource;
        TStringBuilder tstringBuilder;
        RubyEncoding[] fixedEnc = new RubyEncoding[]{null};
        try {
            tstringBuilder = ClassicRegexp.preprocess(new TStringWithEncoding(regexp.source, regexp.encoding), enc, fixedEnc, RegexpSupport.ErrorMode.RAISE);
        }
        catch (DeferredRaiseException dre) {
            throw dre.getException(context);
        }
        TruffleString tstring = tstringBuilder.toTString();
        try {
            processedRegexpSource = TStringUtils.toJavaStringOrThrow((AbstractTruffleString)tstring, tstringBuilder.getRubyEncoding());
        }
        catch (UnsupportedCharsetException | CannotConvertBinaryRubyStringToJavaString e) {
            return null;
        }
        String flags = TRegexCache.optionsToFlags(regexp.options, atStart);
        String tRegexEncoding = TRegexCache.toTRegexEncoding(enc);
        if (tRegexEncoding == null) {
            return null;
        }
        String ignoreAtomicGroups = context.getOptions().TRUFFLE_REGEX_IGNORE_ATOMIC_GROUPS ? ",IgnoreAtomicGroups=true" : "";
        String regex = "Flavor=Ruby,Encoding=" + tRegexEncoding + ignoreAtomicGroups + "/" + processedRegexpSource + "/" + flags;
        Source regexSource = Source.newBuilder((String)"regex", (CharSequence)regex, (String)"Regexp").mimeType("application/tregex").internal(true).build();
        Object compiledRegex = context.getEnv().parseInternal(regexSource, new String[0]).call(new Object[0]);
        if (InteropLibrary.getUncached().isNull(compiledRegex)) {
            return null;
        }
        return compiledRegex;
    }

    public static String optionsToFlags(RegexpOptions options, boolean atStart) {
        StringBuilder flags = new StringBuilder(4);
        if (options.isMultiline()) {
            flags.append('m');
        }
        if (options.isIgnorecase()) {
            flags.append('i');
        }
        if (options.isExtended()) {
            flags.append('x');
        }
        if (atStart) {
            flags.append('y');
        }
        return flags.toString();
    }
}

