/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.regexp;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import org.joni.Regex;
import org.truffleruby.RubyContext;
import org.truffleruby.RubyLanguage;
import org.truffleruby.core.encoding.Encodings;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.kernel.KernelNodes;
import org.truffleruby.core.klass.RubyClass;
import org.truffleruby.core.regexp.EncodingCache;
import org.truffleruby.core.regexp.RegexpCacheKey;
import org.truffleruby.core.regexp.RegexpOptions;
import org.truffleruby.core.regexp.TRegexCache;
import org.truffleruby.core.regexp.TruffleRegexpNodes;
import org.truffleruby.core.string.StringUtils;
import org.truffleruby.core.string.TStringWithEncoding;
import org.truffleruby.language.ImmutableRubyObjectNotCopyable;
import org.truffleruby.language.control.DeferredRaiseException;
import org.truffleruby.language.dispatch.DispatchNode;

@ExportLibrary(value=InteropLibrary.class)
public final class RubyRegexp
extends ImmutableRubyObjectNotCopyable
implements TruffleObject,
Comparable<RubyRegexp> {
    public final Regex regex;
    public final TruffleString source;
    public final RubyEncoding encoding;
    public final RegexpOptions options;
    public final EncodingCache cachedEncodings;
    public final TRegexCache tregexCache;

    @CompilerDirectives.TruffleBoundary
    public static RubyRegexp create(RubyLanguage language, TruffleString source, RubyEncoding sourceEncoding, RegexpOptions regexpOptions, Node currentNode) throws DeferredRaiseException {
        RegexpCacheKey key;
        RubyRegexp regexp;
        TStringWithEncoding strEnc = new TStringWithEncoding(source, sourceEncoding);
        if (regexpOptions.isEncodingNone()) {
            strEnc = strEnc.forceEncoding(Encodings.BINARY);
        }
        if ((regexp = language.getRegexp(key = RegexpCacheKey.calculate(strEnc, regexpOptions))) == null) {
            RegexpOptions[] optionsArray = new RegexpOptions[]{regexpOptions};
            Regex regex = TruffleRegexpNodes.compile(null, strEnc, optionsArray, currentNode);
            regexp = new RubyRegexp(regex, optionsArray[0]);
            language.addRegexp(key, regexp);
            if (language.options.REGEXP_INSTRUMENT_CREATION) {
                (regexpOptions.isLiteral() ? TruffleRegexpNodes.LITERAL_REGEXPS : TruffleRegexpNodes.DYNAMIC_REGEXPS).add(regexp);
            }
        }
        return regexp;
    }

    private RubyRegexp(Regex regex, RegexpOptions options) {
        this.regex = regex;
        TStringWithEncoding tstringWithEncoding = (TStringWithEncoding)regex.getUserObject();
        this.source = tstringWithEncoding.tstring;
        this.encoding = tstringWithEncoding.getEncoding();
        this.options = options;
        this.cachedEncodings = new EncodingCache();
        this.tregexCache = new TRegexCache();
    }

    @ExportMessage
    protected Object toDisplayString(boolean allowSideEffects, @Cached DispatchNode dispatchNode, @Cached KernelNodes.ToSNode kernelToSNode) {
        if (allowSideEffects) {
            return dispatchNode.call(this, "inspect");
        }
        return kernelToSNode.execute(this);
    }

    @ExportMessage
    protected boolean hasMetaObject() {
        return true;
    }

    @ExportMessage
    protected RubyClass getMetaObject(@CachedLibrary(value="this") InteropLibrary node) {
        return RubyContext.get((Node)node).getCoreLibrary().regexpClass;
    }

    @Override
    public int compareTo(RubyRegexp o) {
        TruffleString b;
        TruffleString a = this.source.forceEncodingUncached(this.encoding.tencoding, Encodings.BINARY.tencoding);
        int sourceCompare = a.compareBytesUncached((AbstractTruffleString)(b = o.source.forceEncodingUncached(this.encoding.tencoding, Encodings.BINARY.tencoding)), Encodings.BINARY.tencoding);
        if (sourceCompare != 0) {
            return sourceCompare;
        }
        return this.options.compareTo(o.options);
    }

    public String toString() {
        return StringUtils.format("RubyRegexp(source = %s, options = %s, encoding = %s)", this.source, this.options, this.encoding);
    }
}

