/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.regexp;

import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.truffleruby.core.string.KCode;

public final class RegexpOptions
implements Cloneable,
Comparable<RegexpOptions> {
    public static final RegexpOptions NULL_OPTIONS = new RegexpOptions(KCode.NONE, true);
    private final KCode kcode;
    private final int options;
    private static final int FIXED = 1;
    private static final int ONCE = 2;
    private static final int EXTENDED = 4;
    private static final int MULTILINE = 8;
    private static final int IGNORECASE = 16;
    private static final int JAVA = 32;
    private static final int ENCODINGNONE = 64;
    private static final int KCODEDEFAULT = 128;
    private static final int LITERAL = 256;

    public RegexpOptions() {
        this(KCode.NONE, true);
    }

    private RegexpOptions newWithFlag(int optionMask, boolean set) {
        int newOptions = set ? this.options | optionMask : this.options & ~optionMask;
        return new RegexpOptions(this.kcode, newOptions);
    }

    public RegexpOptions(KCode kcode, boolean isKCodeDefault) {
        this(kcode, 128);
    }

    public RegexpOptions(KCode kcode, int options) {
        this.kcode = kcode;
        this.options = options;
        assert (kcode != null) : "kcode must always be set to something";
    }

    public boolean isExtended() {
        return (this.options & 4) != 0;
    }

    public RegexpOptions setExtended(boolean extended) {
        return this.newWithFlag(4, extended);
    }

    public boolean isIgnorecase() {
        return (this.options & 0x10) != 0;
    }

    public RegexpOptions setIgnorecase(boolean ignorecase) {
        return this.newWithFlag(16, ignorecase);
    }

    public boolean isFixed() {
        return (this.options & 1) != 0;
    }

    public RegexpOptions setFixed(boolean fixed) {
        return this.newWithFlag(1, fixed);
    }

    public boolean canAdaptEncoding() {
        return (this.options & 0x41) == 0;
    }

    public KCode getKCode() {
        return this.kcode;
    }

    public RegexpOptions setExplicitKCode(KCode kcode) {
        int newOptions = this.options & 0xFFFFFF7F;
        return new RegexpOptions(kcode, newOptions);
    }

    private RegexpOptions setKCodeDefault(boolean kcodedefault) {
        return this.newWithFlag(128, kcodedefault);
    }

    private KCode getExplicitKCode() {
        if (this.isKcodeDefault()) {
            return null;
        }
        return this.kcode;
    }

    public boolean isKcodeDefault() {
        return (this.options & 0x80) != 0;
    }

    public boolean isMultiline() {
        return (this.options & 8) != 0;
    }

    public RegexpOptions setMultiline(boolean multiline) {
        return this.newWithFlag(8, multiline);
    }

    public boolean isOnce() {
        return (this.options & 2) != 0;
    }

    public RegexpOptions setOnce(boolean once) {
        return this.newWithFlag(2, once);
    }

    public boolean isJava() {
        return (this.options & 0x20) != 0;
    }

    public RegexpOptions setJava(boolean java) {
        return this.newWithFlag(32, java);
    }

    public boolean isEncodingNone() {
        return (this.options & 0x40) != 0;
    }

    public RegexpOptions setEncodingNone(boolean encodingNone) {
        return this.newWithFlag(64, encodingNone);
    }

    public boolean isLiteral() {
        return (this.options & 0x100) != 0;
    }

    public RegexpOptions setLiteral(boolean literal) {
        return this.newWithFlag(256, literal);
    }

    public boolean isEmbeddable() {
        return this.isMultiline() && this.isIgnorecase() && this.isExtended();
    }

    public RegexpOptions setup() {
        KCode explicitKCode = this.getExplicitKCode();
        if (explicitKCode == null) {
            return this;
        }
        if (explicitKCode == KCode.NONE) {
            return this.setEncodingNone(true);
        }
        return this.setFixed(true);
    }

    public Encoding getEncoding() {
        KCode explicitKCode = this.getExplicitKCode();
        if (explicitKCode == null) {
            return null;
        }
        if (explicitKCode == KCode.NONE) {
            return ASCIIEncoding.INSTANCE;
        }
        return explicitKCode.getEncoding();
    }

    public int toJoniOptions() {
        int options = 0;
        if (this.isMultiline()) {
            options |= 4;
        }
        if (this.isIgnorecase()) {
            options |= 1;
        }
        if (this.isExtended()) {
            options |= 2;
        }
        return options;
    }

    public int toOptions() {
        int options = 0;
        if (this.isMultiline()) {
            options |= 4;
        }
        if (this.isIgnorecase()) {
            options |= 1;
        }
        if (this.isExtended()) {
            options |= 2;
        }
        if (this.isFixed()) {
            options |= 0x10;
        }
        if (this.isEncodingNone()) {
            options |= 0x20;
        }
        return options;
    }

    public static RegexpOptions fromEmbeddedOptions(int embeddedOptions) {
        return RegexpOptions.fromJoniOptions(embeddedOptions).setKCodeDefault((embeddedOptions & 0x200) != 0).setLiteral((embeddedOptions & 0x100) != 0).setEncodingNone((embeddedOptions & 0x20) != 0);
    }

    public static RegexpOptions fromJoniOptions(int joniOptions) {
        return new RegexpOptions().setMultiline((joniOptions & 4) != 0).setIgnorecase((joniOptions & 1) != 0).setExtended((joniOptions & 2) != 0).setFixed((joniOptions & 0x10) != 0).setOnce((joniOptions & 0x80) != 0);
    }

    public RegexpOptions withoutOnce() {
        return this.setOnce(false);
    }

    public String toOptionsString() {
        StringBuilder flags = new StringBuilder(3);
        if (this.isMultiline()) {
            flags.append('m');
        }
        if (this.isIgnorecase()) {
            flags.append('i');
        }
        if (this.isExtended()) {
            flags.append('x');
        }
        return flags.toString();
    }

    public int hashCode() {
        int hash = 7;
        hash = 11 * hash + (this.kcode != null ? this.kcode.hashCode() : 0);
        hash = 11 * hash + (this.isFixed() ? 1 : 0);
        hash = 11 * hash + (this.isOnce() ? 1 : 0);
        hash = 11 * hash + (this.isExtended() ? 1 : 0);
        hash = 11 * hash + (this.isMultiline() ? 1 : 0);
        hash = 11 * hash + (this.isIgnorecase() ? 1 : 0);
        hash = 11 * hash + (this.isJava() ? 1 : 0);
        hash = 11 * hash + (this.isEncodingNone() ? 1 : 0);
        hash = 11 * hash + (this.isKcodeDefault() ? 1 : 0);
        hash = 11 * hash + (this.isLiteral() ? 1 : 0);
        return hash;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException(cnse);
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof RegexpOptions)) {
            return false;
        }
        RegexpOptions o = (RegexpOptions)other;
        return this.options == o.options && this.kcode == o.kcode;
    }

    public String toString() {
        return "RegexpOptions(kcode: " + this.kcode + (this.isEncodingNone() ? ", encodingNone" : "") + (this.isExtended() ? ", extended" : "") + (this.isFixed() ? ", fixed" : "") + (this.isIgnorecase() ? ", ignorecase" : "") + (this.isJava() ? ", java" : "") + (this.isKcodeDefault() ? ", kcodeDefault" : "") + (this.isLiteral() ? ", literal" : "") + (this.isMultiline() ? ", multiline" : "") + (this.isOnce() ? ", once" : "") + ")";
    }

    @Override
    public int compareTo(RegexpOptions o) {
        if (this.options - o.options != 0) {
            return this.options - o.options;
        }
        return this.kcode.ordinal() - o.kcode.ordinal();
    }
}

