/*
 * Decompiled with CFR 0.152.
 */
package org.truffleruby.core.regexp;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import org.truffleruby.core.cast.ToSNode;
import org.truffleruby.core.encoding.RubyEncoding;
import org.truffleruby.core.regexp.ClassicRegexp;
import org.truffleruby.core.regexp.InterpolatedRegexpNodeFactory;
import org.truffleruby.core.regexp.RegexpOptions;
import org.truffleruby.core.regexp.RubyRegexp;
import org.truffleruby.core.string.TStringWithEncoding;
import org.truffleruby.language.NotOptimizedWarningNode;
import org.truffleruby.language.RubyBaseNode;
import org.truffleruby.language.RubyContextSourceNode;
import org.truffleruby.language.RubyNode;
import org.truffleruby.language.control.DeferredRaiseException;
import org.truffleruby.language.library.RubyStringLibrary;

public final class InterpolatedRegexpNode
extends RubyContextSourceNode {
    @Node.Children
    private final ToSNode[] children;
    @Node.Child
    private RegexpBuilderNode builderNode;
    private final RubyStringLibrary rubyStringLibrary = RubyStringLibrary.create();
    @Node.Child
    private TruffleString.AsTruffleStringNode asTruffleStringNode = TruffleString.AsTruffleStringNode.create();

    public InterpolatedRegexpNode(ToSNode[] children, RegexpOptions options) {
        this.children = children;
        this.builderNode = RegexpBuilderNode.create(options);
    }

    @Override
    public Object execute(VirtualFrame frame) {
        return this.builderNode.execute(this.executeChildren(frame));
    }

    @ExplodeLoop
    protected TStringWithEncoding[] executeChildren(VirtualFrame frame) {
        TStringWithEncoding[] values = new TStringWithEncoding[this.children.length];
        for (int i = 0; i < this.children.length; ++i) {
            Object value = this.children[i].execute(frame);
            values[i] = new TStringWithEncoding(this.asTruffleStringNode, this.rubyStringLibrary.getTString(value), this.rubyStringLibrary.getEncoding(value));
        }
        return values;
    }

    @Override
    public RubyNode cloneUninitialized() {
        InterpolatedRegexpNode copy = new InterpolatedRegexpNode(InterpolatedRegexpNode.cloneUninitialized(this.children), this.builderNode.options);
        return copy.copyFlags(this);
    }

    protected static ToSNode[] cloneUninitialized(ToSNode[] nodes) {
        ToSNode[] copies = new ToSNode[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            copies[i] = (ToSNode)nodes[i].cloneUninitialized();
        }
        return copies;
    }

    public static abstract class RegexpBuilderNode
    extends RubyBaseNode {
        @Node.Child
        private TruffleString.EqualNode equalNode = TruffleString.EqualNode.create();
        private final RegexpOptions options;

        public static RegexpBuilderNode create(RegexpOptions options) {
            return InterpolatedRegexpNodeFactory.RegexpBuilderNodeGen.create(options);
        }

        public RegexpBuilderNode(RegexpOptions options) {
            this.options = options;
        }

        public abstract Object execute(TStringWithEncoding[] var1);

        @Specialization(guards={"tstringsWithEncodingsMatch(cachedParts, parts)"}, limit="getDefaultCacheLimit()")
        Object fast(TStringWithEncoding[] parts, @Cached(value="parts", dimensions=1) TStringWithEncoding[] cachedParts, @Cached(value="createRegexp(cachedParts)") RubyRegexp regexp) {
            return regexp;
        }

        @Specialization(replaces={"fast"})
        Object slow(TStringWithEncoding[] parts, @Cached NotOptimizedWarningNode notOptimizedWarningNode) {
            notOptimizedWarningNode.warn("unstable interpolated regexps are not optimized");
            return this.createRegexp(parts);
        }

        @ExplodeLoop
        protected boolean tstringsWithEncodingsMatch(TStringWithEncoding[] a, TStringWithEncoding[] b) {
            for (int i = 0; i < a.length; ++i) {
                RubyEncoding aEncoding = a[i].encoding;
                if (aEncoding != b[i].encoding) {
                    return false;
                }
                if (this.equalNode.execute((AbstractTruffleString)a[i].tstring, (AbstractTruffleString)b[i].tstring, aEncoding.tencoding)) continue;
                return false;
            }
            return true;
        }

        @CompilerDirectives.TruffleBoundary
        protected RubyRegexp createRegexp(TStringWithEncoding[] strings) {
            try {
                TStringWithEncoding preprocessed = ClassicRegexp.preprocessDRegexp(this.getContext(), strings, this.options);
                return RubyRegexp.create(this.getLanguage(), preprocessed.tstring, preprocessed.encoding, this.options, this);
            }
            catch (DeferredRaiseException dre) {
                throw dre.getException(this.getContext());
            }
        }
    }
}

